/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.InteractiveDetectorPrtl;
import com.sun.patchpro.analysis.NoninteractiveException;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.Interaction;
import com.sun.patchpro.util.InteractionSet;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.QuestionTrueFalse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ConfirmationPageInteractiveDetector
extends InteractiveDetectorPrtl {
    private PatchProProperties properties;
    private LocalizedMessages msgcat;
    private PatchProLog log;
    private int interactionType = 0;
    int interactionSize;
    private String[] listOfRealizations = null;
    private String comment = "#VERSION 1.0\n";
    private Host currentHost = null;

    public ConfirmationPageInteractiveDetector() {
        try {
            this.log = PatchProLog.getInstance();
            this.initialize(this.listOfRealizations);
            this.properties = PatchProProperties.getInstance();
            this.msgcat = new LocalizedMessages(this.properties.getLocale());
            this.statusMessage = this.msgcat.getMessage("CliConfirmationPageStatusMessage", "The following is the hardware that you selected for this system. If there are errors, reissue 'pprosetup -H' and select hardware.");
        }
        catch (Exception exception) {
            throw new Error("The Confirmation Detector couldn't even start.:" + exception.getMessage());
        }
    }

    public InteractionSet analyze(Host host) throws NoninteractiveException, DetectorFailedException {
        Vector<String> vector = new Vector<String>();
        Realization realization = null;
        Enumeration enumeration = host.getRealizations();
        this.currentHost = host;
        while (enumeration.hasMoreElements()) {
            realization = (Realization)enumeration.nextElement();
            vector.addElement(realization.getRealizationString());
        }
        Interaction[] interactionArray = new Interaction[vector.size() + 4];
        for (int i = 0; i < vector.size() + 2; ++i) {
            if (i == 0) {
                if (vector.size() > 0) {
                    interactionArray[i] = new Interaction(this.msgcat.getMessage("reselect.list", "List of products that were manually selected."));
                    continue;
                }
                interactionArray[i] = new Interaction(this.msgcat.getMessage("noselection.list", "No products were manually selected."));
                continue;
            }
            interactionArray[i] = i == 1 ? new Interaction(" ") : new Interaction("  " + this.msgcat.getMessage((String)vector.elementAt(i - 2), ""));
        }
        interactionArray[i++] = new Interaction(" ");
        interactionArray[i] = new QuestionTrueFalse(this.msgcat.getMessage("save.state", "Save selections?"));
        this.interactionSet = this.constructInteractionSet(interactionArray, this.interactionType);
        return this.interactionSet;
    }

    public void setInteractionSet(InteractionSet interactionSet) throws DetectorFailedException {
        Interaction interaction = null;
        QuestionTrueFalse questionTrueFalse = null;
        String string = this.properties.getProperty("patchpro.hdw.save.path");
        File file = new File(string);
        Long l = new Long(System.currentTimeMillis());
        File file2 = new File(string + l.toString());
        this.interactionSet = interactionSet;
        interactionSet.reset();
        while (interactionSet.hasMoreInteractions()) {
            interaction = interactionSet.nextInteraction();
        }
        try {
            questionTrueFalse = (QuestionTrueFalse)interaction;
            Enumeration enumeration = this.currentHost.getRealizations();
            if (questionTrueFalse.getAnswer()) {
                System.out.println("The selections are saved");
                if (file2 != null) {
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    PrintStream printStream = new PrintStream(fileOutputStream);
                    printStream.print(this.comment);
                    while (enumeration.hasMoreElements()) {
                        Realization realization = null;
                        String string2 = null;
                        realization = (Realization)enumeration.nextElement();
                        string2 = realization.getRealizationString();
                        printStream.print(string2 + "\n");
                    }
                    printStream.close();
                    file2.renameTo(file);
                }
            } else {
                System.out.println("The selections are not saved");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception exception) {
            throw new DetectorFailedException("Encountered unknown exception: " + exception.getMessage());
        }
    }
}

