/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.RealizationDetector;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.InvalidVersionException;
import com.sun.patchpro.util.Version;
import java.util.Enumeration;
import java.util.Vector;

public abstract class RealizationDetectorPrtl
implements RealizationDetector {
    protected Vector applicableRealizations;
    protected Vector requiredRealizations;
    protected String statusMessage;
    protected PatchProLog log = PatchProLog.getInstance();

    public Enumeration getRealizations() {
        return this.applicableRealizations.elements();
    }

    public Enumeration getRequiredRealizations() throws NoSuchRealizationException {
        if (this.hasRealizationDependency()) {
            return this.requiredRealizations.elements();
        }
        throw new NoSuchRealizationException("This Realization detector has no realization depemndencies.");
    }

    public boolean hasRealizationDependency() {
        if (this.requiredRealizations == null) {
            return false;
        }
        return !this.requiredRealizations.isEmpty();
    }

    public String getMessage() {
        return this.statusMessage;
    }

    protected void initialize(String string, String[] stringArray) throws DetectorFailedException {
        this.applicableRealizations = new Vector();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Realization realization = this.constructRealization(string, stringArray[i]);
                this.applicableRealizations.addElement(realization);
            }
        }
    }

    private Realization constructRealization(String string, String string2) throws DetectorFailedException {
        try {
            return new Realization(string, new Version(string2));
        }
        catch (NoSuchRealizationException noSuchRealizationException) {
            throw new DetectorFailedException(noSuchRealizationException.getMessage());
        }
        catch (InvalidVersionException invalidVersionException) {
            throw new DetectorFailedException(invalidVersionException.getMessage());
        }
    }
}

