/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.entitlement;

import com.sun.cc.platform.entitlement.service.client.EntitlementServiceIF;
import com.sun.cc.platform.entitlement.service.client.EntitlementService_Impl;
import com.sun.patchpro.entitlement.EntitlementData;
import com.sun.patchpro.entitlement.EntitlementServiceException;
import com.sun.patchpro.entitlement.EntitlementServiceRemoteException;
import com.sun.patchpro.model.PatchProProperties;
import java.rmi.RemoteException;
import javax.xml.rpc.Stub;

public class EntitlementServices {
    private String endpointAddress;
    private String filterName;
    private Stub serviceStub = null;
    private boolean debug = false;

    public EntitlementServices() {
        PatchProProperties patchProProperties = PatchProProperties.getInstance();
        this.endpointAddress = patchProProperties.getProperty("patchsvr.entitlement.ws.endpointaddress", "USE_DEFAULT");
        this.debug = patchProProperties.getProperty("patchpro.debug", "false").equals("true");
        this.filterName = patchProProperties.getProperty("patchsvr.entitlement.ws.filtername", "SWUP_APP");
        if (this.debug) {
            System.out.println("Entitlement web service end point :" + this.endpointAddress);
        }
        this.serviceStub = this.createProxy();
    }

    public EntitlementData getEntitlementData(String string, String string2) throws EntitlementServiceException {
        Object object;
        String[] stringArray = null;
        EntitlementServiceIF entitlementServiceIF = (EntitlementServiceIF)this.serviceStub;
        try {
            object = entitlementServiceIF.getAssetEntitlements(string, string2);
            if (object.getErrorMessage() != null) {
                throw new EntitlementServiceException(object.getErrorMessage().getMessage());
            }
            stringArray = object.getEntitlements();
        }
        catch (RemoteException remoteException) {
            throw new EntitlementServiceRemoteException(remoteException.getMessage(), remoteException);
        }
        object = new EntitlementData(string, string2);
        ((EntitlementData)object).setEntitledTokens(stringArray);
        return object;
    }

    public EntitlementData getPatchEntitlementData(String string) throws EntitlementServiceException {
        return this.getEntitlementData(string, this.filterName);
    }

    private Stub createProxy() {
        Stub stub = (Stub)new EntitlementService_Impl().getEntitlementServiceIFPort();
        if (this.endpointAddress == null || !this.endpointAddress.equals("USE_DEFAULT")) {
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.endpointAddress);
        }
        return stub;
    }

    private String[] getDummyEntitlementTokens() {
        String[] stringArray = new String[]{"FAKE_TOKEN1", "FAKE_TOKEN2", "FAKE_TOKEN_RANDOMINT_" + Math.random()};
        return stringArray;
    }
}

