/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.patch;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.InvalidPatchProvidedException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.SequencerEvent;
import com.sun.patchpro.model.SequencerListener;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchSequencer;
import com.sun.patchpro.util.Percentage;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class GroupPatchSequencer
implements SequencerListener {
    private int hostCount = 1;
    private int hostsRemaining = 1;
    private Percentage progress = new Percentage(0);
    private Vector listeners;
    private PatchProLog log;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private PatchSequencer localPatchSequencer;
    private ReadOnlyHost targetHost;
    private Locale locale;
    private static String DEFAULT_PROGRESS_MESSAGE = "Analyzing System";
    static final String INVALID_PATCH_PROVIDED = "Provided patch ID is not readable or is otherwise malformed. Please check the provided patch IDs and retry the command.";

    public GroupPatchSequencer(ReadOnlyHost readOnlyHost, Locale locale) {
        this.log = PatchProLog.getInstance();
        this.listeners = new Vector();
        this.targetHost = readOnlyHost;
        this.locale = locale;
    }

    public void getPatchLists() throws Exception {
        Object object;
        PatchProProperties patchProProperties;
        PatchListImpl patchListImpl = null;
        PatchListImpl patchListImpl2 = null;
        String string = null;
        this.hostCount = this.hostsRemaining = this.targetHost.getAssociateCount() + 1;
        SessionData sessionData = this.targetHost.getSessionData();
        if (!sessionData.getIgnoreStatus()) {
            this.localPatchSequencer = new PatchSequencer(sessionData.getInterpreter(), sessionData.getPatchDB(), this.locale);
            try {
                this.localPatchSequencer.addSequencerListener(this);
                patchProProperties = sessionData.getProperties();
                object = patchProProperties.getHostSpecificProperties(this.targetHost);
                string = ((PatchProProperties)object).getProperty("patchpro.patches.provided", "");
                if (string == null || string.equals("")) {
                    this.log.println(this, 7, "GroupPatchSequencer.getPatchLists(): No patch IDs provided. target host is " + this.targetHost);
                    patchListImpl = this.localPatchSequencer.getPatchList(this.targetHost.getRealizations(), this.targetHost.getPatchesDtl());
                } else {
                    patchListImpl2 = this.localPatchSequencer.getPatchList(this.targetHost.getRealizations(), this.targetHost.getPatchesDtl());
                    PatchID[] patchIDArray = this.getPatchIDs(string);
                    patchListImpl = this.localPatchSequencer.augmentPatchList(patchIDArray, this.targetHost.getPatchesDtl());
                    for (int i = 0; i < patchListImpl2.size(); ++i) {
                        patchListImpl.replaceIPatch(patchListImpl2.getIPatchAt(i));
                    }
                    patchListImpl2 = null;
                }
                this.localPatchSequencer.removeSequencerListener(this);
                for (int i = 0; i < patchListImpl.size(); ++i) {
                    patchListImpl.setSelectionStatus(i, true);
                }
                sessionData.setPatchesRequired(patchListImpl);
            }
            catch (MalformedPatchException malformedPatchException) {
                this.localPatchSequencer.removeSequencerListener(this);
                this.log.println(this, 3, "GroupPatchSequencer.getPatchLists(): " + malformedPatchException.getMessage());
                sessionData.addPatchProException(new InvalidPatchProvidedException("InvalidPatchProvidedException", "InvalidPatchProvidedException.MESSAGE", "InvalidPatchProvidedException.REMEDY", 3));
                this.sequencerProgress(null);
                this.sequencerDone(null);
                this.sequencerFailed(new SequencerEvent(this, PatchProLog.createMessage(3, INVALID_PATCH_PROVIDED)));
            }
        } else {
            this.sequencerProgress(null);
            this.sequencerDone(null);
        }
        object = this.targetHost.getAssociates();
        while (object.hasMoreElements()) {
            ReadOnlyHost readOnlyHost = (ReadOnlyHost)object.nextElement();
            sessionData = readOnlyHost.getSessionData();
            if (!sessionData.getIgnoreStatus()) {
                this.localPatchSequencer = new PatchSequencer(sessionData.getInterpreter(), sessionData.getPatchDB(), this.locale);
                try {
                    this.localPatchSequencer.addSequencerListener(this);
                    patchProProperties = sessionData.getProperties();
                    string = patchProProperties.getProperty("patchpro.patches.provided", "");
                    if (string == null || string.equals("")) {
                        patchListImpl = this.localPatchSequencer.getPatchList(readOnlyHost.getRealizations(), readOnlyHost.getPatchesDtl());
                    } else {
                        patchListImpl2 = this.localPatchSequencer.getPatchList(readOnlyHost.getRealizations(), readOnlyHost.getPatchesDtl());
                        PatchID[] patchIDArray = this.getPatchIDs(string);
                        patchListImpl = this.localPatchSequencer.augmentPatchList(patchIDArray, readOnlyHost.getPatchesDtl());
                        for (int i = 0; i < patchListImpl2.size(); ++i) {
                            patchListImpl.replaceIPatch(patchListImpl2.getIPatchAt(i));
                        }
                        patchListImpl2 = null;
                    }
                    this.localPatchSequencer.removeSequencerListener(this);
                    for (int i = 0; i < patchListImpl.size(); ++i) {
                        patchListImpl.setSelectionStatus(i, true);
                    }
                    sessionData.setPatchesRequired(patchListImpl);
                }
                catch (Exception exception) {
                    this.localPatchSequencer.removeSequencerListener(this);
                    this.log.println(this, 3, "GroupPatchSequencer.getPatchLists(): " + exception.getMessage());
                    sessionData.addPatchProException(new InvalidPatchProvidedException("InvalidPatchProvidedException", "InvalidPatchProvidedException.MESSAGE", "InvalidPatchProvidedException.REMEDY", 3));
                    this.sequencerProgress(null);
                    this.sequencerDone(null);
                    this.sequencerFailed(new SequencerEvent(this, PatchProLog.createMessage(3, INVALID_PATCH_PROVIDED)));
                }
                continue;
            }
            this.sequencerProgress(null);
            this.sequencerDone(null);
        }
    }

    private PatchID[] getPatchIDs(String string) throws MalformedPatchException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        PatchID[] patchIDArray = new PatchID[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            patchIDArray[n] = new PatchID(stringTokenizer.nextToken());
            ++n;
        }
        return patchIDArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        GroupPatchSequencer groupPatchSequencer = this;
        synchronized (groupPatchSequencer) {
            this.localPatchSequencer.cancel();
        }
    }

    public Percentage getStatus() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSequencerListener(SequencerListener sequencerListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(sequencerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSequencerListener(SequencerListener sequencerListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sequencerProgress(SequencerEvent sequencerEvent) {
        int n = sequencerEvent == null ? 100 : ((PatchSequencer)sequencerEvent.getSource()).getStatus().getPercentage();
        Percentage percentage = this.progress;
        synchronized (percentage) {
            this.progress = new Percentage((int)(((double)(this.hostCount - this.hostsRemaining) * 100.0 + (double)n) / (double)this.hostCount));
        }
        if (sequencerEvent == null) {
            this.dispatchProgressEvent(new SequencerEvent(this, DEFAULT_PROGRESS_MESSAGE));
        } else {
            this.dispatchProgressEvent(new SequencerEvent(this, sequencerEvent.getErrorMessage()));
        }
    }

    public void sequencerDone(SequencerEvent sequencerEvent) {
        if (--this.hostsRemaining == 0) {
            this.dispatchDoneEvent(new SequencerEvent(this));
        }
    }

    public void sequencerFailed(SequencerEvent sequencerEvent) {
        this.dispatchFailedEvent(new SequencerEvent(this, sequencerEvent.getErrorMessage()));
    }

    private void dispatchProgressEvent(SequencerEvent sequencerEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            SequencerListener sequencerListener = (SequencerListener)enumeration.nextElement();
            sequencerListener.sequencerProgress(sequencerEvent);
        }
    }

    private void dispatchDoneEvent(SequencerEvent sequencerEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            SequencerListener sequencerListener = (SequencerListener)enumeration.nextElement();
            sequencerListener.sequencerDone(sequencerEvent);
        }
    }

    private void dispatchFailedEvent(SequencerEvent sequencerEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            SequencerListener sequencerListener = (SequencerListener)enumeration.nextElement();
            sequencerListener.sequencerFailed(sequencerEvent);
        }
    }
}

