/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.security;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchProRuntimeException;
import com.sun.patchpro.security.ManifestFileNotFoundException;
import com.sun.patchpro.security.NoKeystorePresentException;
import com.sun.patchpro.security.NoSigningCertException;
import com.sun.patchpro.security.NotSignedByKnownCertificateException;
import com.sun.patchpro.security.SignatureCheckFailedException;
import com.sun.patchpro.security.SignatureValidationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class SignatureValidationUtil {
    private static final int BUFFER_SIZE = 8192;
    private static final String NO_X509_CERT_FOUND = "The specified certificate cannot be found.";
    private static final String NOT_X509_CERT = "The specified certificate is not in X.509 format.";
    private static final String JARFILE_NOT_READABLE = "The specific Jar file is not readable.";
    private PatchProLog log;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private X509Certificate knownCertificate;
    private String keystoreLocation = null;
    private String certificateAlias = null;

    public SignatureValidationUtil(String string, String string2) throws SignatureValidationException, PatchProException {
        Certificate certificate;
        this.log = PatchProLog.getInstance();
        this.keystoreLocation = string;
        this.certificateAlias = string2;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            KeyStore keyStore = KeyStore.getInstance("JKS", "SUN");
            keyStore.load(fileInputStream, null);
            certificate = keyStore.getCertificate(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PatchProException("Error reading keystore: " + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new PatchProException("Error reading " + string + ": " + iOException.getMessage(), iOException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new PatchProRuntimeException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PatchProRuntimeException(noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new PatchProRuntimeException(noSuchProviderException);
        }
        catch (CertificateException certificateException) {
            throw new PatchProRuntimeException(certificateException);
        }
        if (certificate == null) {
            throw new SignatureValidationException(NO_X509_CERT_FOUND);
        }
        if (!(certificate instanceof X509Certificate)) {
            throw new SignatureValidationException(NOT_X509_CERT);
        }
        this.knownCertificate = (X509Certificate)certificate;
    }

    public String getKeystoreLocation() {
        return this.keystoreLocation;
    }

    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public void validateJarFile(String string) throws ManifestFileNotFoundException, SignatureCheckFailedException, NotSignedByKnownCertificateException, SignatureValidationException {
        boolean bl = true;
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw new SignatureValidationException(JARFILE_NOT_READABLE);
        }
        try {
            JarFile jarFile = new JarFile(string, true);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                jarFile.close();
                throw new ManifestFileNotFoundException();
            }
            byte[] byArray = new byte[8192];
            boolean bl2 = true;
            Enumeration<JarEntry> enumeration = jarFile.entries();
            InputStream inputStream = null;
            JarEntry jarEntry = null;
            while (enumeration.hasMoreElements()) {
                bl2 = true;
                jarEntry = enumeration.nextElement();
                if (jarEntry.getSize() == 0L) {
                    this.log.println(this, 7, "Skipping " + jarEntry.getName() + " because its length is: 0 byte.");
                    continue;
                }
                try {
                    inputStream = jarFile.getInputStream(jarEntry);
                    int n = 0;
                    while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    }
                }
                catch (SecurityException securityException) {
                    bl2 = false;
                    bl = false;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    throw new SignatureCheckFailedException();
                }
                inputStream.close();
                if (!bl2 || jarEntry.getName().indexOf("META-INF") != -1 || this.matchCerts(this.knownCertificate, jarEntry.getCertificates())) continue;
                bl = false;
                jarFile.close();
                throw new NotSignedByKnownCertificateException(jarEntry.getName() + " " + this.knownCertificate.getSubjectDN().getName());
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            bl = false;
            this.log.printStackTrace(this, 4, iOException);
            throw new SignatureValidationException(iOException.getMessage());
        }
    }

    private boolean matchCerts(Certificate certificate, Certificate[] certificateArray) {
        if (!(certificate instanceof X509Certificate)) {
            this.log.println(this, 4, "The known certificate: " + certificate + "  is not a X.509 certificate.");
            return false;
        }
        Principal principal = ((X509Certificate)certificate).getIssuerDN();
        BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
        if (certificateArray == null || certificateArray.length == 0) {
            this.log.println(this, 4, "The signing certificates (signingCerts) is null.");
            return false;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            if (!(certificateArray[i] instanceof X509Certificate)) {
                return false;
            }
            X509Certificate x509Certificate = (X509Certificate)certificateArray[i];
            if (principal.getName().compareTo(x509Certificate.getIssuerDN().getName()) != 0 || bigInteger.compareTo(x509Certificate.getSerialNumber()) != 0) continue;
            return true;
        }
        return false;
    }

    public static SignatureValidationUtil getValidationUtility(PatchProProperties patchProProperties, SignatureValidationUtil signatureValidationUtil) throws NoKeystorePresentException, NoSigningCertException, PatchProException {
        SignatureValidationUtil signatureValidationUtil2 = null;
        if (signatureValidationUtil != null) {
            signatureValidationUtil2 = signatureValidationUtil;
        } else {
            if (!patchProProperties.keystoreIsPresent()) {
                throw new NoKeystorePresentException("PatchBundleInstaller.KEYSTORE_LOCATION_NOT_DEFINED");
            }
            String string = patchProProperties.getProperty("patchpro.security.kslocation");
            String string2 = patchProProperties.getProperty("patchpro.security.patch.signingcert.alias");
            signatureValidationUtil2 = new SignatureValidationUtil(string, string2);
        }
        return signatureValidationUtil2;
    }
}

