/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.entitlement.EntitlementData;
import com.sun.patchpro.entitlement.EntitlementServiceException;
import com.sun.patchpro.entitlement.EntitlementServiceRemoteException;
import com.sun.patchpro.entitlement.EntitlementServices;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.server.DownloadEntitlementFileException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Random;

public class EntitlementUtil {
    private String patchSourceLocation;
    private String patchSourceEntitlementFile;
    private String cacheLocation;
    private String entitlement_name;
    private int expiredTime;
    private long maxcacheTime;
    private EntitlementServices eservice;
    private Random Rgenerator;
    private boolean debug = false;
    private boolean isdeliveryserver = false;

    public EntitlementUtil(String string) {
        this.patchSourceLocation = string;
        PatchProProperties patchProProperties = PatchProProperties.getInstance();
        this.entitlement_name = patchProProperties.getProperty("patchro.entitlement.name", "entitlement");
        this.isdeliveryserver = patchProProperties.getProperty("patchpro.isdeliveryserver", "false").equals("true");
        this.cacheLocation = patchProProperties.getProperty("patchsvr.cache.location", "/tmp");
        String string2 = patchProProperties.getProperty("patchsvr.entitlement.cache.ws.age");
        this.debug = patchProProperties.getProperty("patchpro.debug").equals("true");
        this.cacheLocation = this.cacheLocation + File.separator + this.entitlement_name + File.separator;
        this.patchSourceEntitlementFile = this.patchSourceLocation + File.separator + this.entitlement_name + File.separator + this.entitlement_name + "_patchsource";
        try {
            File file = new File(this.cacheLocation);
            if (!file.isDirectory()) {
                file.mkdir();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.expiredTime = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            this.debugLog("Cannot find entitlement file expiration time: " + exception.getMessage());
            this.expiredTime = 1;
        }
        this.maxcacheTime = this.getMiliSecsByHours(this.expiredTime);
        if (this.isdeliveryserver) {
            this.eservice = new EntitlementServices();
        }
        this.Rgenerator = new Random();
    }

    public File downloadEntitlementFile(String string) throws DownloadEntitlementFileException {
        return this.downloadEntitlementFile(string, true);
    }

    public File downloadEntitlementFile(String string, boolean bl) throws DownloadEntitlementFileException {
        File file = null;
        if (!this.isdeliveryserver) {
            file = new File(this.getEntitlementFileNameFromPatchSource());
            try {
                if (file.createNewFile()) {
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write("*\n");
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {
                throw new DownloadEntitlementFileException("Error cannot Create entitlement file " + file + ".", iOException);
            }
            return file;
        }
        file = new File(this.mapAssetID2EntitlementFullFileName(string));
        if (file.exists() && bl && !this.isEntitlementFileExpired(file)) {
            return file;
        }
        this.debugLog("Cache miss for entitlement of " + string);
        try {
            EntitlementData entitlementData = this.getEntitlementData(string);
            this.writeEntitlementFile(file, entitlementData);
        }
        catch (IOException iOException) {
            throw new DownloadEntitlementFileException(iOException.getMessage());
        }
        catch (EntitlementServiceRemoteException entitlementServiceRemoteException) {
            return this.getLatestEntitlementResponse(string);
        }
        catch (EntitlementServiceException entitlementServiceException) {
            throw new DownloadEntitlementFileException(entitlementServiceException.getMessage());
        }
        return file;
    }

    private void writeEntitlementFile(File file, EntitlementData entitlementData) throws IOException {
        int n = this.Rgenerator.nextInt(5000);
        File file2 = new File(file.getParent(), file.getName() + "." + n);
        String[] stringArray = entitlementData.getEntitledTokens();
        file2.createNewFile();
        FileWriter fileWriter = new FileWriter(file2);
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            fileWriter.write(stringArray[i] + "\n", 0, stringArray[i].length() + 1);
        }
        fileWriter.close();
        file2.renameTo(file);
    }

    private boolean isEntitlementFileExpired(File file) {
        if (!file.exists()) {
            return false;
        }
        long l = System.currentTimeMillis() - file.lastModified();
        return l > this.maxcacheTime;
    }

    public String mapAssetID2EntitlementFullFileName(String string) {
        return this.cacheLocation + this.entitlement_name + "_" + URLEncoder.encode(string);
    }

    public String getDefaultEntitlementFullFileName() {
        return this.cacheLocation + this.entitlement_name + "_PATCHPRODEFAULT";
    }

    public String getEntitlementFileNameFromPatchSource() {
        return this.patchSourceEntitlementFile;
    }

    private EntitlementData getEntitlementData(String string) throws EntitlementServiceException {
        return this.eservice.getPatchEntitlementData(string);
    }

    private long getMiliSecsByHours(int n) {
        return n * 3600000;
    }

    private long getMiliSecsByDays(int n) {
        return (long)n * this.getMiliSecsByHours(24);
    }

    private void debugLog(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    private File getLatestEntitlementResponse(String string) throws DownloadEntitlementFileException {
        int n = this.Rgenerator.nextInt(5000);
        try {
            File file = new File(this.mapAssetID2EntitlementFullFileName(string));
            if (file.exists()) {
                return file;
            }
            File file2 = new File(file.getParent(), file.getName() + "." + n);
            file2.createNewFile();
            file2.deleteOnExit();
            FileWriter fileWriter = new FileWriter(file2);
            fileWriter.write("*\n");
            fileWriter.close();
            return file2;
        }
        catch (IOException iOException) {
            throw new DownloadEntitlementFileException(iOException.getMessage());
        }
    }
}

