/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.ExpectSession;
import com.sun.patchpro.util.InteractiveSession;
import com.sun.patchpro.util.InteractiveSessionException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.GregorianCalendar;
import java.util.Vector;

public abstract class InteractiveSessionPrtl
implements InteractiveSession {
    protected static final String CR = "\r";
    protected static final String NL = "\n";
    private BufferedReader pStdOut = null;
    private BufferedReader pStdErr = null;
    private ByteArrayOutputStream byteArray = null;
    private ByteArrayOutputStream sessionByteArray = null;
    private Process process = null;
    private OutputStreamWriter writer = null;
    private Vector expectSessionList = new Vector();
    private PatchProProperties properties;
    private PatchProLog log = PatchProLog.getInstance();
    private boolean terminate = false;
    private boolean debug = false;

    public InteractiveSessionPrtl() {
        this.properties = PatchProProperties.getInstance();
        this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
    }

    public void send(String string) throws InteractiveSessionException {
        try {
            this.writer.write(string);
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
            throw new InteractiveSessionException(iOException.getMessage());
        }
    }

    public void send(String string, int n) throws InteractiveSessionException {
        try {
            this.resetBuffer();
            this.writer.write(string);
            this.writer.flush();
            while (this.byteArray.size() == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Wait process interrupted ...");
                    throw new InteractiveSessionException("Interactive Session Interrupted");
                }
            }
            this.waitUntilQuiesed(n);
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
            throw new InteractiveSessionException(iOException.getMessage());
        }
    }

    public boolean waitfor(String string) {
        return this.waitfor(string, 5000);
    }

    public boolean waitfor(String string, int n) {
        boolean bl = false;
        int n2 = 1;
        int n3 = 1;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.add(14, n);
        while (gregorianCalendar.before(gregorianCalendar2)) {
            if (this.byteArray.toString().indexOf(string) != -1) {
                bl = true;
                gregorianCalendar = null;
                System.gc();
                break;
            }
            try {
                Thread.sleep(1000L);
                gregorianCalendar = null;
                System.gc();
                if (n2 % 10 == 0) {
                    if (n3++ % 70 == 0) {
                        System.out.print("\n.");
                    } else {
                        System.out.print(".");
                    }
                }
                ++n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            gregorianCalendar = new GregorianCalendar();
        }
        return bl;
    }

    public void waitfor(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            this.log.printStackTrace(this, 2, interruptedException);
        }
    }

    public boolean expectedResponse(String string, String string2) {
        return this.expectedResponse(string, string2, 5000);
    }

    public boolean expectedResponse(String string, String string2, int n) {
        try {
            this.resetBuffer();
            this.send(string);
            while (this.byteArray.size() == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Wait process interrupted ...");
                    return false;
                }
            }
            return this.waitfor(string2, n);
        }
        catch (InteractiveSessionException interactiveSessionException) {
            return false;
        }
    }

    public void expect(String string, String string2) {
        for (int i = 0; i < this.expectSessionList.size(); ++i) {
            ExpectSession expectSession = (ExpectSession)this.expectSessionList.elementAt(i);
            if (!expectSession.getPattern().equals(string)) continue;
            expectSession.setResponse(string2);
            return;
        }
        this.expectSessionList.addElement(new ExpectSession(string, string2));
    }

    public void expectRemove(String string) {
        ExpectSession expectSession;
        int n;
        for (n = 0; n < this.expectSessionList.size() && !(expectSession = (ExpectSession)this.expectSessionList.elementAt(n)).getPattern().equals(string); ++n) {
        }
        if (n < this.expectSessionList.size()) {
            this.expectSessionList.removeElementAt(n);
        } else {
            this.log.println(this, 4, "expectRemove(): Session pattern not registered" + string);
        }
    }

    public String getSessionMessages() {
        return this.byteArray.toString();
    }

    public String getAllSessionMessages() {
        return this.sessionByteArray.toString();
    }

    protected BufferedReader getStdInputReader() {
        return this.pStdOut;
    }

    public boolean getTerminateStatus() {
        return this.terminate;
    }

    public void setTerminateStatus() {
        this.terminate = true;
    }

    protected void setStdInputReader(BufferedReader bufferedReader) {
        this.pStdOut = bufferedReader;
    }

    protected void closeStdInputReader() {
        try {
            if (this.pStdOut != null) {
                this.pStdOut.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected BufferedReader getStdErrorReader() {
        return this.pStdErr;
    }

    protected void setStdErrorReader(BufferedReader bufferedReader) {
        this.pStdErr = bufferedReader;
    }

    protected void closeStdErrorReader() {
        try {
            if (this.pStdErr != null) {
                this.pStdErr.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected ByteArrayOutputStream getArrayOutputStream() {
        return this.byteArray;
    }

    protected void setArrayOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
        this.byteArray = byteArrayOutputStream;
    }

    protected ByteArrayOutputStream getSessionArrayOutputStream() {
        return this.sessionByteArray;
    }

    protected void setSessionArrayOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
        this.sessionByteArray = byteArrayOutputStream;
    }

    protected void setOutPutStreamWriter(OutputStreamWriter outputStreamWriter) {
        this.writer = outputStreamWriter;
    }

    protected void closeOutPutStreamWriter() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Vector getExpectSessionList() {
        return this.expectSessionList;
    }

    private void resetBuffer() {
        this.byteArray.reset();
    }

    private void waitUntilQuiesed(int n) {
        int n2 = 0;
        int n3 = 0;
        do {
            n3 = this.byteArray.size();
            this.waitfor(n / 10);
            if (n3 != this.byteArray.size()) continue;
            ++n2;
        } while (n2 != 10);
    }
}

