/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.util.NumberOutOfRangeException;
import com.sun.patchpro.util.Schedule;
import java.util.StringTokenizer;

public class SunOSSchedule
extends Schedule {
    public static final String EACHSTRING = "*";
    public static final int EACH = -1;

    public SunOSSchedule() {
    }

    public SunOSSchedule(int n, int n2, int n3, int n4, int n5, int n6, String string) throws NumberOutOfRangeException {
        super(n, n2, n3, n4, n5, n6, string);
    }

    public SunOSSchedule(String string) throws NumberOutOfRangeException, IllegalArgumentException {
        this.useCrontabEntry(string);
    }

    public SunOSSchedule cloneSunOSSchedule() {
        SunOSSchedule sunOSSchedule = new SunOSSchedule();
        super.cloneSchedule(sunOSSchedule);
        return sunOSSchedule;
    }

    public void useCrontabEntry(String string) throws NumberOutOfRangeException, IllegalArgumentException {
        if (string.indexOf("#") != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) {
                this.log.println(this, 4, "No minute.");
                throw new IllegalArgumentException("Faulty crontab entry.");
            }
            this.setMinute(this.stringToInt(stringTokenizer.nextToken()));
            if (!stringTokenizer.hasMoreTokens()) {
                this.log.println(this, 4, "No hour.");
                throw new IllegalArgumentException("Faulty crontab entry.");
            }
            this.setHour(this.stringToInt(stringTokenizer.nextToken()));
            if (!stringTokenizer.hasMoreTokens()) {
                this.log.println(this, 4, "No day of month.");
                throw new IllegalArgumentException("Faulty crontab entry.");
            }
            this.setDayOfMonth(this.stringToInt(stringTokenizer.nextToken()));
            if (!stringTokenizer.hasMoreTokens()) {
                this.log.println(this, 4, "No month.");
                throw new IllegalArgumentException("Faulty crontab entry.");
            }
            this.setMonth(this.stringToInt(stringTokenizer.nextToken()));
            if (!stringTokenizer.hasMoreTokens()) {
                this.log.println(this, 4, "No day of week.");
                throw new IllegalArgumentException("Faulty crontab entry.");
            }
            this.setDayOfWeek(this.stringToInt(stringTokenizer.nextToken()));
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(" " + stringTokenizer.nextToken());
            }
            this.setCommand(stringBuffer.toString());
            if (this.onMonth >= 1) {
                this.setFrequency(5);
            } else if (this.onDayOfWeek >= 0) {
                this.setFrequency(3);
            } else if (this.onDayOfMonth >= 0) {
                this.setFrequency(4);
            } else {
                this.setFrequency(2);
            }
        }
    }

    public String getCrontabEntry() {
        String string = "";
        if (this.isComplete()) {
            string = this.intToString(this.onMinute) + " " + this.intToString(this.onHour) + " " + this.intToString(this.onDayOfMonth) + " " + this.intToString(this.onMonth) + " " + this.intToString(this.onDayOfWeek) + " " + this.command;
        }
        return string;
    }

    private int stringToInt(String string) throws NumberOutOfRangeException {
        int n;
        if (string.compareTo(EACHSTRING) == 0) {
            n = -1;
        } else {
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberOutOfRangeException(numberFormatException.getMessage());
            }
        }
        return n;
    }

    private String intToString(int n) {
        String string = n == -1 || n == -3 ? EACHSTRING : Integer.toString(n);
        return string;
    }
}

