/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.dsf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.ccr.dsf.Dsf;
import oracle.sysman.ccr.dsf.DsfHomeInfo;
import oracle.sysman.ccr.dsf.DsfInitializationException;
import oracle.sysman.ccr.dsf.DsfInputSourceInputIsLockedException;
import oracle.sysman.ccr.dsf.DsfInternalErrorException;
import oracle.sysman.ccr.dsf.DsfMsgID;
import oracle.sysman.ccr.dsf.DsfTargetHome;
import oracle.sysman.ccr.dsf.DsfUtil;
import oracle.sysman.ccr.dsf.IDsfInputSource;

class DsfInventoryManager
implements IDsfInputSource {
    private Object mOuiInvSession;
    private static final String FS = File.separator;
    static final String DEFAULT_OUI_INVENTORY_PLACEHOLDER = "default-oui-inventory-placeholder";
    static /* synthetic */ Class class$java$lang$String;

    DsfInventoryManager() {
    }

    public boolean isComponentOfThisName(Dsf dsf, DsfHomeInfo dsfHomeInfo, String string) {
        Object object = this.getInstallInventory(dsf);
        if (object == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("oracle.sysman.oii.oiii.OiiiVersion");
            Method method = object.getClass().getDeclaredMethod("getInstalledInvEntry", class$java$lang$String == null ? (class$java$lang$String = DsfInventoryManager.class$("java.lang.String")) : class$java$lang$String, clazz, clazz, Boolean.TYPE, class$java$lang$String == null ? (class$java$lang$String = DsfInventoryManager.class$("java.lang.String")) : class$java$lang$String);
            Object object2 = method.invoke(object, string, null, null, new Boolean(false), dsfHomeInfo.getLocation());
            return object2 != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            DsfUtil.log_it(dsf, "oui threw exception in isDbHome: " + invocationTargetException.getMessage(), false);
        }
        return false;
    }

    public boolean beginSession(Dsf dsf) throws DsfInitializationException, DsfInputSourceInputIsLockedException {
        try {
            if (this.setOuiLocation(DsfTargetHome.getClientRoot())) {
                Executable executable;
                Class<?> clazz = Class.forName("oracle.sysman.oii.oiic.OiicStandardInventorySession");
                if (this.mOuiInvSession == null) {
                    executable = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = DsfInventoryManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DsfInventoryManager.class$("java.lang.String")) : class$java$lang$String);
                    this.mOuiInvSession = ((Constructor)executable).newInstance("dsf", "10.3.7");
                }
                executable = clazz.getDeclaredMethod("initSession", Integer.TYPE);
                Object[] objectArray = new Integer[]{new Integer(0)};
                ((Method)executable).invoke(this.mOuiInvSession, objectArray);
            }
        }
        catch (SecurityException securityException) {
            DsfUtil.log_it(dsf, "oui reflection issue in beginSession: " + securityException.getMessage(), true);
            securityException.printStackTrace();
            this.throwOuiReflectionErrors(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DsfUtil.log_it(dsf, "oui reflection issue in beginSession: " + noSuchMethodException.getMessage(), true);
            noSuchMethodException.printStackTrace();
            this.throwOuiReflectionErrors(noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            DsfUtil.log_it(dsf, "oui reflection issue in beginSession: " + classNotFoundException.getMessage(), true);
            classNotFoundException.printStackTrace();
            this.throwOuiReflectionErrors(classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DsfUtil.log_it(dsf, "oui reflection issue in beginSession: " + illegalArgumentException.getMessage(), true);
            illegalArgumentException.printStackTrace();
            this.throwOuiReflectionErrors(illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            DsfUtil.log_it(dsf, "oui reflection issue in beginSession: " + instantiationException.getMessage(), true);
            instantiationException.printStackTrace();
            this.throwOuiReflectionErrors(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            DsfUtil.log_it(dsf, "oui reflection issue in beginSession: " + illegalAccessException.getMessage(), true);
            illegalAccessException.printStackTrace();
            this.throwOuiReflectionErrors(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException().getClass().getName().equals("oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException")) {
                return false;
            }
            if (invocationTargetException.getTargetException().getClass().getName().equals("oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException")) {
                throw new DsfInputSourceInputIsLockedException(DsfUtil.getMessageBundle().getMessage(DsfMsgID.DSF_INPUT_SOURCE_INPUT_IS_LOCKED, false));
            }
            DsfUtil.log_it(dsf, "oui invocation error in beginSession: " + invocationTargetException.getMessage() + " : " + invocationTargetException.getTargetException().getMessage(), true);
            invocationTargetException.printStackTrace();
            this.throwOuiInvocationErrors(invocationTargetException);
        }
        return true;
    }

    public void endSession() {
        if (this.mOuiInvSession != null) {
            try {
                Method method = this.mOuiInvSession.getClass().getDeclaredMethod("endSession", null);
                method.invoke(this.mOuiInvSession, null);
            }
            catch (SecurityException securityException) {
                this.throwOuiReflectionErrors(securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.throwOuiReflectionErrors(noSuchMethodException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.throwOuiReflectionErrors(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.throwOuiReflectionErrors(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public List getOwnedTargetHomesWithOCMComponent(Dsf dsf) throws IOException {
        ArrayList<DsfTargetHome> arrayList = new ArrayList<DsfTargetHome>();
        try {
            Object object = this.getInstallInventory(dsf);
            if (object == null) {
                return arrayList;
            }
            String string = this.getCentralInventoryPath(dsf, object);
            Method method = object.getClass().getDeclaredMethod("getHomes", null);
            List list = (List)method.invoke(object, null);
            Class<?> clazz = Class.forName("oracle.sysman.oii.oiii.OiiiAreaInventory");
            Class<?> clazz2 = Class.forName("oracle.sysman.oii.oiii.OiiiOracleHomeInfo");
            Method method2 = clazz2.getDeclaredMethod("getIndex", null);
            Method method3 = clazz2.getDeclaredMethod("getLocation", null);
            Method method4 = clazz.getDeclaredMethod("findCompInRange", Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = DsfInventoryManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DsfInventoryManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DsfInventoryManager.class$("java.lang.String")) : class$java$lang$String);
            Method method5 = clazz.getDeclaredMethod("getTopLevelComps", Integer.TYPE);
            Method method6 = clazz2.getDeclaredMethod("getName", null);
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                int n = (Integer)method2.invoke(e, null);
                String string2 = (String)method3.invoke(e, null);
                Object object2 = method4.invoke(object, new Integer(n), "oracle.sysman.ccr", null, null);
                Vector vector = (Vector)method5.invoke(object, new Integer(n));
                if (!DsfUtil.iOwn(new File(string2)) || n == -1 || object2 == null || vector.size() == 0) continue;
                String string3 = (String)method6.invoke(e, null);
                arrayList.add(new DsfTargetHome(dsf, new DsfHomeInfo(string2, string3, string), this));
            }
        }
        catch (SecurityException securityException) {
            this.throwOuiReflectionErrors(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.throwOuiReflectionErrors(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwOuiReflectionErrors(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.throwOuiReflectionErrors(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            DsfUtil.log_it(dsf, "oui call in getOwnedTargetHomesWithOCMComponent threw an exception " + invocationTargetException.getMessage(), false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.throwOuiReflectionErrors(classNotFoundException);
        }
        return arrayList;
    }

    public String getInputSourceID(Dsf dsf) {
        return this.getCentralInventoryRoot(dsf);
    }

    public String getDefaultPlaceholderInputSourceID() {
        return DEFAULT_OUI_INVENTORY_PLACEHOLDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean isDefaultInputSourceID(String string) {
        block15: {
            File file;
            boolean bl = System.getProperty("os.name").equalsIgnoreCase("Solaris") || System.getProperty("os.name").equalsIgnoreCase("SunOS");
            String string2 = "/etc/oraInst.loc";
            if (bl) {
                string2 = "/var/opt/oracle/oraInst.loc";
            }
            if (!(file = new File(string2)).exists()) break block15;
            FileInputStream fileInputStream = null;
            Properties properties = new Properties();
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            String string3 = properties.getProperty("inventory_loc");
            boolean bl2 = string.equals(string3);
            Object var10_11 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            {
                return bl2;
                catch (FileNotFoundException fileNotFoundException) {
                    Object var10_12 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
                catch (IOException iOException) {
                    Object var10_13 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return false;
    }

    public boolean isPlaceholder() {
        return false;
    }

    private Object getInstallInventory(Dsf dsf) {
        try {
            Method method = this.mOuiInvSession.getClass().getDeclaredMethod("getInstallAreaControl", null);
            Object object = method.invoke(this.mOuiInvSession, null);
            Method method2 = object.getClass().getDeclaredMethod("getInstallInventory", null);
            Object object2 = method2.invoke(object, null);
            return object2;
        }
        catch (SecurityException securityException) {
            DsfUtil.log_it(dsf, "oui reflection issue in getInstallInventory: " + securityException.getMessage(), true);
            securityException.printStackTrace();
            this.throwOuiReflectionErrors(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DsfUtil.log_it(dsf, "oui reflection issue in getInstallInventory: " + noSuchMethodException.getMessage(), true);
            noSuchMethodException.printStackTrace();
            this.throwOuiReflectionErrors(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DsfUtil.log_it(dsf, "oui reflection issue in getInstallInventory: " + illegalArgumentException.getMessage(), true);
            illegalArgumentException.printStackTrace();
            this.throwOuiReflectionErrors(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            DsfUtil.log_it(dsf, "oui reflection issue in getInstallInventory: " + illegalAccessException.getMessage(), true);
            illegalAccessException.printStackTrace();
            this.throwOuiReflectionErrors(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            DsfUtil.log_it(dsf, "getInstallInventory threw an exception " + invocationTargetException.getMessage(), false);
        }
        return null;
    }

    private String getCentralInventoryPath(Dsf dsf, Object object) {
        try {
            Class<?> clazz = Class.forName("oracle.sysman.oii.oiii.OiiiAreaInventory");
            Method method = clazz.getDeclaredMethod("getAreaControl", null);
            Object object2 = method.invoke(object, null);
            Class<?> clazz2 = Class.forName("oracle.sysman.oii.oiii.OiiiTargetAreaControl");
            Method method2 = clazz2.getDeclaredMethod("getAreaRoot", null);
            String string = (String)method2.invoke(object2, null);
            return string;
        }
        catch (SecurityException securityException) {
            this.throwOuiReflectionErrors(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.throwOuiReflectionErrors(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwOuiReflectionErrors(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.throwOuiReflectionErrors(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            DsfUtil.log_it(dsf, "oui call in getCentralInventoryPath threw an exception " + invocationTargetException.getMessage(), false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.throwOuiReflectionErrors(classNotFoundException);
        }
        return null;
    }

    private String getCentralInventoryRoot(Dsf dsf) {
        Object object = this.getInstallInventory(dsf);
        if (object == null) {
            return "";
        }
        return this.getCentralInventoryPath(dsf, object);
    }

    private boolean setOuiLocation(String string) throws DsfInitializationException {
        File file;
        if (string == null || string.equals("")) {
            throw new DsfInitializationException(DsfUtil.getMessageBundle().getMessage(DsfMsgID.DSF_CCR_HOME_NOT_DEFINED, false));
        }
        String string2 = System.getProperty("oracle.installer.invPtrLoc");
        if ((string2 == null || string2.equals("")) && (file = new File(string + FS + "oraInst.loc")).exists()) {
            System.setProperty("oracle.installer.invPtrLoc", file.getPath());
        }
        return true;
    }

    private void throwOuiReflectionErrors(Exception exception) {
        throw new DsfInternalErrorException(DsfUtil.getMessageBundle().getMessage(DsfMsgID.DSF_INTERNAL_ERROR, false, (Object[])new String[]{"OUI threw: " + exception.getClass().getName() + " - " + exception.getMessage()}));
    }

    private void throwOuiInvocationErrors(Exception exception) throws DsfInitializationException {
        throw new DsfInitializationException(DsfUtil.getMessageBundle().getMessage(DsfMsgID.DSF_OUI_ERROR, false, (Object[])new String[]{exception.getClass().getName() + " - " + exception.getMessage()}));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

