/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.dsf;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.ccr.dsf.Dsf;
import oracle.sysman.ccr.dsf.DsfConfigHomeNotFoundException;
import oracle.sysman.ccr.dsf.DsfHomeInfo;
import oracle.sysman.ccr.dsf.DsfInitializationException;
import oracle.sysman.ccr.dsf.DsfInternalErrorException;
import oracle.sysman.ccr.dsf.DsfMsgID;
import oracle.sysman.ccr.dsf.DsfUtil;
import oracle.sysman.ccr.dsf.IDsfInputSource;
import oracle.sysman.ccr.dsf.OCMCollector;

public class DsfTargetHome {
    private Dsf mDsf;
    private final DsfHomeInfo mDsfHomeInfo;
    private List mCollectors;
    private IDsfInputSource mInputSource;
    private static final String FS = File.separator;

    DsfTargetHome(Dsf dsf, DsfHomeInfo dsfHomeInfo, IDsfInputSource iDsfInputSource) {
        this.mDsf = dsf;
        this.mInputSource = iDsfInputSource;
        this.mDsfHomeInfo = dsfHomeInfo;
    }

    DsfTargetHome(Dsf dsf, String string, String string2, String string3) {
        this.mDsf = dsf;
        this.mDsfHomeInfo = new DsfHomeInfo(string, string3, string2);
    }

    public static List getTargetHomesNotSetup(List list) {
        ArrayList<DsfTargetHome> arrayList = new ArrayList<DsfTargetHome>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DsfTargetHome dsfTargetHome = (DsfTargetHome)iterator.next();
            if (dsfTargetHome.isCollectorSetup()) continue;
            arrayList.add(dsfTargetHome);
        }
        return arrayList;
    }

    public static List getUnauthenticatedCollectors(List list) {
        return DsfTargetHome.processCollectors(list, new ICollectorVisitor(){

            public void processCollector(OCMCollector oCMCollector, List list) {
                try {
                    if (oCMCollector.isUnauthenticated()) {
                        list.add(oCMCollector);
                    }
                }
                catch (DsfConfigHomeNotFoundException dsfConfigHomeNotFoundException) {
                    throw new DsfInternalErrorException(DsfUtil.getMessageBundle().getMessage(DsfMsgID.DSF_INTERNAL_ERROR, false, (Object[])new String[]{dsfConfigHomeNotFoundException.getMessage()}));
                }
            }
        });
    }

    public static List getTargetHomesWithUnknownCollectors(List list) {
        ArrayList<DsfTargetHome> arrayList = new ArrayList<DsfTargetHome>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DsfTargetHome dsfTargetHome = (DsfTargetHome)iterator.next();
            if (!dsfTargetHome.isCollectorConfigurationUnknown()) continue;
            arrayList.add(dsfTargetHome);
        }
        return arrayList;
    }

    public static List getDisconnectedCollectors(List list) {
        return DsfTargetHome.processCollectors(list, new ICollectorVisitor(){

            public void processCollector(OCMCollector oCMCollector, List list) {
                try {
                    if (oCMCollector.isDisconnected()) {
                        list.add(oCMCollector);
                    }
                }
                catch (DsfConfigHomeNotFoundException dsfConfigHomeNotFoundException) {
                    throw new DsfInternalErrorException(DsfUtil.getMessageBundle().getMessage(DsfMsgID.DSF_INTERNAL_ERROR, false, (Object[])new String[]{dsfConfigHomeNotFoundException.getMessage()}));
                }
            }
        });
    }

    public static DsfTargetHome getDsfTargetHome(String string, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DsfTargetHome dsfTargetHome = (DsfTargetHome)iterator.next();
            if (!string.equals(dsfTargetHome.getLocation())) continue;
            return dsfTargetHome;
        }
        return null;
    }

    public String toString() {
        String string = "Target home " + this.getName() + " at " + this.getLocation() + " has collector(s): ";
        String string2 = "No collectors!\n";
        if (this.mCollectors != null) {
            string2 = this.mCollectors.size() + " collector(s):";
            Iterator iterator = this.mCollectors.iterator();
            while (iterator.hasNext()) {
                OCMCollector oCMCollector = (OCMCollector)iterator.next();
                string2 = string2 + "\n" + "    " + oCMCollector;
            }
        }
        return string + string2;
    }

    public Dsf getDsf() {
        return this.mDsf;
    }

    public String getLocation() {
        return this.mDsfHomeInfo.getLocation();
    }

    public List getCollectors() {
        return this.mCollectors;
    }

    public boolean canCollectorConfigurationBeDetermined() {
        return this.isCollectorSetup() && !OCMCollector.getCCR_CONFIG_HOMEs(this).isEmpty();
    }

    public boolean isCollectorConfigurationUnknown() {
        return this.isCollectorSetup() && OCMCollector.getCCR_CONFIG_HOMEs(this).isEmpty();
    }

    public File determineIfFMWDir() throws DsfInitializationException {
        File file = null;
        if (this.mDsf.parentIsFMWRootDir(this.mDsfHomeInfo)) {
            file = new File(this.mDsfHomeInfo.getLocation());
        }
        return file;
    }

    public boolean isComponentOfThisName(String string) {
        return this.mInputSource != null && this.mInputSource.isComponentOfThisName(this.mDsf, this.mDsfHomeInfo, string);
    }

    public OCMCollector getCollectorWithConfigHome(String string) {
        Iterator iterator = this.mCollectors.iterator();
        while (iterator.hasNext()) {
            OCMCollector oCMCollector = (OCMCollector)iterator.next();
            String string2 = oCMCollector.getConfigHome();
            if (string2 == null || !string2.equals(string)) continue;
            return oCMCollector;
        }
        return null;
    }

    public boolean isCollectorSetup() {
        if (!OCMCollector.isCollectorSetup(this.getLocation())) {
            return false;
        }
        if (OCMCollector.getCCR_CONFIG_HOMEs(this).isEmpty()) {
            return OCMCollector.isCollectorPreDsf(this.getLocation());
        }
        return true;
    }

    void establishCollectors() {
        this.mCollectors = OCMCollector.createCollectors(this);
    }

    public String getName() {
        return this.mDsfHomeInfo.getName();
    }

    static String getClientRoot() {
        return new File(System.getProperty("CCR_HOME")).getParent();
    }

    private static List processCollectors(List list, ICollectorVisitor iCollectorVisitor) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2;
            DsfTargetHome dsfTargetHome = (DsfTargetHome)iterator.next();
            if (!dsfTargetHome.canCollectorConfigurationBeDetermined() || (list2 = dsfTargetHome.getCollectors()) == null) continue;
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                OCMCollector oCMCollector = (OCMCollector)iterator2.next();
                iCollectorVisitor.processCollector(oCMCollector, arrayList);
            }
        }
        return arrayList;
    }

    public boolean isFmwComponentWithItsOwnCollector() {
        return false;
    }

    static interface ICollectorVisitor {
        public void processCollector(OCMCollector var1, List var2);
    }
}

