/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.dsf;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.sysman.ccr.dsf.CentralProps;
import oracle.sysman.ccr.dsf.DsfConfigHomeNotFoundException;
import oracle.sysman.ccr.dsf.DsfTargetHome;
import oracle.sysman.ccr.dsf.OCMCcrConfigFile;
import oracle.sysman.ccr.dsf.OCMCollectorConfigFile;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.Process;

public class OCMCollector {
    private static final String FS = File.separator;
    private final DsfTargetHome mDsfTargetHome;
    private final String mCCR_CONFIG_HOME;
    private OCMCcrConfigFile mCcrConfig;
    private OCMCollectorConfigFile mCollectorConfig;
    private CentralProps mCentralProps;

    private OCMCollector(DsfTargetHome dsfTargetHome, String string) {
        this.mDsfTargetHome = dsfTargetHome;
        this.mCCR_CONFIG_HOME = string;
        if (dsfTargetHome.canCollectorConfigurationBeDetermined()) {
            try {
                this.mCcrConfig = new OCMCcrConfigFile(this.mDsfTargetHome.getLocation(), string);
                this.mCollectorConfig = new OCMCollectorConfigFile(this.mDsfTargetHome.getLocation(), string);
                this.mCentralProps = new CentralProps(dsfTargetHome.getDsf(), CentralProps.getCentralPropsFilePath(dsfTargetHome.getLocation()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static List createCollectors(DsfTargetHome dsfTargetHome) {
        ArrayList<OCMCollector> arrayList = new ArrayList<OCMCollector>();
        if (!dsfTargetHome.canCollectorConfigurationBeDetermined()) {
            arrayList.add(new OCMCollector(dsfTargetHome, null));
        } else {
            List list = OCMCollector.getCCR_CONFIG_HOMEs(dsfTargetHome);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                arrayList.add(new OCMCollector(dsfTargetHome, file.getAbsolutePath()));
            }
        }
        return arrayList;
    }

    public String getLocation() {
        return this.mDsfTargetHome.getLocation();
    }

    public boolean isUnauthenticated() throws DsfConfigHomeNotFoundException {
        if (this.mCcrConfig != null) {
            return this.mCcrConfig.isUnauthenticated();
        }
        return false;
    }

    public boolean isDisconnected() throws DsfConfigHomeNotFoundException {
        if (this.mCollectorConfig != null) {
            return this.mCollectorConfig.isDisconnected();
        }
        return false;
    }

    public boolean testConnection() {
        String[] stringArray = new String[]{FileSpec.catfile((String[])new String[]{this.mDsfTargetHome.getLocation(), "ccr", "bin", "emCCR"}), "status"};
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Process process = Process.exec((String[])stringArray, (String[])new String[]{"CCR_CONFIG_HOME=" + this.mCCR_CONFIG_HOME}, null, (String)"15");
            if (process.waitFor(stringBuffer) == 0) {
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public boolean equals(Object object) {
        OCMCollector oCMCollector = (OCMCollector)object;
        return oCMCollector.mDsfTargetHome.getLocation().equals(this.mDsfTargetHome.getLocation()) && (oCMCollector.mCCR_CONFIG_HOME == null && this.mCCR_CONFIG_HOME == null || oCMCollector.mCCR_CONFIG_HOME != null && this.mCCR_CONFIG_HOME != null && oCMCollector.mCCR_CONFIG_HOME.equals(this.mCCR_CONFIG_HOME));
    }

    public String toString() {
        String string = "Collector at " + this.mDsfTargetHome.getLocation();
        String string2 = " is not setup.";
        if (this.mDsfTargetHome.isCollectorSetup()) {
            string2 = " is setup.";
            string2 = this.mDsfTargetHome.canCollectorConfigurationBeDetermined() ? string2 + " CCR_CONFIG_HOME is: " + this.mCCR_CONFIG_HOME + "." : string2 + " Configuration cannot be determined.";
        }
        return string + string2;
    }

    public String getConfigHome() {
        return this.mCCR_CONFIG_HOME;
    }

    public DsfTargetHome getTargetHome() {
        return this.mDsfTargetHome;
    }

    public String getName() {
        return this.mDsfTargetHome.getName();
    }

    public static List getCCR_CONFIG_HOMEs(DsfTargetHome dsfTargetHome) {
        ArrayList<File> arrayList;
        block7: {
            block8: {
                File file;
                block9: {
                    arrayList = new ArrayList<File>();
                    file = new File(dsfTargetHome.getLocation() + FS + "ccr");
                    if (!OCMCollector.isCollectorPreDsf(dsfTargetHome.getLocation())) break block8;
                    File file2 = new File(file.getAbsolutePath() + FS + "hosts");
                    if (!file2.exists()) break block9;
                    try {
                        File file3;
                        String string = InetAddress.getLocalHost().getHostName();
                        int n = string.indexOf(".");
                        if (n != -1) {
                            string = string.substring(0, n);
                        }
                        if (OCMCollector.isCcrValid(file3 = new File(file2.getAbsolutePath() + FS + string))) {
                            arrayList.add(file3);
                        }
                        break block7;
                    }
                    catch (UnknownHostException unknownHostException) {}
                    break block7;
                }
                if (!OCMCollector.isCcrValid(file)) break block7;
                arrayList.add(file);
                break block7;
            }
            if (!CentralProps.platformSupportsCentralProperties()) {
                arrayList.add(new File(System.getProperty("CCR_CONFIG_HOME")));
            } else {
                CentralProps centralProps = new CentralProps(dsfTargetHome.getDsf(), CentralProps.getCentralPropsFilePath(dsfTargetHome.getLocation()));
                List list = centralProps.getCCR_CONFIG_HOMEs(dsfTargetHome.getLocation());
                for (int i = 0; i < list.size(); ++i) {
                    File file = new File((String)list.get(i));
                    if (!OCMCollector.isCcrValid(file)) continue;
                    arrayList.add(file);
                }
            }
        }
        return arrayList;
    }

    static boolean isCcrValid(File file) {
        if (file != null && file.exists()) {
            File file2 = new File(FileSpec.catfile((String[])new String[]{file.getPath(), "config"}));
            File file3 = new File(FileSpec.catfile((String[])new String[]{file.getPath(), "state"}));
            File file4 = new File(FileSpec.catfile((String[])new String[]{file.getPath(), "log"}));
            if (file2.exists() && file3.exists() && file4.exists()) {
                return true;
            }
        }
        return false;
    }

    static boolean isCollectorPreDsf(String string) {
        return !new File(string + FS + "ccr" + FS + "lib" + FS + "emocmdsf.jar").exists();
    }

    Properties getCcrProperties() {
        if (this.mCcrConfig != null) {
            return this.mCcrConfig.getProperties();
        }
        return null;
    }

    public static boolean isCollectorSetup(String string) {
        return new File(FileSpec.catfile((String[])new String[]{string, "ccr", "lib", "emCCR.jar"})).exists();
    }

    public void shutdown() {
        String string = System.getProperty("user.name");
        if ("root".equals(string)) {
            int n;
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = new String[]{FileSpec.catfile((String[])new String[]{System.getProperty("CCR_HOME"), "bin", System.getProperty("os.name").startsWith("Windows") ? "getUsersCentralPropsLocAndOwner.vbs" : "getUsersCentralPropsLocAndOwner.sh"}), this.mDsfTargetHome.getLocation()};
            try {
                object = Process.exec((String[])stringArray, null, null, (String)"10");
                n = object.waitFor(stringBuffer);
                if (n != 0) {
                    throw new RuntimeException("Invoking getUsersCentralPropsLocAndOwner.sh returned:" + Integer.toString(n));
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Invoking getUsersCentralPropsLocAndOwner.sh caused:" + interruptedException.getMessage());
            }
            catch (IOException iOException) {
                throw new RuntimeException("Invoking getUsersCentralPropsLocAndOwner.sh caused:" + iOException.getMessage());
            }
            object = stringBuffer.toString();
            if (((String)object).length() == 0) {
                throw new RuntimeException("Invoking getUsersCentralPropsLocAndOwner.sh returned empty string!");
            }
            n = ((String)object).indexOf(",");
            String string2 = ((String)object).substring(0, n);
            String string3 = ((String)object).substring(n + 1, ((String)object).length());
            String[] stringArray2 = new String[]{FileSpec.catfile((String[])new String[]{System.getProperty("CCR_HOME"), "bin", System.getProperty("os.name").startsWith("Windows") ? "runCommandAsUser.vbs" : "runCommandAsUser.sh"}), string3, this.mDsfTargetHome.getLocation() + FS + "ccr" + FS + "bin" + FS + "emCCR stop"};
            StringBuffer stringBuffer2 = new StringBuffer();
            try {
                Process process = Process.exec((String[])stringArray2, (String[])new String[]{"CCR_CONFIG_HOME=" + this.mCCR_CONFIG_HOME}, null, (String)"10");
                if (process.waitFor(stringBuffer2) == 0) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            String[] stringArray = new String[]{FileSpec.catfile((String[])new String[]{this.mDsfTargetHome.getLocation(), "ccr", "bin", "emCCR"}), "stop"};
            StringBuffer stringBuffer = new StringBuffer();
            try {
                Process process = Process.exec((String[])stringArray, (String[])new String[]{"CCR_CONFIG_HOME=" + this.mCCR_CONFIG_HOME}, null, (String)"10");
                if (process.waitFor(stringBuffer) == 0) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

