/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.core.oh.patch.jrockit;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.core.agent.PatchInfoProvider;
import oracle.sysman.core.agent.PatchInformation;
import oracle.sysman.core.agent.ProductInformation;
import oracle.sysman.core.agent.exceptions.PatchSystemException;
import oracle.sysman.core.oh.patch.jrockit.JRockitPatchInformation;
import oracle.sysman.core.oh.patch.jrockit.JRockitProductInformation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JRockitPatchInfoProvider
implements PatchInfoProvider {
    private Map<ProductInformation, List<PatchInformation>> map = new HashMap<ProductInformation, List<PatchInformation>>(2);
    private HashMap<String, PatchInformation> patchIdMap = null;
    private String installDir;
    private static String FILENAME = "ReleaseInformation.xml";
    private static String JRE_DIR = "jre";
    private static String LIB_DIR = "lib";
    private static String PRIMARY_BUG_ID = "primary_bug_id";
    private static String PATCH_ID = "patch_id";
    private static String PRIMARY_BUG_DESC = "primary_bug_description";
    private static String BUG_IDS = "bug_ids";
    private static String BUG = "bug";
    private static String PRODUCT_VERSION = "product_version";
    private static String PRODUCT_NAME = "product_name";
    private static String ARU_PRODUCT_VERSION = "aru_product_version";
    private static String ARU_PRODUCT_NAME = "aru_product_name";

    JRockitPatchInfoProvider(String installationDirectory) {
        this.installDir = installationDirectory;
    }

    public Map<ProductInformation, List<PatchInformation>> getAppliedPatchListByProduct() throws PatchSystemException {
        ArrayList<String> bugs = null;
        FileInputStream is = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            String fs = System.getProperty("file.separator");
            String filepath = this.installDir + fs + JRE_DIR + fs + LIB_DIR + fs + FILENAME;
            is = new FileInputStream(filepath);
            Document doc = dbFactory.newDocumentBuilder().parse(is);
            Element docElement = doc.getDocumentElement();
            NodeList nl = docElement.getElementsByTagName(PRIMARY_BUG_ID);
            if (nl.getLength() < 1) {
                throw new PatchSystemException(PRIMARY_BUG_ID + " not found");
            }
            Node bugIdEle = nl.item(0);
            String primaryBug = bugIdEle.getTextContent();
            nl = docElement.getElementsByTagName(PATCH_ID);
            if (nl.getLength() < 1) {
                throw new PatchSystemException(PATCH_ID + "  not found");
            }
            bugIdEle = nl.item(0);
            String patchId = bugIdEle.getTextContent();
            nl = docElement.getElementsByTagName(PRODUCT_VERSION);
            if (nl.getLength() < 1) {
                throw new PatchSystemException(PRODUCT_VERSION + " not found");
            }
            bugIdEle = nl.item(0);
            String productVersion = bugIdEle.getTextContent();
            NodeList bugIds = docElement.getElementsByTagName(BUG_IDS);
            if (bugIds.getLength() >= 1) {
                Element bugIdNode = (Element)bugIds.item(0);
                NodeList bugList = bugIdNode.getElementsByTagName(BUG);
                bugs = new ArrayList<String>(bugList.getLength());
                for (int i = 0; i < bugList.getLength(); ++i) {
                    Node be = bugList.item(i);
                    bugs.add(be.getTextContent());
                }
            }
            nl = docElement.getElementsByTagName(PRIMARY_BUG_DESC);
            String bugDesc = "";
            if (nl.getLength() > 0) {
                Node node = nl.item(0);
                bugDesc = node.getTextContent();
            }
            nl = docElement.getElementsByTagName(PRODUCT_NAME);
            String prodName = null;
            if (nl.getLength() > 0) {
                Node node = nl.item(0);
                prodName = node.getTextContent();
            }
            nl = docElement.getElementsByTagName(ARU_PRODUCT_VERSION);
            String aruProdVersion = null;
            if (nl.getLength() > 0) {
                Node node = nl.item(0);
                aruProdVersion = node.getTextContent();
            }
            nl = docElement.getElementsByTagName(ARU_PRODUCT_NAME);
            String aruProdName = null;
            if (nl.getLength() > 0) {
                Node node = nl.item(0);
                aruProdName = node.getTextContent();
            }
            JRockitPatchInformation patchInfo = new JRockitPatchInformation(primaryBug, bugs, patchId, productVersion, bugDesc, prodName, aruProdVersion, aruProdName);
            JRockitProductInformation prodInfo = new JRockitProductInformation(productVersion, aruProdVersion, prodName, aruProdName);
            ArrayList<JRockitPatchInformation> plist = new ArrayList<JRockitPatchInformation>();
            plist.add(patchInfo);
            this.map.put(prodInfo, plist);
        }
        catch (FileNotFoundException ex) {
            throw new PatchSystemException("Jrockit Patch Information not available. No patch information file found", (Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new PatchSystemException("Jrockit Patch Information not available", (Throwable)ex);
        }
        catch (SAXException ex) {
            throw new PatchSystemException("Jrockit Patch Information not available", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new PatchSystemException("Jrockit Patch Information not available", (Throwable)ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ignore) {}
        }
        return this.map;
    }
}

