/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Vector;

public class CompoundTransferable
implements Transferable {
    private Transferable[] _transferables;

    public CompoundTransferable(Transferable transferable, Transferable transferable2) {
        this._transferables = new Transferable[]{transferable, transferable2};
    }

    public CompoundTransferable(Transferable[] transferableArray) {
        this._transferables = new Transferable[transferableArray.length];
        System.arraycopy(transferableArray, 0, this._transferables, 0, transferableArray.length);
    }

    public final Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        Transferable[] transferableArray = this._transferables;
        int n = 0;
        while (n < transferableArray.length) {
            if (transferableArray[n].isDataFlavorSupported(dataFlavor)) {
                return transferableArray[n].getTransferData(dataFlavor);
            }
            ++n;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        Object[] objectArray;
        Transferable[] transferableArray = this._transferables;
        Vector<Object> vector = new Vector<Object>(transferableArray.length);
        int n = 0;
        while (n < transferableArray.length) {
            objectArray = transferableArray[n].getTransferDataFlavors();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (!vector.contains(objectArray[n2])) {
                    vector.addElement(objectArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        objectArray = new DataFlavor[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        Transferable[] transferableArray = this._transferables;
        int n = 0;
        while (n < transferableArray.length) {
            if (transferableArray[n].isDataFlavorSupported(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

