/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import oracle.bali.share.datatransfer.CompoundTransferable;
import oracle.bali.share.datatransfer.TransferUtils;

public abstract class ObjectTransferable
implements Transferable {
    private DataFlavor _objectFlavor;

    protected ObjectTransferable(Class clazz) {
        this._objectFlavor = TransferUtils.getDataFlavor(clazz);
    }

    public static Transferable createTransferable(Object object) {
        Object[] objectArray;
        if (object instanceof String) {
            return new StringSelection((String)object);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray() && (objectArray = (Object[])object).length == 1 && objectArray[0] != null) {
            Transferable transferable = ObjectTransferable.createTransferable(objectArray[0]);
            return new CompoundTransferable(new UpFront(clazz, object), transferable);
        }
        return new UpFront(clazz, object);
    }

    protected abstract Object getTransferData();

    public final Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            Object object = this.getTransferData();
            return object;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this._objectFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return TransferUtils.supportsDataFlavor(this._objectFlavor, dataFlavor);
    }

    private static class UpFront
    extends ObjectTransferable {
        private Object _data;

        public UpFront(Class clazz, Object object) {
            super(clazz);
            this._data = object;
        }

        protected Object getTransferData() {
            return this._data;
        }
    }
}

