/*
 * Decompiled with CFR 0.152.
 */
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class Policy {
    String PolicyName = new String("");
    Integer PwMinLife = new Integer(0);
    Integer PwMaxLife = new Integer(2592000);
    Integer PwMinLength = new Integer(4);
    Integer PwMinClasses = new Integer(2);
    Integer PwSaveCount = new Integer(3);
    Integer RefCount = new Integer(0);
    Kadmin Kadmin;
    boolean isNew = true;
    boolean dummy = true;
    private static ResourceBundle rb = ResourceBundle.getBundle("GuiResource");
    private static NumberFormat nf = NumberFormat.getInstance();

    public Policy() {
    }

    public Policy(String string) {
        this();
        this.dummy = true;
        this.isNew = false;
        this.PolicyName = string;
        this.loadPolicy(string);
    }

    public Policy(Policy policy) {
        this();
        this.dummy = true;
        this.copyPolicy(policy, this);
    }

    public Policy(Kadmin kadmin) {
        this();
        this.dummy = false;
        this.Kadmin = kadmin;
    }

    public Policy(Kadmin kadmin, String string) {
        this();
        this.isNew = false;
        this.dummy = false;
        this.Kadmin = kadmin;
        this.PolicyName = string;
        this.loadPolicy(string);
    }

    public Policy(Kadmin kadmin, Policy policy) {
        this(policy);
        this.dummy = false;
        this.Kadmin = kadmin;
    }

    public void copyPolicy(Policy policy, Policy policy2) {
        policy2.PolicyName = new String("");
        policy2.PwMinLife = new Integer(policy.PwMinLife);
        policy2.PwMaxLife = new Integer(policy.PwMaxLife);
        policy2.PwMinLength = new Integer(policy.PwMinLength);
        policy2.PwMinClasses = new Integer(policy.PwMinClasses);
        policy2.PwSaveCount = new Integer(policy.PwSaveCount);
        policy2.RefCount = new Integer(0);
    }

    public boolean loadPolicy(String string) {
        if (this.dummy) {
            return true;
        }
        boolean bl = this.Kadmin.loadPolicy(string, this);
        return bl;
    }

    public boolean savePolicy() {
        if (this.dummy) {
            return true;
        }
        if (this.isNew) {
            return this.Kadmin.createPolicy(this);
        }
        return this.Kadmin.savePolicy(this);
    }

    public boolean setName(String string) {
        this.PolicyName = string;
        return true;
    }

    public boolean setPolPwLength(String string) {
        try {
            this.PwMinLength = new Integer(nf.parse(string).intValue());
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public boolean setPolPwClasses(String string) {
        try {
            this.PwMinClasses = new Integer(nf.parse(string).intValue());
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public boolean setPolPwHistory(String string) {
        try {
            this.PwSaveCount = new Integer(nf.parse(string).intValue());
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public boolean setPolMinlife(String string) {
        try {
            this.PwMinLife = new Integer(nf.parse(string.trim()).intValue());
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public boolean setPolMaxlife(String string) {
        try {
            this.PwMaxLife = new Integer(nf.parse(string.trim()).intValue());
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Policy.getString("Policy Name:") + "  " + this.PolicyName).append('\n');
        stringBuffer.append(Policy.getString("Reference Count:") + "  " + this.RefCount).append("\n");
        stringBuffer.append(Policy.getString("Minimum Password Lifetime (seconds):") + "  " + this.PwMinLife).append("\t");
        stringBuffer.append(Policy.getString("Maximum Password Lifetime (seconds):") + "  " + this.PwMaxLife).append("\n");
        stringBuffer.append(Policy.getString("Minimum Password Length:") + "  " + this.PwMinLength).append("\t");
        stringBuffer.append(Policy.getString("Minimum Password Classes:") + "  " + this.PwMinClasses).append("\n");
        stringBuffer.append(Policy.getString("Password Save Count:") + "  " + this.PwSaveCount).append("\n");
        return stringBuffer.toString();
    }

    private static final String getString(String string) {
        try {
            String string2 = rb.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource " + string + ", using English.");
            return string;
        }
    }
}

