/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import java.net.Socket;
import java.util.Random;

public class Client {
    private static final int BYTESPEROP = 10;
    private static final int PORTNUM = 4444;
    private static final int MAXCONN = 10000;
    private static Socket[] sockArr = new Socket[10000];
    private static int totalConn = 10;
    private static int bytesToSend = 1024000;
    private static int connections = 0;
    private static int sends = 0;

    public static void main(String[] stringArray) {
        String string = "localhost";
        if (stringArray.length < 1 || stringArray.length > 3) {
            System.out.println("Usage : java Client <num_connects>");
            System.out.println("      | java Client <num_connects> <server_name>");
            System.out.println("      | java Client <num_connects> <server_name> <max_Kbytes>");
            System.exit(-1);
        }
        if (stringArray.length >= 1) {
            totalConn = Integer.valueOf(stringArray[0]);
        }
        if (stringArray.length >= 2) {
            string = stringArray[1];
        }
        if (stringArray.length == 3) {
            bytesToSend = Integer.valueOf(stringArray[2]) * 1024;
        }
        if (totalConn <= 0 || totalConn > 10000) {
            System.out.println("Connections out of range.  Terminating.");
            System.exit(-1);
        }
        System.out.println("Using " + totalConn + " connections for sending " + bytesToSend + " bytes to " + string);
        try {
            int n;
            Socket socket = new Socket(string, 4444);
            PrintStream printStream = new PrintStream(socket.getOutputStream());
            printStream.println(bytesToSend);
            printStream.println(totalConn);
            while (connections < totalConn) {
                Client.sockArr[Client.connections] = new Socket(string, 4444);
                ++connections;
            }
            System.out.println("Connections made : " + connections);
            byte[] byArray = new byte[10];
            for (int i = 0; i < 10; ++i) {
                byArray[i] = (byte)i;
            }
            Random random = new Random(5321L);
            while (sends < bytesToSend / 10) {
                n = Math.abs(random.nextInt()) % totalConn;
                sockArr[n].getOutputStream().write(byArray, 0, 10);
                ++sends;
            }
            n = socket.getInputStream().read(byArray, 0, 10);
            System.out.println(" Total connections : " + connections + " Bytes sent : " + sends * 10 + "...Done!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

