/*
 * Decompiled with CFR 0.152.
 */
import com.sun.zfs.common.model.Dataset;
import com.sun.zfs.common.model.DeviceStats;
import com.sun.zfs.common.model.DiskDevice;
import com.sun.zfs.common.model.FileSystem;
import com.sun.zfs.common.model.ImportablePool;
import com.sun.zfs.common.model.LeafVirtualDevice;
import com.sun.zfs.common.model.Pool;
import com.sun.zfs.common.model.PoolBean;
import com.sun.zfs.common.model.PoolStats;
import com.sun.zfs.common.model.Property;
import com.sun.zfs.common.model.SliceDevice;
import com.sun.zfs.common.model.SliceUsage;
import com.sun.zfs.common.model.Snapshot;
import com.sun.zfs.common.model.SystemDataModel;
import com.sun.zfs.common.model.VirtualDevice;
import com.sun.zfs.common.model.Volume;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Util;
import java.io.PrintWriter;

public class Test {
    public static void dumpProperties(PrintWriter printWriter, Property[] propertyArray, String string) {
        for (Property property : propertyArray) {
            if (property == null) {
                printWriter.printf("%s(null)\n", string);
                continue;
            }
            String string2 = null;
            switch (property.getLineage()) {
                case ZFS_PROP_LINEAGE_NOTINHERITABLE: {
                    string2 = "not inheritable";
                    break;
                }
                case ZFS_PROP_LINEAGE_DEFAULT: {
                    string2 = "default";
                    break;
                }
                case ZFS_PROP_LINEAGE_LOCAL: {
                    string2 = "set locally";
                    break;
                }
                case ZFS_PROP_LINEAGE_TEMPORARY: {
                    string2 = "temporary";
                    break;
                }
                case ZFS_PROP_LINEAGE_INHERITED: {
                    string2 = "inherited from " + property.getInheritedFrom();
                }
            }
            String string3 = property.getReadOnly() ? "read-only" : "read/write";
            printWriter.printf("%s%s: %s (%s, %s, %s)\n", string, property.getName(), property.getValue(), string3, string2, Util.getClassBaseName(property));
        }
    }

    public static void dumpDataset(ZDataModel zDataModel, PrintWriter printWriter, Dataset dataset, String string) {
        printWriter.println(string + "basename: " + dataset.getBaseName());
        printWriter.println(string + "fullname: " + dataset.getFullName());
        printWriter.println(string + "pool: " + dataset.getPoolName());
        printWriter.println(string + "parent: " + dataset.getParentName());
        if (dataset instanceof Pool && !PoolBean.isActive((Pool)dataset)) {
            return;
        }
        printWriter.println(string + "origin: " + dataset.getPrototype());
        printWriter.println(string + "percent used: " + dataset.getPercentUsed());
        printWriter.println(string + "properties:");
        Test.dumpProperties(printWriter, dataset.getProperties(), string + "  ");
        if (!(dataset instanceof Snapshot)) {
            String string2 = dataset.getFullName();
            for (Snapshot snapshot : zDataModel.getSnapshots(string2)) {
                Test.dumpSnapshot(zDataModel, printWriter, snapshot, string + "  ");
            }
        }
    }

    public static void dumpFileSystem(ZDataModel zDataModel, PrintWriter printWriter, FileSystem fileSystem, String string, boolean bl) {
        if (bl) {
            printWriter.println();
            printWriter.println(string + Util.getClassBaseName(fileSystem));
            printWriter.println(string + "***********************************************");
        }
        Test.dumpDataset(zDataModel, printWriter, fileSystem, string);
        String string2 = fileSystem.getFullName();
        for (FileSystem dataset : zDataModel.getFileSystems(string2)) {
            Test.dumpFileSystem(zDataModel, printWriter, dataset, string + "  ", true);
        }
        for (Dataset dataset : zDataModel.getVolumes(string2)) {
            Test.dumpVolume(zDataModel, printWriter, (Volume)dataset, string + "  ");
        }
    }

    public static void dumpSnapshot(ZDataModel zDataModel, PrintWriter printWriter, Snapshot snapshot, String string) {
        printWriter.println();
        printWriter.println(string + Util.getClassBaseName(snapshot));
        printWriter.println(string + "***********************************************");
        Test.dumpDataset(zDataModel, printWriter, snapshot, string);
    }

    public static void dumpVolume(ZDataModel zDataModel, PrintWriter printWriter, Volume volume, String string) {
        printWriter.println();
        printWriter.println(string + Util.getClassBaseName(volume));
        printWriter.println(string + "***********************************************");
        Test.dumpDataset(zDataModel, printWriter, volume, string);
    }

    public static void dumpPool(ZDataModel zDataModel, PrintWriter printWriter, Pool pool, String string) {
        VirtualDevice[] virtualDeviceArray;
        printWriter.println();
        printWriter.println(string + Util.getClassBaseName(pool));
        printWriter.println(string + "***********************************************");
        Test.dumpPoolStats(printWriter, pool, string);
        Test.dumpFileSystem(zDataModel, printWriter, pool, string, false);
        for (VirtualDevice virtualDevice : virtualDeviceArray = zDataModel.getVirtualDevices(pool.getBaseName())) {
            Test.dumpVirtualDevice(zDataModel, printWriter, virtualDevice, string + "  ");
        }
    }

    public static void dumpDeviceStats(PrintWriter printWriter, DeviceStats deviceStats, String string) {
        printWriter.println(string + "size: " + Util.getHumanReadableDataSize(deviceStats.getSize(), 2, false, null, null, false, true));
        printWriter.println(string + "replacement size: " + Util.getHumanReadableDataSize(deviceStats.getReplacementSize(), 2, false, null, null, false, true));
        printWriter.println(string + "used: " + Util.getHumanReadableDataSize(deviceStats.getUsed(), 2, false, null, null, false, true));
        printWriter.println(string + "read bytes: " + Util.getHumanReadableDataSize(deviceStats.getReadBytes(), 2, false, null, null, false, true));
        printWriter.println(string + "write bytes: " + Util.getHumanReadableDataSize(deviceStats.getWriteBytes(), 2, false, null, null, false, true));
        printWriter.println(string + "read operations: " + deviceStats.getReadOperations());
        printWriter.println(string + "write operations: " + deviceStats.getWriteOperations());
        printWriter.println(string + "read errors: " + deviceStats.getReadErrors());
        printWriter.println(string + "write errors: " + deviceStats.getWriteErrors());
        printWriter.println(string + "checksum errors: " + deviceStats.getChecksumErrors());
        printWriter.println(string + "device state: " + Util.getReadableValue((Object)deviceStats.getDeviceState()));
        printWriter.println(string + "device status: " + Util.getReadableValue((Object)deviceStats.getDeviceStatus()));
    }

    public static void dumpPoolStats(PrintWriter printWriter, PoolStats poolStats, String string) {
        Test.dumpDeviceStats(printWriter, poolStats, string);
        printWriter.println(string + "pool state: " + Util.getReadableValue((Object)poolStats.getPoolState()));
        printWriter.println(string + "pool status: " + Util.getReadableValue((Object)poolStats.getPoolStatus()));
    }

    public static void dumpVirtualDevice(ZDataModel zDataModel, PrintWriter printWriter, VirtualDevice virtualDevice, String string) {
        VirtualDevice[] virtualDeviceArray;
        printWriter.println();
        printWriter.println(string + Util.getClassBaseName(virtualDevice));
        printWriter.println(string + "***********************************************");
        printWriter.println(string + "type: " + Util.getClassBaseName(virtualDevice));
        printWriter.println(string + "pool: " + virtualDevice.getPoolName());
        printWriter.println(string + "parent id: " + virtualDevice.getParentIndex());
        printWriter.println(string + "id: " + virtualDevice.getIndex());
        Test.dumpDeviceStats(printWriter, virtualDevice, string);
        if (virtualDevice instanceof LeafVirtualDevice) {
            virtualDeviceArray = (VirtualDevice[])virtualDevice;
            printWriter.println(string + "name: " + virtualDeviceArray.getName());
            printWriter.println(string + "CLI name: " + virtualDeviceArray.getCommandLineName());
        }
        for (VirtualDevice virtualDevice2 : virtualDeviceArray = zDataModel.getVirtualDevices(virtualDevice.getPoolName(), virtualDevice.getIndex())) {
            Test.dumpVirtualDevice(zDataModel, printWriter, virtualDevice2, string + "  ");
        }
    }

    public static void dumpSlice(PrintWriter printWriter, SliceDevice sliceDevice, String string) {
        printWriter.println();
        printWriter.println(string + Util.getClassBaseName(sliceDevice));
        printWriter.println(string + "***********************************************");
        printWriter.println(string + "name: " + sliceDevice.getName());
        printWriter.println(string + "disk: " + sliceDevice.getDisk().getFriendlyName());
        printWriter.println(string + "size: " + sliceDevice.getSize());
        printWriter.println(string + "start: " + sliceDevice.getStart());
        SliceUsage sliceUsage = sliceDevice.getUsage();
        if (sliceUsage != null) {
            printWriter.println(string + "used by: " + sliceUsage.getUsedBy());
            printWriter.println(string + "used name: " + (Object)((Object)sliceUsage.getUse()));
        }
    }

    public static void dumpDisk(PrintWriter printWriter, DiskDevice diskDevice, String string) {
        printWriter.println();
        printWriter.println(string + Util.getClassBaseName(diskDevice));
        printWriter.println(string + "***********************************************");
        printWriter.println(string + "name: " + diskDevice.getName());
        printWriter.println(string + "size: " + diskDevice.getSize());
        for (SliceDevice sliceDevice : diskDevice.getAvailableSlices()) {
            Test.dumpSlice(printWriter, sliceDevice, string + "  ");
        }
    }

    public static void dumpImportablePool(PrintWriter printWriter, ImportablePool importablePool, String string) {
        printWriter.println();
        printWriter.println(string + Util.getClassBaseName(importablePool));
        printWriter.println(string + "***********************************************");
        printWriter.println(string + "name: " + importablePool.getName());
        printWriter.println(string + "id: " + importablePool.getId());
        Test.dumpPoolStats(printWriter, importablePool, string);
    }

    public static void main(String[] stringArray) {
        try {
            ImportablePool[] importablePoolArray;
            SystemDataModel systemDataModel = new SystemDataModel();
            PrintWriter printWriter = new PrintWriter(System.out, true);
            for (ImportablePool importablePool : importablePoolArray = systemDataModel.getImportablePools(stringArray)) {
                Test.dumpImportablePool(printWriter, importablePool, "");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

