/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.common.model;

import com.sun.zfs.common.model.ChecksumProperty;
import com.sun.zfs.common.model.CompressionProperty;
import com.sun.zfs.common.model.Dataset;
import com.sun.zfs.common.model.Property;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class DatasetBean
implements Dataset {
    private String name;
    private String parent;
    private String pool;
    private Date date;
    private long quota;
    private long reservation;
    private long used;
    private long available;
    private TreeSet<Property> properties = new TreeSet<Property>(new Comparator<Property>(){

        @Override
        public int compare(Property property, Property property2) {
            return property.getName().compareTo(property2.getName());
        }
    });

    public String getPoolName() {
        return this.pool;
    }

    public String getParentName() {
        return this.parent;
    }

    public String getBaseName() {
        return this.name;
    }

    public String getFullName() {
        return DatasetBean.joinPathComponents(this.getParentName(), this.getBaseName());
    }

    public String getPrototype() {
        try {
            return this.getStringProperty("origin");
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public Date getDateCreated() {
        return this.getDateProperty("creation");
    }

    public long getCreateIndex() {
        return this.getLongProperty("createtxg");
    }

    public long getQuota() {
        try {
            return this.getLongProperty("quota");
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0L;
        }
    }

    public long getReservation() {
        try {
            return this.getLongProperty("reservation");
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0L;
        }
    }

    public long getUsed() {
        return this.getLongProperty("used");
    }

    public long getAvailable() {
        return this.getLongProperty("available");
    }

    public int getPercentUsed() {
        long l = this.getUsed();
        long l2 = 0L;
        try {
            l2 = this.getQuota();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        long l3 = this.getAvailable();
        long l4 = l + l3;
        if (l2 != 0L && l4 > l2) {
            l4 = l2;
        }
        return (int)Math.round(100.0 * (double)l / (double)l4);
    }

    public ChecksumProperty.Checksum getChecksum() {
        return (ChecksumProperty.Checksum)((Object)this.getProperty("checksum").getValue());
    }

    public CompressionProperty.Compression getCompression() {
        return (CompressionProperty.Compression)((Object)this.getProperty("compression").getValue());
    }

    public long getCompressionRatio() {
        return this.getLongProperty("compressratio");
    }

    public boolean getReadOnly() {
        return this.getBooleanProperty("readonly");
    }

    public long getReferenced() {
        return this.getLongProperty("referenced");
    }

    public boolean getZoned() {
        return this.getBooleanProperty("zoned");
    }

    public Property[] getProperties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    public Property getProperty(String string) {
        Property[] propertyArray = this.getProperties();
        if (propertyArray != null) {
            for (Property property : propertyArray) {
                if (!property.getName().equals(string)) continue;
                return property;
            }
        }
        throw new NoSuchElementException("no such property in " + this.getFullName() + ": " + string);
    }

    public void setPoolName(String string) {
        this.pool = string;
    }

    public void setParentName(String string) {
        this.parent = string;
    }

    public void setBaseName(String string) {
        this.name = string;
    }

    public void setProperties(Property[] propertyArray) {
        this.properties.clear();
        Collections.addAll(this.properties, propertyArray);
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    protected boolean getBooleanProperty(String string) {
        return (Boolean)this.getProperty(string).getValue();
    }

    protected long getLongProperty(String string) {
        return (Long)this.getProperty(string).getValue();
    }

    protected String getStringProperty(String string) {
        return (String)this.getProperty(string).getValue();
    }

    protected Date getDateProperty(String string) {
        return (Date)this.getProperty(string).getValue();
    }

    public static String[] getDeviceNameComponents(String string) {
        if (string == null) {
            return new String[0];
        }
        return string.split(Pattern.quote("/") + "|" + Pattern.quote("@"));
    }

    public static String[] getParentChild(String string) {
        int n = string.lastIndexOf("@");
        if (n == -1) {
            n = string.lastIndexOf("/");
        }
        if (n != -1) {
            return new String[]{string.substring(0, n), string.substring(n + 1)};
        }
        return new String[]{null, string};
    }

    public static String getParentName(String string) {
        return DatasetBean.getParentChild(string)[0];
    }

    public static String getBaseName(String string) {
        return DatasetBean.getParentChild(string)[1];
    }

    public static String[] getPoolAndPath(String string) {
        if (string != null) {
            int n;
            int n2 = string.indexOf("/");
            int n3 = string.indexOf("@");
            if (n2 == -1) {
                n = n3;
            } else if (n3 == -1) {
                n = n2;
            } else {
                int n4 = n = n2 < n3 ? n2 : n3;
            }
            if (n != -1) {
                return new String[]{string.substring(0, n), string.substring(n + 1)};
            }
        }
        return new String[]{string, null};
    }

    public static String getPoolName(String string) {
        return DatasetBean.getPoolAndPath(string)[0];
    }

    public static String getQualifiedName(String string) {
        return DatasetBean.getPoolAndPath(string)[1];
    }

    public static String joinPathComponents(String ... stringArray) {
        StringBuffer stringBuffer = null;
        for (String string : stringArray) {
            if (string == null || string.length() == 0) continue;
            try {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append("/");
                }
            }
            catch (NullPointerException nullPointerException) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(string);
        }
        try {
            return stringBuffer.toString();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static boolean isPool(String string) {
        return !string.contains("/") && !string.contains("@");
    }

    public static boolean isSnapshot(String string) {
        return string.contains("@");
    }

    public static boolean isAncestor(String string, String string2) {
        return string2.startsWith(string + "/") || string2.startsWith(string + "@");
    }
}

