/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.common.model;

import com.iplanet.jato.RequestManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.zfs.common.model.DiskDevice;
import com.sun.zfs.common.model.ImportablePool;
import com.sun.zfs.common.model.SystemDataModel;
import com.sun.zfs.common.model.XMLDataModel;
import com.sun.zfs.common.util.CommandStatus;
import com.sun.zfs.common.util.PrivilegedCommand;
import com.sun.zfs.common.util.Util;
import java.io.ByteArrayInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class LockhartDataModel
extends SystemDataModel {
    private static final String CMD_AVAILDEVS = "/usr/lib/zfs/availdevs";
    private static final String CMD_AVAILDEVS_ARG_ALL = "-a";
    private static final String CMD_AVAILDEVS_ARG_DEVICES = "-d";
    private static final String CMD_AVAILDEVS_ARG_POOLS = "-p";

    public DiskDevice[] getAvailableDisks() {
        DiskDevice[] diskDeviceArray;
        try {
            String[] stringArray = this.getUserAndPassword();
            XMLDataModel xMLDataModel = this.getXMLDataModel(stringArray[0], stringArray[1], CMD_AVAILDEVS_ARG_DEVICES);
            diskDeviceArray = xMLDataModel.getAvailableDisks();
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
            diskDeviceArray = new DiskDevice[]{};
        }
        return diskDeviceArray;
    }

    public ImportablePool[] getImportablePools(String ... stringArray) {
        ImportablePool[] importablePoolArray;
        try {
            String[] stringArray2 = this.getUserAndPassword();
            String[] stringArray3 = new String[stringArray.length + 1];
            stringArray3[0] = CMD_AVAILDEVS_ARG_POOLS;
            System.arraycopy(stringArray, 0, stringArray3, 1, stringArray.length);
            XMLDataModel xMLDataModel = this.getXMLDataModel(stringArray2[0], stringArray2[1], stringArray3);
            importablePoolArray = xMLDataModel.getImportablePools(stringArray);
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
            importablePoolArray = new ImportablePool[]{};
        }
        return importablePoolArray;
    }

    private synchronized XMLDataModel getXMLDataModel(String string, String string2, String ... stringArray) {
        XMLDataModel xMLDataModel = new XMLDataModel();
        try {
            PrivilegedCommand privilegedCommand = new PrivilegedCommand(string, string2, new String[]{CMD_AVAILDEVS});
            privilegedCommand.appendArgs(stringArray);
            CommandStatus commandStatus = privilegedCommand.exec();
            if (!commandStatus.getSuccessful()) {
                System.err.println(commandStatus.getStderrAsString());
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(commandStatus.getStdout());
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(byteArrayInputStream);
                xMLDataModel.setDocument(document);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        return xMLDataModel;
    }

    private String[] getUserAndPassword() throws SSOException {
        HttpServletRequest httpServletRequest = RequestManager.getRequestContext().getRequest();
        SSOToken sSOToken = SSOTokenManager.getInstance().createSSOToken(httpServletRequest);
        return Util.getUserAndPassword(sSOToken.getSubject());
    }
}

