/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.common.model;

import com.sun.zfs.common.model.ZFSCLIConstants;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Property<E>
implements Cloneable,
Serializable,
ZFSCLIConstants {
    private String name;
    private E value;
    private Lineage lineage;
    private String source;
    private boolean readOnly;
    private boolean mutable = false;

    private Property(String string, E e, boolean bl, Lineage lineage, String string2) {
        this.name = string;
        this.value = e;
        this.readOnly = bl;
        this.lineage = lineage;
        this.source = string2;
    }

    public Property(String string, E e, boolean bl, Lineage lineage) {
        this(string, e, bl, lineage, null);
    }

    public Property(String string, E e, boolean bl, String string2) {
        this(string, e, bl, Lineage.ZFS_PROP_LINEAGE_INHERITED, string2);
    }

    public Property clone() {
        Property property = null;
        try {
            property = (Property)super.clone();
            property.mutable = true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return property;
    }

    public String getName() {
        return this.name;
    }

    public E getValue() {
        return this.value;
    }

    public abstract E getValue(String var1);

    public String getValueAsString() {
        try {
            return this.getValue().toString();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setLineage(Lineage lineage) {
        if (!this.mutable) {
            throw new UnsupportedOperationException("cannot set lineage: Dataset not mutable");
        }
        this.lineage = lineage;
    }

    public Lineage getLineage() {
        return this.lineage;
    }

    public void setInheritedFrom(String string) {
        if (!this.mutable) {
            throw new UnsupportedOperationException("cannot set inherited source: Dataset not mutable");
        }
        this.source = string;
    }

    public String getInheritedFrom() {
        return this.source;
    }

    public Property<E>[] getLegalInstances() {
        return null;
    }

    public String toCommandLineConstant() {
        return this.getValueAsString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Lineage {
        ZFS_PROP_LINEAGE_NOTINHERITABLE,
        ZFS_PROP_LINEAGE_DEFAULT,
        ZFS_PROP_LINEAGE_LOCAL,
        ZFS_PROP_LINEAGE_TEMPORARY,
        ZFS_PROP_LINEAGE_INHERITED;

    }
}

