/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.common.model;

import com.sun.zfs.common.model.Dataset;
import com.sun.zfs.common.model.DatasetBean;
import com.sun.zfs.common.model.FileSystem;
import com.sun.zfs.common.model.FileSystemSnapshot;
import com.sun.zfs.common.model.LockhartDataModel;
import com.sun.zfs.common.model.MountPointProperty;
import com.sun.zfs.common.model.Pool;
import com.sun.zfs.common.model.PoolBean;
import com.sun.zfs.common.model.Property;
import com.sun.zfs.common.model.Snapshot;
import com.sun.zfs.common.model.VirtualDevice;
import com.sun.zfs.common.model.Volume;
import com.sun.zfs.common.model.VolumeSnapshot;
import com.sun.zfs.common.model.XMLDataModel;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Command;
import com.sun.zfs.common.util.CommandStatus;
import com.sun.zfs.common.util.DatasetSet;
import com.sun.zfs.common.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleZDataModel
implements ZDataModel {
    private static ZDataModel model;
    private static Object lock;
    private static final String STUBBED_ZFS_CONFIG = "/etc/zfsconfig.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZDataModel getDefaultModel() {
        Object object = lock;
        synchronized (object) {
            if (model == null) {
                File file = new File(STUBBED_ZFS_CONFIG);
                if (file.exists()) {
                    try {
                        model = new XMLDataModel(file);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (model == null) {
                    model = new LockhartDataModel();
                }
            }
        }
        return model;
    }

    @Override
    public Dataset[] getDatasets(String string) {
        if (string == null) {
            return this.getPools();
        }
        ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
        arrayList.addAll(Arrays.asList(this.getFileSystems(string)));
        arrayList.addAll(Arrays.asList(this.getVolumes(string)));
        arrayList.addAll(Arrays.asList(this.getSnapshots(string)));
        return Util.toArray(arrayList, Dataset.class);
    }

    @Override
    public Dataset getDataset(String string) {
        if (DatasetBean.isSnapshot(string)) {
            return this.getSnapshot(string);
        }
        Dataset dataset = this.getFileSystem(string);
        if (dataset == null) {
            dataset = this.getVolume(string);
        }
        return dataset;
    }

    @Override
    public Dataset[] getDependents(String ... stringArray) {
        DatasetSet<Dataset> datasetSet = new DatasetSet<Dataset>();
        for (String string : stringArray) {
            Dataset dataset = this.getDataset(string);
            this.getDependents(dataset, datasetSet);
        }
        return Util.toArray(datasetSet, Dataset.class);
    }

    @Override
    public Dataset[] getRollbackDependents(String string) {
        Dataset[] datasetArray;
        Snapshot snapshot = this.getSnapshot(string);
        if (snapshot == null) {
            return null;
        }
        DatasetSet<Dataset> datasetSet = new DatasetSet<Dataset>();
        long l = snapshot.getCreateIndex();
        for (Dataset dataset : datasetArray = this.getDatasets(DatasetBean.getParentName(string))) {
            Dataset[] datasetArray2;
            String string2 = dataset.getFullName();
            if (string2.equals(string)) continue;
            for (Dataset dataset2 : datasetArray2 = this.getDependents(string2)) {
                long l2 = dataset2.getCreateIndex();
                if (l2 <= l) continue;
                datasetSet.add(dataset2);
            }
        }
        return Util.toArray(datasetSet, Dataset.class);
    }

    @Override
    public FileSystem[] getAllFileSystemsUnder(String string) {
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
        try {
            this.getAllFileSystemsUnder(string, arrayList);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        return Util.toArray(arrayList, FileSystem.class);
    }

    @Override
    public Volume[] getAllVolumesUnder(String string) {
        ArrayList<Volume> arrayList = new ArrayList<Volume>();
        try {
            this.getAllVolumesUnder(string, arrayList);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        return Util.toArray(arrayList, Volume.class);
    }

    @Override
    public Snapshot[] getAllSnapshotsUnder(String string) {
        ArrayList arrayList = new ArrayList();
        FileSystem[] fileSystemArray = this.getAllFileSystemsUnder(string);
        if (fileSystemArray == null) {
            return null;
        }
        Collections.addAll(arrayList, fileSystemArray);
        Collections.addAll(arrayList, this.getAllVolumesUnder(string));
        ArrayList<Snapshot> arrayList2 = new ArrayList<Snapshot>();
        for (Dataset dataset : arrayList) {
            Snapshot[] snapshotArray = this.getSnapshots(dataset.getFullName());
            arrayList2.addAll(Arrays.asList(snapshotArray));
        }
        return Util.toArray(arrayList2, Snapshot.class);
    }

    @Override
    public FileSystemSnapshot[] getAllFileSystemSnapshotsUnder(String string) {
        ArrayList<FileSystemSnapshot> arrayList = new ArrayList<FileSystemSnapshot>();
        FileSystem[] fileSystemArray = this.getAllFileSystemsUnder(string);
        if (fileSystemArray == null) {
            return null;
        }
        for (FileSystem fileSystem : fileSystemArray) {
            for (Snapshot snapshot : this.getSnapshots(fileSystem.getFullName())) {
                arrayList.add((FileSystemSnapshot)snapshot);
            }
        }
        return Util.toArray(arrayList, FileSystemSnapshot.class);
    }

    @Override
    public VolumeSnapshot[] getAllVolumeSnapshotsUnder(String string) {
        ArrayList<VolumeSnapshot> arrayList = new ArrayList<VolumeSnapshot>();
        Volume[] volumeArray = this.getAllVolumesUnder(string);
        if (volumeArray == null) {
            return null;
        }
        for (Volume volume : volumeArray) {
            for (Snapshot snapshot : this.getSnapshots(volume.getFullName())) {
                arrayList.add((VolumeSnapshot)snapshot);
            }
        }
        return Util.toArray(arrayList, VolumeSnapshot.class);
    }

    @Override
    public FileSystem[] getFSClones(String string) {
        Snapshot snapshot = this.getSnapshot(string);
        if (snapshot == null || !(snapshot instanceof FileSystemSnapshot)) {
            return null;
        }
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
        String string2 = snapshot.getPoolName();
        String string3 = snapshot.getFullName();
        for (FileSystem fileSystem : this.getAllFileSystemsUnder(string2)) {
            String string4 = fileSystem.getPrototype();
            if (string4 == null || !string4.equals(string3)) continue;
            arrayList.add(fileSystem);
        }
        return Util.toArray(arrayList, FileSystem.class);
    }

    @Override
    public Volume[] getVolumeClones(String string) {
        Snapshot snapshot = this.getSnapshot(string);
        if (snapshot == null || !(snapshot instanceof VolumeSnapshot)) {
            return null;
        }
        ArrayList<Volume> arrayList = new ArrayList<Volume>();
        String string2 = snapshot.getPoolName();
        String string3 = snapshot.getFullName();
        for (Volume volume : this.getAllVolumesUnder(string2)) {
            String string4 = volume.getPrototype();
            if (string4 == null || !string4.equals(string3)) continue;
            arrayList.add(volume);
        }
        return Util.toArray(arrayList, Volume.class);
    }

    @Override
    public VirtualDevice getVirtualDevice(String string, long l) {
        return this.getVirtualDevice(string, null, l);
    }

    @Override
    public Property getPropertyDefault(String string, String string2) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = "mountpoint".equals(string2);
        if (bl) {
            stringBuffer = new StringBuffer();
        }
        String string3 = null;
        Property property = null;
        while (true) {
            object2 = DatasetBean.getParentChild(string);
            string = object2[0];
            if (bl) {
                stringBuffer.insert(0, object2[1]).insert(0, File.separator);
            }
            if (string == null) {
                try {
                    property = this.getPropertyDefault(string2);
                }
                catch (NullPointerException nullPointerException) {}
                break;
            }
            object = this.getDataset(string);
            if (object == null) continue;
            try {
                property = object.getProperty(string2);
                if (property == null) continue;
                string3 = object.getFullName();
            }
            catch (NoSuchElementException noSuchElementException) {
                continue;
            }
            break;
        }
        if (property != null) {
            if (bl && ((object2 = property.getValue()).equals("legacy") || object2.equals("none"))) {
                bl = false;
            }
            object2 = property.getLineage();
            if (bl) {
                stringBuffer.insert(0, property.getValue());
                object = stringBuffer.toString().replaceFirst("^\\Q" + File.separator + File.separator + "\\E", File.separator);
                property = string3 == null ? new MountPointProperty((String)object, (Property.Lineage)((Object)object2)) : new MountPointProperty((String)object, string3);
            } else if (object2 == Property.Lineage.ZFS_PROP_LINEAGE_LOCAL) {
                property = property.clone();
                property.setLineage(Property.Lineage.ZFS_PROP_LINEAGE_INHERITED);
                property.setInheritedFrom(string3);
            }
        }
        return property;
    }

    @Override
    public CommandStatus[] exec(Command ... commandArray) throws IOException {
        ArrayList<CommandStatus> arrayList = new ArrayList<CommandStatus>();
        for (Command command : commandArray) {
            CommandStatus commandStatus = command.exec();
            arrayList.add(commandStatus);
            if (!commandStatus.getSuccessful()) break;
        }
        return Util.toArray(arrayList, CommandStatus.class);
    }

    private void getAllFileSystemsUnder(String string, ArrayList<FileSystem> arrayList) {
        if (string == null) {
            for (Pool pool : this.getPools()) {
                if (!PoolBean.isActive(pool)) continue;
                arrayList.add(pool);
                this.getAllFileSystemsUnder(pool.getPoolName(), arrayList);
            }
        } else {
            FileSystem[] fileSystemArray = this.getFileSystems(string);
            if (fileSystemArray == null) {
                throw new NullPointerException();
            }
            arrayList.addAll(Arrays.asList(fileSystemArray));
            for (FileSystem fileSystem : fileSystemArray) {
                this.getAllFileSystemsUnder(fileSystem.getFullName(), arrayList);
            }
        }
    }

    private void getAllVolumesUnder(String string, ArrayList<Volume> arrayList) {
        if (string == null) {
            for (Pool pool : this.getPools()) {
                if (!PoolBean.isActive(pool)) continue;
                this.getAllVolumesUnder(pool.getPoolName(), arrayList);
            }
        } else {
            Volume[] volumeArray = this.getVolumes(string);
            if (volumeArray == null) {
                throw new NullPointerException();
            }
            arrayList.addAll(Arrays.asList(volumeArray));
            for (FileSystem fileSystem : this.getFileSystems(string)) {
                this.getAllVolumesUnder(fileSystem.getFullName(), arrayList);
            }
        }
    }

    private void getDependents(Dataset dataset, DatasetSet<Dataset> datasetSet) {
        if (dataset != null) {
            String string = dataset.getFullName();
            if (datasetSet.add(dataset)) {
                if (dataset instanceof FileSystem) {
                    for (FileSystem dataset2 : this.getFileSystems(string)) {
                        this.getDependents(dataset2, datasetSet);
                    }
                }
                if (dataset instanceof FileSystem || dataset instanceof FileSystemSnapshot) {
                    for (Dataset dataset2 : this.getFSClones(string)) {
                        this.getDependents(dataset2, datasetSet);
                    }
                } else if (dataset instanceof Volume || dataset instanceof VolumeSnapshot) {
                    for (Dataset dataset3 : this.getVolumeClones(string)) {
                        this.getDependents(dataset3, datasetSet);
                    }
                }
                if (!(dataset instanceof Snapshot)) {
                    for (Dataset dataset4 : this.getSnapshots(string)) {
                        this.getDependents(dataset4, datasetSet);
                    }
                }
            }
        }
    }

    private VirtualDevice getVirtualDevice(String string, Long l, long l2) {
        for (VirtualDevice virtualDevice : l == null ? this.getVirtualDevices(string) : this.getVirtualDevices(string, l)) {
            long l3 = virtualDevice.getIndex();
            if (l3 == l2) {
                return virtualDevice;
            }
            VirtualDevice virtualDevice2 = this.getVirtualDevice(string, l3, l2);
            if (virtualDevice2 == null) continue;
            return virtualDevice2;
        }
        return null;
    }

    static {
        lock = new Object();
    }
}

