/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.common.model;

import com.sun.zfs.common.model.AclInheritProperty;
import com.sun.zfs.common.model.AclModeProperty;
import com.sun.zfs.common.model.BeanToXMLException;
import com.sun.zfs.common.model.BooleanProperty;
import com.sun.zfs.common.model.ChecksumProperty;
import com.sun.zfs.common.model.CompressRatioProperty;
import com.sun.zfs.common.model.CompressionProperty;
import com.sun.zfs.common.model.CreationProperty;
import com.sun.zfs.common.model.Dataset;
import com.sun.zfs.common.model.DatasetBean;
import com.sun.zfs.common.model.DeviceStats;
import com.sun.zfs.common.model.DiskDevice;
import com.sun.zfs.common.model.DiskDeviceBean;
import com.sun.zfs.common.model.DiskVirtualDeviceBean;
import com.sun.zfs.common.model.FileSystem;
import com.sun.zfs.common.model.FileSystemBean;
import com.sun.zfs.common.model.FileSystemSnapshot;
import com.sun.zfs.common.model.FileSystemSnapshotBean;
import com.sun.zfs.common.model.FileVirtualDeviceBean;
import com.sun.zfs.common.model.ImportablePool;
import com.sun.zfs.common.model.ImportablePoolBean;
import com.sun.zfs.common.model.LeafVirtualDevice;
import com.sun.zfs.common.model.LongProperty;
import com.sun.zfs.common.model.MirrorVirtualDeviceBean;
import com.sun.zfs.common.model.MissingRequiredAttributeException;
import com.sun.zfs.common.model.MountPointProperty;
import com.sun.zfs.common.model.NoSuchAccessorException;
import com.sun.zfs.common.model.NoSuchMutatorException;
import com.sun.zfs.common.model.Pool;
import com.sun.zfs.common.model.PoolBean;
import com.sun.zfs.common.model.PoolStats;
import com.sun.zfs.common.model.Property;
import com.sun.zfs.common.model.RAIDVirtualDeviceBean;
import com.sun.zfs.common.model.RecordSizeProperty;
import com.sun.zfs.common.model.ShareNFSProperty;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.SliceDevice;
import com.sun.zfs.common.model.SliceDeviceBean;
import com.sun.zfs.common.model.SliceUsage;
import com.sun.zfs.common.model.SliceVirtualDeviceBean;
import com.sun.zfs.common.model.SnapDirProperty;
import com.sun.zfs.common.model.Snapshot;
import com.sun.zfs.common.model.SnapshotBean;
import com.sun.zfs.common.model.StringProperty;
import com.sun.zfs.common.model.VirtualDevice;
import com.sun.zfs.common.model.VirtualDeviceBean;
import com.sun.zfs.common.model.VolBlockSizeProperty;
import com.sun.zfs.common.model.Volume;
import com.sun.zfs.common.model.VolumeBean;
import com.sun.zfs.common.model.VolumeSnapshot;
import com.sun.zfs.common.model.VolumeSnapshotBean;
import com.sun.zfs.common.model.XMLToBeanException;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDataModel
extends SimpleZDataModel {
    private static final AttributeMap[] ATTRIBUTE_MAPS = new AttributeMap[]{new AttributeMap(Dataset.class, "basename"), new AttributeMap(DeviceStats.class, "checksumerrors"), new AttributeMap(DeviceStats.class, "devicestate"), new AttributeMap(DeviceStats.class, "devicestatus"), new AttributeMap(DeviceStats.class, "readbytes"), new AttributeMap(DeviceStats.class, "readerrors"), new AttributeMap(DeviceStats.class, "readoperations"), new AttributeMap(DeviceStats.class, "size"), new AttributeMap(DeviceStats.class, "replacementsize"), new AttributeMap(DeviceStats.class, "used"), new AttributeMap(DeviceStats.class, "writebytes"), new AttributeMap(DeviceStats.class, "writeerrors"), new AttributeMap(DeviceStats.class, "writeoperations"), new AttributeMap(DiskDevice.class, "inuse"), new AttributeMap(DiskDevice.class, "name"), new AttributeMap(DiskDevice.class, "size"), new AttributeMap(SliceDevice.class, "name"), new AttributeMap(SliceDevice.class, "size"), new AttributeMap(SliceDevice.class, "start"), new AttributeMap(LeafVirtualDevice.class, "name"), new AttributeMap(ImportablePool.class, "name"), new AttributeMap(ImportablePool.class, "id"), new AttributeMap(PoolStats.class, "poolstate"), new AttributeMap(PoolStats.class, "poolstatus"), new AttributeMap(PoolStats.class, "poolversion"), new AttributeMap(VirtualDevice.class, "index")};
    private static final String ATTR_DATASET_NAME = "basename";
    private static final String ATTR_ALIAS_NAME = "name";
    private static final String ATTR_DISK_INUSE = "inuse";
    private static final String ATTR_DISK_NAME = "name";
    private static final String ATTR_DISK_SIZE = "size";
    private static final String ATTR_PROPERTY_LINEAGE = "lineage";
    private static final String ATTR_PROPERTY_NAME = "name";
    private static final String ATTR_PROPERTY_READONLY = "readonly";
    private static final String ATTR_PROPERTY_SOURCE = "source";
    private static final String ATTR_PROPERTY_TYPE = "type";
    private static final String ATTR_PROPERTY_TYPE_ACLINHERIT = "aclinherit";
    private static final String ATTR_PROPERTY_TYPE_ACLMODE = "aclmode";
    private static final String ATTR_PROPERTY_TYPE_BOOLEAN = "boolean";
    private static final String ATTR_PROPERTY_TYPE_CHECKSUM = "checksum";
    private static final String ATTR_PROPERTY_TYPE_COMPRESSION = "compression";
    private static final String ATTR_PROPERTY_TYPE_COMPRESSRATIO = "compressratio";
    private static final String ATTR_PROPERTY_TYPE_CREATION = "creation";
    private static final String ATTR_PROPERTY_TYPE_LONG = "long";
    private static final String ATTR_PROPERTY_TYPE_MOUNTPOINT = "mountpoint";
    private static final String ATTR_PROPERTY_TYPE_RECORDSIZE = "recordsize";
    private static final String ATTR_PROPERTY_TYPE_SHARENFS = "sharenfs";
    private static final String ATTR_PROPERTY_TYPE_SNAPDIR = "snapdir";
    private static final String ATTR_PROPERTY_TYPE_STRING = "string";
    private static final String ATTR_PROPERTY_TYPE_VOLBLOCKSIZE = "volblocksize";
    private static final String ATTR_PROPERTY_VALUE = "value";
    private static final String ATTR_SLICE_NAME = "name";
    private static final String ATTR_SLICE_SIZE = "size";
    private static final String ATTR_SLICE_START = "start";
    private static final String ATTR_SLICE_USED_BY = "used-by";
    private static final String ATTR_SLICE_USED_NAME = "used-name";
    private static final String ATTR_VALID_TYPE = "type";
    private static final String ATTR_VDEV_INDEX = "index";
    private static final String ELEMENT_ALIAS = "alias";
    private static final String ELEMENT_AVAILABLE = "available";
    private static final String ELEMENT_DEFAULTS = "defaults";
    private static final String ELEMENT_DISK = "disk";
    private static final String ELEMENT_FILESYSTEM = "filesystem";
    private static final String ELEMENT_IMPORTABLE = "importable";
    private static final String ELEMENT_POOL = "pool";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ELEMENT_SLICE = "slice";
    private static final String ELEMENT_SNAPSHOT = "snapshot";
    private static final String ELEMENT_VALID = "valid";
    private static final String ELEMENT_VDEV_DISK = "disk";
    private static final String ELEMENT_VDEV_FILE = "file";
    private static final String ELEMENT_VDEV_MIRROR = "mirror";
    private static final String ELEMENT_VDEV_RAIDZ = "raid";
    private static final String ELEMENT_VDEV_SLICE = "slice";
    private static final String ELEMENT_VOLUME = "volume";
    private static final String ELEMENT_ZFSCONFIG = "zfsconfig";
    private static final XPathElement[] ELEMENTS_POOL = new XPathElement[]{new XPathElement("pool", 0)};
    private static final XPathElement[] ELEMENTS_FILESYSTEM = new XPathElement[]{new XPathElement("pool", 0), new XPathElement("filesystem", -1)};
    private static final XPathElement[] ELEMENTS_VOLUME = new XPathElement[]{new XPathElement("volume", -1), new XPathElement("pool", 0)};
    private static final XPathElement[] ELEMENTS_FILESYSTEM_SNAPSHOT = new XPathElement[]{new XPathElement("snapshot", -1), new XPathElement("pool", 0), new XPathElement("filesystem", -2)};
    private static final XPathElement[] ELEMENTS_VOLUME_SNAPSHOT = new XPathElement[]{new XPathElement("snapshot", -1), new XPathElement("pool", 0), new XPathElement("volume", -2)};
    private Document document;
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public XMLDataModel() {
    }

    public XMLDataModel(Document document) {
        this();
        this.setDocument(document);
    }

    public XMLDataModel(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        this(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream));
        inputStream.close();
    }

    public XMLDataModel(String string) throws ParserConfigurationException, SAXException, IOException {
        this(XMLDataModel.class.getResourceAsStream(string));
    }

    public XMLDataModel(File file) throws ParserConfigurationException, SAXException, IOException {
        this(new FileInputStream(file));
    }

    @Override
    public ImportablePool[] getImportablePools(String ... stringArray) {
        ArrayList<ImportablePoolBean> arrayList = new ArrayList<ImportablePoolBean>();
        try {
            NodeList nodeList = (NodeList)this.xpath.evaluate("/zfsconfig/importable/pool", this.document, XPathConstants.NODESET);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                ImportablePoolBean importablePoolBean = new ImportablePoolBean();
                XMLDataModel.populateBeanRuntime(importablePoolBean, element);
                arrayList.add(importablePoolBean);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        return arrayList.toArray(new ImportablePool[arrayList.size()]);
    }

    @Override
    public Pool[] getPools() {
        String string = "/zfsconfig/pool";
        NodeList nodeList = (NodeList)this.evaluate(string, this.document, XPathConstants.NODESET);
        int n = nodeList == null ? 0 : nodeList.getLength();
        Pool[] poolArray = new PoolBean[n];
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            poolArray[i] = new PoolBean();
            this.populatePoolBean((PoolBean)poolArray[i], (Element)node);
        }
        return poolArray;
    }

    @Override
    public Pool getPool(String string) {
        PoolBean poolBean = null;
        String string2 = this.getDatasetExpression(string, ELEMENTS_POOL);
        Element element = (Element)this.evaluate(string2, this.document, XPathConstants.NODE);
        if (element != null) {
            poolBean = new PoolBean();
            this.populatePoolBean(poolBean, element);
        }
        return poolBean;
    }

    @Override
    public FileSystem[] getFileSystems(String string) {
        if (string == null) {
            return this.getPools();
        }
        String string2 = this.getDatasetExpression(string, ELEMENTS_FILESYSTEM) + "/" + ELEMENT_FILESYSTEM;
        NodeList nodeList = (NodeList)this.evaluate(string2.toString(), this.document, XPathConstants.NODESET);
        int n = nodeList == null ? 0 : nodeList.getLength();
        FileSystem[] fileSystemArray = new FileSystemBean[n];
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            fileSystemArray[i] = new FileSystemBean();
            this.populateFileSystemBean((FileSystemBean)fileSystemArray[i], (Element)node, string);
        }
        return fileSystemArray;
    }

    @Override
    public FileSystem getFileSystem(String string) {
        if (DatasetBean.isPool(string)) {
            return this.getPool(string);
        }
        FileSystemBean fileSystemBean = null;
        String string2 = this.getDatasetExpression(string, ELEMENTS_FILESYSTEM);
        Element element = (Element)this.evaluate(string2, this.document, XPathConstants.NODE);
        if (element != null) {
            fileSystemBean = new FileSystemBean();
            this.populateDatasetBean(fileSystemBean, element, DatasetBean.getParentName(string));
        }
        return fileSystemBean;
    }

    @Override
    public Volume[] getVolumes(String string) {
        String string2 = this.getDatasetExpression(string, ELEMENTS_FILESYSTEM) + "/" + ELEMENT_VOLUME;
        NodeList nodeList = (NodeList)this.evaluate(string2.toString(), this.document, XPathConstants.NODESET);
        int n = nodeList == null ? 0 : nodeList.getLength();
        Volume[] volumeArray = new VolumeBean[n];
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            volumeArray[i] = new VolumeBean();
            this.populateVolumeBean((VolumeBean)volumeArray[i], (Element)node, string);
        }
        return volumeArray;
    }

    @Override
    public Snapshot[] getSnapshots(String string) {
        Snapshot[] snapshotArray = this.getFileSystemSnapshots(string);
        if (snapshotArray.length == 0) {
            snapshotArray = this.getVolumeSnapshots(string);
        }
        return snapshotArray;
    }

    @Override
    public Snapshot getSnapshot(String string) {
        SnapshotBean snapshotBean = null;
        String string2 = this.getDatasetExpression(string, ELEMENTS_FILESYSTEM_SNAPSHOT);
        Element element = (Element)this.evaluate(string2, this.document, XPathConstants.NODE);
        String string3 = DatasetBean.getParentName(string);
        if (element != null) {
            snapshotBean = new FileSystemSnapshotBean();
            this.populateFileSystemSnapshotBean((FileSystemSnapshotBean)snapshotBean, element, string3);
        } else {
            string2 = this.getDatasetExpression(string, ELEMENTS_VOLUME_SNAPSHOT);
            element = (Element)this.evaluate(string2, this.document, XPathConstants.NODE);
            if (element != null) {
                snapshotBean = new VolumeSnapshotBean();
                this.populateVolumeSnapshotBean((VolumeSnapshotBean)snapshotBean, element, string3);
            }
        }
        return snapshotBean;
    }

    @Override
    public VirtualDevice[] getVirtualDevices(String string, long l) {
        return this.getVirtualDevices(string, new Long(l));
    }

    private VirtualDevice[] getVirtualDevices(String string, Long l) {
        VirtualDevice[] virtualDeviceArray;
        String string2 = this.getVirtualDeviceExpression(string, l);
        try {
            NodeList nodeList = (NodeList)this.xpath.evaluate(string2, this.document, XPathConstants.NODESET);
            int n = nodeList == null ? 0 : nodeList.getLength();
            virtualDeviceArray = new VirtualDeviceBean[n];
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                String string3 = element.getNodeName();
                if (string3.equals(ELEMENT_VDEV_MIRROR)) {
                    virtualDeviceArray[i] = new MirrorVirtualDeviceBean();
                } else if (string3.equals(ELEMENT_VDEV_RAIDZ)) {
                    virtualDeviceArray[i] = new RAIDVirtualDeviceBean();
                } else if (string3.equals(ELEMENT_VDEV_FILE)) {
                    virtualDeviceArray[i] = new FileVirtualDeviceBean();
                } else if (string3.equals("disk")) {
                    virtualDeviceArray[i] = new DiskVirtualDeviceBean();
                } else if (string3.equals("slice")) {
                    virtualDeviceArray[i] = new SliceVirtualDeviceBean();
                } else {
                    System.err.println("Unknown type: " + string3);
                }
                if (virtualDeviceArray[i] == null) continue;
                this.populateVirtualDeviceBean((VirtualDeviceBean)virtualDeviceArray[i], element, string, l);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            virtualDeviceArray = new VirtualDeviceBean[]{};
            xPathExpressionException.printStackTrace();
        }
        return virtualDeviceArray;
    }

    @Override
    public VirtualDevice[] getVirtualDevices(String string) {
        return this.getVirtualDevices(string, null);
    }

    @Override
    public DiskDevice[] getAvailableDisks() {
        ArrayList<DiskDeviceBean> arrayList = new ArrayList<DiskDeviceBean>();
        try {
            NodeList nodeList = (NodeList)this.xpath.evaluate("/zfsconfig/available/disk", this.document, XPathConstants.NODESET);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                try {
                    Object object;
                    NodeList nodeList2 = (NodeList)this.xpath.evaluate("slice", node, XPathConstants.NODESET);
                    ArrayList<SliceDeviceBean> arrayList2 = new ArrayList<SliceDeviceBean>();
                    int n2 = nodeList2.getLength();
                    for (int j = 0; j < n2; ++j) {
                        Node node2 = nodeList2.item(j);
                        String string = this.getString("@used-name", node2, null);
                        SliceUsage sliceUsage = null;
                        if (string != null) {
                            try {
                                object = SliceUsage.Use.valueOf(string);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                object = SliceUsage.Use.unknown;
                            }
                            String string2 = this.getString("@used-by", node2);
                            sliceUsage = new SliceUsage((SliceUsage.Use)((Object)object), string2);
                        }
                        object = this.getString("@name", node2);
                        long l = this.getLong("@size", node2);
                        long l2 = this.getLong("@start", node2);
                        SliceDeviceBean sliceDeviceBean = new SliceDeviceBean(l, (String)object, l2, sliceUsage);
                        arrayList2.add(sliceDeviceBean);
                    }
                    SliceDeviceBean[] sliceDeviceBeanArray = arrayList2.toArray(new SliceDeviceBean[arrayList2.size()]);
                    String string = this.getString("@name", node);
                    long l = this.getLong("@size", node);
                    boolean bl = this.getBoolean("@inuse", node);
                    object = (NodeList)this.xpath.evaluate(ELEMENT_ALIAS, node, XPathConstants.NODESET);
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    int n3 = object.getLength();
                    for (int j = 0; j < n3; ++j) {
                        String string3 = this.getString("@name", object.item(j));
                        arrayList3.add(string3);
                    }
                    String[] stringArray = arrayList3.toArray(new String[arrayList3.size()]);
                    arrayList.add(new DiskDeviceBean(l, string, stringArray, sliceDeviceBeanArray, bl));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        return arrayList.toArray(new DiskDevice[arrayList.size()]);
    }

    @Override
    public Property getPropertyDefault(String string) {
        try {
            String string2 = "/zfsconfig/defaults/property[@name='" + string + "']";
            Node node = (Node)this.xpath.evaluate(string2, this.document, XPathConstants.NODE);
            if (node != null) {
                return this.getProperty(node);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        return null;
    }

    @Override
    public String[] getValidPropertyNames(Class<? extends Dataset> clazz) {
        for (Class clazz2 : new Class[]{FileSystem.class, Volume.class, Snapshot.class}) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            try {
                String string = "/zfsconfig/valid[@type='" + clazz2.getName() + "']/" + ELEMENT_PROPERTY;
                NodeList nodeList = (NodeList)this.xpath.evaluate(string, this.document, XPathConstants.NODESET);
                int n = nodeList == null ? 0 : nodeList.getLength();
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    stringArray[i] = this.getString("@name", node);
                }
                return stringArray;
            }
            catch (XPathExpressionException xPathExpressionException) {
                xPathExpressionException.printStackTrace();
                break;
            }
        }
        return new String[0];
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public FileSystemSnapshot[] getFileSystemSnapshots(String string) {
        String string2 = this.getDatasetExpression(string, ELEMENTS_FILESYSTEM) + "/" + ELEMENT_SNAPSHOT;
        NodeList nodeList = (NodeList)this.evaluate(string2.toString(), this.document, XPathConstants.NODESET);
        int n = nodeList == null ? 0 : nodeList.getLength();
        FileSystemSnapshot[] fileSystemSnapshotArray = new FileSystemSnapshotBean[n];
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            fileSystemSnapshotArray[i] = new FileSystemSnapshotBean();
            this.populateFileSystemSnapshotBean((FileSystemSnapshotBean)fileSystemSnapshotArray[i], (Element)node, string);
        }
        return fileSystemSnapshotArray;
    }

    public VolumeSnapshot[] getVolumeSnapshots(String string) {
        String string2 = this.getDatasetExpression(string, ELEMENTS_VOLUME) + "/" + ELEMENT_SNAPSHOT;
        NodeList nodeList = (NodeList)this.evaluate(string2.toString(), this.document, XPathConstants.NODESET);
        int n = nodeList == null ? 0 : nodeList.getLength();
        VolumeSnapshot[] volumeSnapshotArray = new VolumeSnapshotBean[n];
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            volumeSnapshotArray[i] = new VolumeSnapshotBean();
            this.populateVolumeSnapshotBean((VolumeSnapshotBean)volumeSnapshotArray[i], (Element)node, string);
        }
        return volumeSnapshotArray;
    }

    private Object evaluate(String string, Object object, QName qName) {
        try {
            return this.xpath.evaluate(string, object, qName);
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
            throw new IllegalArgumentException(xPathExpressionException);
        }
    }

    private Property getProperty(Node node) {
        String string = null;
        String string2 = null;
        String string3 = node.getNodeName();
        Property property = null;
        try {
            string = ATTR_PROPERTY_SOURCE;
            String string4 = this.getString("@" + string, node, null);
            string = ATTR_PROPERTY_VALUE;
            string2 = this.getString("@" + string, node, null);
            string = "type";
            String string5 = this.getString("@" + string, node, null);
            string = ATTR_PROPERTY_READONLY;
            boolean bl = this.getBoolean("@" + string, node);
            string = "name";
            String string6 = this.getString("@" + string, node);
            string = ATTR_PROPERTY_LINEAGE;
            Property.Lineage lineage = Property.Lineage.valueOf(this.getString("@" + string, node));
            string = ATTR_PROPERTY_VALUE;
            if (string5 == null) {
                string5 = ATTR_PROPERTY_TYPE_STRING;
            }
            if (string5.equals(ATTR_PROPERTY_TYPE_BOOLEAN)) {
                Boolean bl2 = BooleanProperty.getValueFromString(string2);
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new BooleanProperty(string6, bl2, bl, string4) : new BooleanProperty(string6, bl2, bl, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_LONG)) {
                long l = LongProperty.getValueFromString(string2);
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new LongProperty(string6, (Long)l, bl, string4) : new LongProperty(string6, (Long)l, bl, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_STRING)) {
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new StringProperty(string6, string2, bl, string4) : new StringProperty(string6, string2, bl, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_ACLMODE)) {
                AclModeProperty.AclMode aclMode = AclModeProperty.AclMode.valueOf(string2);
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new AclModeProperty(aclMode, string4) : new AclModeProperty(aclMode, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_ACLINHERIT)) {
                AclInheritProperty.AclInherit aclInherit = AclInheritProperty.AclInherit.valueOf(string2);
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new AclInheritProperty(aclInherit, string4) : new AclInheritProperty(aclInherit, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_CHECKSUM)) {
                ChecksumProperty.Checksum checksum = ChecksumProperty.Checksum.valueOf(string2);
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new ChecksumProperty(checksum, string4) : new ChecksumProperty(checksum, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_COMPRESSION)) {
                CompressionProperty.Compression compression = CompressionProperty.Compression.valueOf(string2);
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new CompressionProperty(compression, string4) : new CompressionProperty(compression, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_COMPRESSRATIO)) {
                long l = Util.uint64StringToLong(string2);
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new CompressRatioProperty((Long)l, string4) : new CompressRatioProperty((Long)l, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_CREATION)) {
                Date date = new Date(Long.parseLong(string2));
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new CreationProperty(date, string4) : new CreationProperty(date, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_MOUNTPOINT)) {
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new MountPointProperty(string2, string4) : new MountPointProperty(string2, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_RECORDSIZE)) {
                long l = Util.uint64StringToLong(string2);
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new RecordSizeProperty((Long)l, string4) : new RecordSizeProperty((Long)l, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_SHARENFS)) {
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new ShareNFSProperty(string2, string4) : new ShareNFSProperty(string2, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_SNAPDIR)) {
                SnapDirProperty.SnapDir snapDir = SnapDirProperty.SnapDir.valueOf(string2);
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new SnapDirProperty(snapDir, string4) : new SnapDirProperty(snapDir, lineage);
            } else if (string5.equals(ATTR_PROPERTY_TYPE_VOLBLOCKSIZE)) {
                long l = Util.uint64StringToLong(string2);
                property = lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED ? new VolBlockSizeProperty((Long)l, string4) : new VolBlockSizeProperty((Long)l, lineage);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("attribute \"" + string + "\" " + "not specified in node <" + string3 + ">");
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("attribute \"" + string + "\" " + "invalid in node <" + string3 + ">: " + numberFormatException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.printf("invalid value for attribute \"%s\": %s\n", string, string2);
        }
        catch (XPathExpressionException xPathExpressionException) {
            System.err.println("invalid expression: " + xPathExpressionException.getMessage());
        }
        return property;
    }

    private void populateDatasetBean(DatasetBean datasetBean, Element element, String string) {
        XMLDataModel.populateBeanRuntime(datasetBean, element);
        datasetBean.setPoolName(DatasetBean.getPoolName(string));
        datasetBean.setParentName(string);
        NodeList nodeList = (NodeList)this.evaluate(ELEMENT_PROPERTY, element, XPathConstants.NODESET);
        int n = nodeList == null ? 0 : nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            Property property = this.getProperty(node);
            if (property == null) continue;
            datasetBean.addProperty(property);
        }
    }

    private void populateFileSystemBean(FileSystemBean fileSystemBean, Element element, String string) {
        this.populateDatasetBean(fileSystemBean, element, string);
    }

    private void populateVolumeBean(VolumeBean volumeBean, Element element, String string) {
        this.populateDatasetBean(volumeBean, element, string);
    }

    private void populateSnapshotBean(SnapshotBean snapshotBean, Element element, String string) {
        this.populateDatasetBean(snapshotBean, element, string);
    }

    private void populateFileSystemSnapshotBean(FileSystemSnapshotBean fileSystemSnapshotBean, Element element, String string) {
        this.populateSnapshotBean(fileSystemSnapshotBean, element, string);
    }

    private void populateVolumeSnapshotBean(VolumeSnapshotBean volumeSnapshotBean, Element element, String string) {
        this.populateSnapshotBean(volumeSnapshotBean, element, string);
    }

    private void populatePoolBean(PoolBean poolBean, Element element) {
        this.populateFileSystemBean(poolBean, element, null);
    }

    private void populateVirtualDeviceBean(VirtualDeviceBean virtualDeviceBean, Element element, String string, Long l) {
        virtualDeviceBean.setPoolName(string);
        virtualDeviceBean.setParentIndex(l);
        XMLDataModel.populateBeanRuntime(virtualDeviceBean, element);
    }

    private String getDeviceExpression(String string, XPathElement[] xPathElementArray, String string2) {
        String[] stringArray = DatasetBean.getDeviceNameComponents(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/").append(ELEMENT_ZFSCONFIG);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = null;
            for (int j = 0; j < xPathElementArray.length; ++j) {
                int n = xPathElementArray[j].getIndex();
                if (n < 0) {
                    n += stringArray.length;
                }
                if (i != n) continue;
                string3 = xPathElementArray[j].getName();
                break;
            }
            if (string3 == null) {
                string3 = string2;
            }
            stringBuffer.append("/").append(string3).append("[@").append(ATTR_DATASET_NAME).append("='").append(stringArray[i]).append("']");
        }
        return stringBuffer.toString();
    }

    private String getDatasetExpression(String string, XPathElement[] xPathElementArray) {
        return this.getDeviceExpression(string, xPathElementArray, ELEMENT_FILESYSTEM);
    }

    @Override
    public Volume getVolume(String string) {
        VolumeBean volumeBean = null;
        String string2 = this.getDatasetExpression(string, ELEMENTS_VOLUME);
        Element element = (Element)this.evaluate(string2, this.document, XPathConstants.NODE);
        if (element != null) {
            volumeBean = new VolumeBean();
            this.populateVolumeBean(volumeBean, element, DatasetBean.getParentName(string));
        }
        return volumeBean;
    }

    private String getVirtualDeviceExpression(String string, Long l) {
        String string2 = "name()='raid' or name()='mirror' or name()='file' or name()='disk' or name()='slice'";
        return "/zfsconfig/pool[@basename='" + string + "']/" + (l == null ? "" : "/*[(" + string2 + ") and (@" + ATTR_VDEV_INDEX + "='" + Util.longToUint64String(l) + "' or @" + ATTR_VDEV_INDEX + "='" + l + "')]/") + "*[" + string2 + "]";
    }

    private String getString(String string, Object object) throws XPathExpressionException {
        String string2 = this.xpath.evaluate(string, object);
        if (string2 == null || string2.equals("")) {
            throw new NullPointerException(string);
        }
        return string2;
    }

    private String getString(String string, Object object, String string2) throws XPathExpressionException {
        try {
            return this.getString(string, object);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    private long getLong(String string, Object object) throws XPathExpressionException {
        return Util.uint64StringToLong(this.getString(string, object));
    }

    private boolean getBoolean(String string, Object object) throws XPathExpressionException {
        return Boolean.parseBoolean(this.xpath.evaluate(string, object));
    }

    private Date getDate(String string, Object object) throws XPathExpressionException {
        return new Date(this.getLong(string, object));
    }

    private static Method[] getMutators(Class clazz, String string) {
        Method[] methodArray;
        ArrayList<Method> arrayList = new ArrayList<Method>();
        string = string.toLowerCase();
        for (Method method : methodArray = clazz.getMethods()) {
            Class<?>[] classArray;
            if (!method.getName().toLowerCase().equals("set" + string) || (classArray = method.getParameterTypes()).length != 1) continue;
            arrayList.add(method);
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    private static Method getAccessor(Class clazz, String string) {
        Method[] methodArray;
        string = string.toLowerCase();
        for (Method method : methodArray = clazz.getMethods()) {
            Class<?>[] classArray;
            if (!method.getName().toLowerCase().equals("get" + string) || (classArray = method.getParameterTypes()).length != 0 || method.getReturnType().equals(Void.TYPE)) continue;
            return method;
        }
        return null;
    }

    private static Object getValueAs(Class clazz, String string) {
        if (string == null) {
            return null;
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return new Boolean(string);
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return new Byte(string);
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return string.length() == 0 ? null : new Character(string.charAt(0));
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return new Short(string);
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return new Integer(string);
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return new Float(string);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return Util.uint64StringToLong(string);
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return new Double(string);
        }
        if (clazz.isInstance(string)) {
            return string;
        }
        if (clazz.isEnum()) {
            T[] TArray;
            for (Object t : TArray = clazz.getEnumConstants()) {
                if (!t.toString().equals(string)) continue;
                return t;
            }
        }
        throw new IllegalArgumentException();
    }

    private static void populateBean(Object object, Element element) throws MissingRequiredAttributeException, NoSuchMutatorException, IllegalArgumentException, InvocationTargetException, ExceptionInInitializerError {
        Class<?> clazz = object.getClass();
        for (AttributeMap attributeMap : ATTRIBUTE_MAPS) {
            String string;
            Class clazz2 = attributeMap.getBeanClass();
            if (!clazz2.isAssignableFrom(clazz)) continue;
            String string2 = attributeMap.getAttribute();
            Method[] methodArray = XMLDataModel.getMutators(clazz, string2);
            if (methodArray.length == 0) {
                throw new NoSuchMutatorException(clazz, string2);
            }
            try {
                string = element.getAttributeNode(string2).getValue();
            }
            catch (NullPointerException nullPointerException) {
                throw new MissingRequiredAttributeException(string2);
            }
            IllegalArgumentException illegalArgumentException = null;
            InvocationTargetException invocationTargetException = null;
            ExceptionInInitializerError exceptionInInitializerError = null;
            boolean bl = false;
            for (Method method : methodArray) {
                Class<?> clazz3 = method.getParameterTypes()[0];
                try {
                    Object object2 = XMLDataModel.getValueAs(clazz3, string);
                    method.invoke(object, object2);
                    bl = true;
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    illegalArgumentException = illegalArgumentException2;
                }
                catch (InvocationTargetException invocationTargetException2) {
                    invocationTargetException = invocationTargetException2;
                }
                catch (ExceptionInInitializerError exceptionInInitializerError2) {
                    exceptionInInitializerError = exceptionInInitializerError2;
                }
            }
            if (bl) continue;
            if (illegalArgumentException != null) {
                throw illegalArgumentException;
            }
            if (invocationTargetException != null) {
                throw invocationTargetException;
            }
            if (exceptionInInitializerError == null) continue;
            throw exceptionInInitializerError;
        }
    }

    private static void populateBeanRuntime(Object object, Element element) throws XMLToBeanException {
        try {
            XMLDataModel.populateBean(object, element);
        }
        catch (Throwable throwable) {
            throw new XMLToBeanException(throwable);
        }
    }

    private static void beanToXML(Object object, Element element) throws ExceptionInInitializerError, InvocationTargetException, MissingRequiredAttributeException, NoSuchAccessorException {
        Class<?> clazz = object.getClass();
        for (AttributeMap attributeMap : ATTRIBUTE_MAPS) {
            Class clazz2 = attributeMap.getBeanClass();
            if (!clazz2.isAssignableFrom(clazz)) continue;
            String string = attributeMap.getAttribute();
            Method method = XMLDataModel.getAccessor(clazz, string);
            if (method == null) {
                throw new NoSuchAccessorException(clazz, string);
            }
            try {
                Object object2 = method.invoke(object, new Object[0]);
                if (object2 == null) {
                    throw new MissingRequiredAttributeException(string);
                }
                XMLDataModel.setAttribute(element, string, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static void beanToXMLRuntime(Object object, Element element) throws BeanToXMLException {
        try {
            XMLDataModel.beanToXML(object, element);
        }
        catch (Throwable throwable) {
            throw new BeanToXMLException(throwable);
        }
    }

    private static void propertyToXML(Property property, Element element) {
        String string;
        XMLDataModel.setAttribute(element, "name", property.getName());
        String string2 = property.getValueAsString();
        if (string2 != null) {
            XMLDataModel.setAttribute(element, ATTR_PROPERTY_VALUE, string2);
        }
        if ((string = Util.getClassBaseName(property).replace("Property", "").toLowerCase()).length() != 0) {
            XMLDataModel.setAttribute(element, "type", string);
        }
        XMLDataModel.setAttribute(element, ATTR_PROPERTY_READONLY, property.getReadOnly());
        XMLDataModel.setAttribute(element, ATTR_PROPERTY_SOURCE, property.getInheritedFrom());
        XMLDataModel.setAttribute(element, ATTR_PROPERTY_LINEAGE, (Object)property.getLineage());
    }

    private static void datasetToXML(Dataset dataset, Element element) {
        XMLDataModel.beanToXMLRuntime(dataset, element);
        Document document = element.getOwnerDocument();
        for (Property property : dataset.getProperties()) {
            Element element2 = document.createElement(ELEMENT_PROPERTY);
            XMLDataModel.propertyToXML(property, element2);
            element.appendChild(element2);
        }
    }

    private static void snapshotToXML(Snapshot snapshot, Element element) {
        XMLDataModel.datasetToXML(snapshot, element);
    }

    private static void fileSystemToXML(FileSystem fileSystem, ZDataModel zDataModel, Element element) {
        Element element2;
        XMLDataModel.datasetToXML(fileSystem, element);
        Document document = element.getOwnerDocument();
        String string = fileSystem.getFullName();
        for (FileSystem dataset : zDataModel.getFileSystems(string)) {
            element2 = document.createElement(ELEMENT_FILESYSTEM);
            XMLDataModel.fileSystemToXML(dataset, zDataModel, element2);
            element.appendChild(element2);
        }
        for (Dataset dataset : zDataModel.getVolumes(string)) {
            element2 = document.createElement(ELEMENT_VOLUME);
            XMLDataModel.volumeToXML((Volume)dataset, zDataModel, element2);
            element.appendChild(element2);
        }
        for (Dataset dataset : zDataModel.getSnapshots(string)) {
            element2 = document.createElement(ELEMENT_SNAPSHOT);
            XMLDataModel.snapshotToXML((Snapshot)dataset, element2);
            element.appendChild(element2);
        }
    }

    private static void volumeToXML(Volume volume, ZDataModel zDataModel, Element element) {
        XMLDataModel.datasetToXML(volume, element);
        Document document = element.getOwnerDocument();
        String string = volume.getFullName();
        for (Snapshot snapshot : zDataModel.getSnapshots(string)) {
            Element element2 = document.createElement(ELEMENT_SNAPSHOT);
            XMLDataModel.snapshotToXML(snapshot, element2);
            element.appendChild(element2);
        }
    }

    private static void virtualDeviceToXML(VirtualDevice virtualDevice, ZDataModel zDataModel, Element element) {
        String string = Util.getClassBaseName(virtualDevice).replaceFirst("VirtualDevice.*", "").toLowerCase();
        Element element2 = element.getOwnerDocument().createElement(string);
        XMLDataModel.beanToXMLRuntime(virtualDevice, element2);
        for (VirtualDevice virtualDevice2 : zDataModel.getVirtualDevices(virtualDevice.getPoolName(), virtualDevice.getIndex())) {
            XMLDataModel.virtualDeviceToXML(virtualDevice2, zDataModel, element2);
        }
        element.appendChild(element2);
    }

    private static void poolToXML(Pool pool, ZDataModel zDataModel, Element element) {
        for (VirtualDevice virtualDevice : zDataModel.getVirtualDevices(pool.getBaseName())) {
            XMLDataModel.virtualDeviceToXML(virtualDevice, zDataModel, element);
        }
        XMLDataModel.fileSystemToXML(pool, zDataModel, element);
    }

    public static void sliceToXML(SliceDevice sliceDevice, Element element) {
        XMLDataModel.beanToXMLRuntime(sliceDevice, element);
        SliceUsage sliceUsage = sliceDevice.getUsage();
        if (sliceUsage != null) {
            XMLDataModel.setAttribute(element, ATTR_SLICE_USED_NAME, sliceUsage.getUse().toString());
            XMLDataModel.setAttribute(element, ATTR_SLICE_USED_BY, sliceUsage.getUsedBy());
        }
    }

    public static void diskToXML(DiskDevice diskDevice, Element element) {
        Element element2;
        XMLDataModel.beanToXMLRuntime(diskDevice, element);
        Document document = element.getOwnerDocument();
        for (String object : diskDevice.getAliases()) {
            element2 = document.createElement(ELEMENT_ALIAS);
            element.appendChild(element2);
            XMLDataModel.setAttribute(element2, "name", object);
        }
        for (SliceDevice sliceDevice : diskDevice.getAvailableSlices()) {
            element2 = document.createElement("slice");
            element.appendChild(element2);
            XMLDataModel.sliceToXML(sliceDevice, element2);
        }
    }

    public static void importablePoolToXML(ImportablePool importablePool, Element element) {
        XMLDataModel.beanToXMLRuntime(importablePool, element);
    }

    /*
     * WARNING - void declaration
     */
    public static void modelToXML(ZDataModel zDataModel, OutputStream outputStream) throws IOException {
        Document document = null;
        try {
            Element element;
            Object object2;
            void var9_19;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElement(ELEMENT_ZFSCONFIG);
            document.appendChild(element2);
            for (Pool pool : zDataModel.getPools()) {
                Element object3 = document.createElement(ELEMENT_POOL);
                XMLDataModel.poolToXML(pool, zDataModel, object3);
                element2.appendChild(object3);
            }
            Element element3 = document.createElement(ELEMENT_AVAILABLE);
            element2.appendChild(element3);
            for (DiskDevice arrayList : zDataModel.getAvailableDisks()) {
                Element element4 = document.createElement("disk");
                XMLDataModel.diskToXML(arrayList, element4);
                element3.appendChild(element4);
            }
            Element element4 = document.createElement(ELEMENT_IMPORTABLE);
            element2.appendChild(element4);
            Object element5 = zDataModel.getImportablePools(new String[0]);
            int n = ((ImportablePool[])element5).length;
            boolean bl = false;
            while (var9_19 < n) {
                ImportablePool importablePool = element5[var9_19];
                object2 = document.createElement(ELEMENT_POOL);
                XMLDataModel.importablePoolToXML(importablePool, (Element)object2);
                element4.appendChild((Node)object2);
                ++var9_19;
            }
            element5 = document.createElement(ELEMENT_DEFAULTS);
            element2.appendChild((Node)element5);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(Arrays.asList(zDataModel.getValidPropertyNames(FileSystem.class)));
            hashSet.addAll(Arrays.asList(zDataModel.getValidPropertyNames(Volume.class)));
            hashSet.addAll(Arrays.asList(zDataModel.getValidPropertyNames(Snapshot.class)));
            for (String string : hashSet) {
                object2 = zDataModel.getPropertyDefault(string);
                if (object2 == null) continue;
                element = document.createElement(ELEMENT_PROPERTY);
                XMLDataModel.propertyToXML((Property)object2, element);
                element5.appendChild(element);
            }
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, FileSystem.class, Volume.class, Snapshot.class);
            for (Object object2 : arrayList) {
                element = document.createElement(ELEMENT_VALID);
                XMLDataModel.setAttribute(element, "type", ((Class)object2).getName());
                element2.appendChild(element);
                for (String string : zDataModel.getValidPropertyNames((Class<? extends Dataset>)object2)) {
                    Element element6 = document.createElement(ELEMENT_PROPERTY);
                    XMLDataModel.setAttribute(element6, "name", string);
                    element.appendChild(element6);
                }
            }
            Util.docToXML(document, outputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }

    private static void setAttribute(Element element, String string, Object object) {
        if (object != null) {
            element.setAttribute(string, object.toString());
        }
    }

    private static void setAttribute(Element element, String string, long l) {
        element.setAttribute(string, Long.toString(l));
    }

    private static class AttributeMap {
        private Class clazz;
        private String attr;

        public AttributeMap(Class clazz, String string) {
            this.clazz = clazz;
            this.attr = string;
        }

        public Class getBeanClass() {
            return this.clazz;
        }

        public String getAttribute() {
            return this.attr;
        }
    }

    private static class XPathElement {
        private String name;
        private int index;

        public XPathElement(String string, int n) {
            this.name = string;
            this.index = n;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

