/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.common.util;

import com.sun.zfs.common.util.CommandStatus;
import com.sun.zfs.common.util.ScriptElement;
import com.sun.zfs.common.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command
implements ScriptElement {
    private ProcessBuilder builder = new ProcessBuilder(new String[0]);
    private byte[] stdin;

    public Command(String ... stringArray) {
        this.setCommand(stringArray);
    }

    @Override
    public String toScriptString() {
        return Util.join(" ", this.getCommand());
    }

    public void setCommand(String ... stringArray) {
        this.builder.command(stringArray);
    }

    public void appendArgs(String ... stringArray) {
        Collections.addAll(this.getCommand(), stringArray);
    }

    public List<String> getCommand() {
        return this.builder.command();
    }

    public Map<String, String> getEnv() {
        return this.builder.environment();
    }

    public void setDirectory(File file) {
        this.builder.directory(file);
    }

    public File getDirectory() {
        return this.builder.directory();
    }

    public void setStdin(byte[] byArray) {
        this.stdin = byArray;
    }

    public void setStdin(String string) {
        this.setStdin(string.getBytes());
    }

    public byte[] getStdin() {
        return this.stdin;
    }

    public String getStdinAsString() {
        return this.stdin == null ? null : new String(this.stdin);
    }

    public void setMergeStreams(boolean bl) {
        this.builder.redirectErrorStream(bl);
    }

    public boolean getMergeStreams() {
        return this.builder.redirectErrorStream();
    }

    protected Process getProcess() throws SecurityException, IOException {
        return this.builder.start();
    }

    public CommandStatus exec() throws SecurityException, IOException {
        Process process = this.getProcess();
        byte[] byArray = this.getStdin();
        if (byArray != null) {
            OutputStream outputStream = process.getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
        }
        boolean bl = false;
        while (!bl) {
            try {
                process.waitFor();
                bl = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        byte[] byArray2 = Command.toByteArray(process.getInputStream());
        byte[] byArray3 = Command.toByteArray(process.getErrorStream());
        int n = process.exitValue();
        boolean bl2 = this.getSuccessful(byArray2, byArray3, n);
        return new CommandStatus(new ArrayList<String>(this.getCommand()), new HashMap<String, String>(this.getEnv()), this.getDirectory(), byArray, byArray2, byArray3, n, bl2);
    }

    public boolean getSuccessful(byte[] byArray, byte[] byArray2, int n) {
        return n == 0;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            return;
        }
        try {
            String string;
            String string2;
            Command command = new Command(stringArray);
            command.setStdin(Command.toByteArray(System.in));
            CommandStatus commandStatus = command.exec();
            System.out.println("Command: ");
            List<String> list = commandStatus.getCommand();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                System.out.printf("  %d: %s\n", i, list.get(i));
            }
            System.out.println();
            System.out.println("Exit code: " + commandStatus.getExitCode());
            System.out.println();
            String string3 = commandStatus.getStdinAsString().replaceAll("(?m)^", "Stdin: ");
            if (string3.length() != 0) {
                System.out.println(string3);
            }
            if ((string2 = commandStatus.getStdoutAsString().replaceAll("(?m)^", "Stdout: ")).length() != 0) {
                System.out.println(string2);
            }
            if ((string = commandStatus.getStderrAsString().replaceAll("(?m)^", "Stderr: ")).length() != 0) {
                System.out.println(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.available();
        int n3 = n2 != 0 ? 1024 : n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

