/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.common.util;

import com.sun.zfs.common.util.Command;
import com.sun.zfs.common.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class PrivilegedCommand
extends Command {
    private static final String EMBEDDED_SU = "/usr/lib/embedded_su";
    private static final String EMBEDDED_SU_ARG_CMD = "-c";
    private static final String PFEXEC = "/usr/bin/pfexec";
    private static final String PROTO_PAM_PROMPT_ECHO_OFF = "^PAM_PROMPT_ECHO_OFF(\\s+.*)?$";
    private static final String PROTO_PAM_PROMPT_ECHO_ON = "^PAM_PROMPT_ECHO_ON(\\s+.*)?$";
    private static final String PROTO_START_CONV = "^CONV\\s+(\\d+)(\\s+.*)?$";
    private static final String PROTO_END_CONV = "^.$";
    private static final String PROTO_INIT = ".";
    private static final String PROTO_SUCCESS = "^SUCCESS(\\s+.*)?$";
    private static final String PROTO_ERROR = "^ERROR(\\s+.*)?$";
    private String user;
    private String password;

    public PrivilegedCommand(String string, String string2, String ... stringArray) {
        super(stringArray);
        this.setUser(string);
        this.setPassword(string2);
    }

    protected Process getProcess() throws SecurityException, IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(this.getDirectory()).redirectErrorStream(this.getMergeStreams());
        processBuilder.environment().putAll(this.getEnv());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(PFEXEC);
        arrayList.addAll(this.getCommand());
        Collections.addAll(processBuilder.command(), EMBEDDED_SU, this.getUser(), EMBEDDED_SU_ARG_CMD, Util.toCommandLine(arrayList));
        Process process = processBuilder.start();
        InputStream inputStream = process.getInputStream();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(process.getOutputStream()));
        PrivilegedCommand.authenticate(this.getPassword(), inputStream, printWriter);
        return process;
    }

    private void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    private void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    private static void authenticate(String string, InputStream inputStream, PrintWriter printWriter) throws IOException {
        printWriter.println(PROTO_INIT);
        printWriter.flush();
        String string2 = PrivilegedCommand.readLine(inputStream);
        if (string2 == null) {
            throw new IOException("EOS after protocol initialization");
        }
        if (!string2.matches(PROTO_SUCCESS)) {
            String[] stringArray = Util.match(string2, PROTO_START_CONV);
            if (stringArray == null) {
                throw new IOException(String.format("expected: \"%s\", found: \"%s\"", PROTO_START_CONV, string2));
            }
            int n = Integer.parseInt(stringArray[1]);
            boolean bl = PrivilegedCommand.readMessages(n, inputStream);
            if (!bl) {
                throw new IOException(String.format("%s did not request password", EMBEDDED_SU));
            }
            PrivilegedCommand.sendPassword(string, inputStream, printWriter);
        }
    }

    private static void sendPassword(String string, InputStream inputStream, PrintWriter printWriter) throws IOException {
        printWriter.println(string);
        printWriter.flush();
        String string2 = PrivilegedCommand.readLine(inputStream);
        if (string2 == null) {
            throw new IOException("EOS after password entry");
        }
        if (!string2.matches(PROTO_SUCCESS)) {
            if (string2.matches(PROTO_ERROR)) {
                throw new IOException("/usr/lib/embedded_su: invalid password");
            }
            throw new IOException(String.format("unexpected response to password entry: \"%s\"", string2));
        }
    }

    private static boolean readMessages(int n, InputStream inputStream) throws IOException {
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            String string = PrivilegedCommand.readLine(inputStream);
            if (string == null) {
                throw new IOException("EOS reading conversation header");
            }
            if (string.matches(PROTO_PAM_PROMPT_ECHO_OFF) || string.matches(PROTO_PAM_PROMPT_ECHO_ON)) {
                bl = true;
            }
            PrivilegedCommand.readUntilEOC(inputStream);
        }
        return bl;
    }

    private static String readLine(InputStream inputStream) throws IOException {
        int n;
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new PipedInputStream(pipedOutputStream)));
        while ((n = inputStream.read()) != -1) {
            pipedOutputStream.write(n);
            if (n != 10) continue;
            break;
        }
        return bufferedReader.readLine();
    }

    private static void readUntilEOC(InputStream inputStream) throws IOException {
        String string;
        while ((string = PrivilegedCommand.readLine(inputStream)) != null) {
            if (!string.matches(PROTO_END_CONV)) continue;
            return;
        }
        throw new IOException("end of conversation (\"^.$\") not reached");
    }
}

