/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.common.util;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.management.services.authentication.UserRoleCredential;
import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.logging.ConsoleLogService;
import com.sun.web.ui.common.CCI18N;
import com.sun.zfs.common.model.DeviceStats;
import com.sun.zfs.common.model.DiskDevice;
import com.sun.zfs.common.model.PendingAggregateStorageDevice;
import com.sun.zfs.common.model.PendingStorageDevice;
import com.sun.zfs.common.model.Property;
import com.sun.zfs.common.model.SliceDevice;
import com.sun.zfs.common.model.SliceUsage;
import com.sun.zfs.common.model.ZFSCLIConstants;
import com.sun.zfs.common.util.ObjectViewer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger logger = ConsoleLogService.getConsoleLogger();
    public static final String DEFAULT_RESOURCE_BUNDLE = "com.sun.zfs.web.admin.zfsmodule.resources.Resources";
    public static final String DEFAULT_RESOURCE_BUNDLE_ID = "appBundle";
    private static String SHELL_META_RE = ".*(\\s|[\\\\#!$^&*()+=|\\~`{}\\[\\];`\"\\'<>?]).*";
    private static final String OPTION_GET_MESSAGES = "--resource";

    public static String getText(RequestContext requestContext, String string, Object ... objectArray) {
        CCI18N cCI18N = new CCI18N((ServletRequest)requestContext.getRequest(), (ServletResponse)requestContext.getResponse(), DEFAULT_RESOURCE_BUNDLE, DEFAULT_RESOURCE_BUNDLE_ID, null);
        return cCI18N.getMessage(string, objectArray);
    }

    public static String getText(String string, Object ... objectArray) {
        return Util.getText(RequestManager.getRequestContext(), string, objectArray);
    }

    public static String[] getDefaultUnits() {
        return new String[]{Util.getText("constants.bytes.short", new Object[0]), Util.getText("constants.kilobytes.short", new Object[0]), Util.getText("constants.megabytes.short", new Object[0]), Util.getText("constants.gigabytes.short", new Object[0]), Util.getText("constants.terabytes.short", new Object[0]), Util.getText("constants.petabytes.short", new Object[0]), Util.getText("constants.exabytes.short", new Object[0])};
    }

    public static DataSize getDataSize(long l, int n, String[] stringArray, String string) {
        double d;
        int n2;
        if (stringArray == null) {
            stringArray = Util.getDefaultUnits();
        }
        double d2 = 1.0;
        if (l < 0L) {
            l = -l;
            d2 = -1.0;
        }
        long l2 = 1L;
        if (string == null) {
            double d3 = n > 0 ? 0.5 : 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d3 /= 10.0;
            }
            d = l;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                d = (double)l / (double)l2;
                if (n2 != stringArray.length - 1 && !(d + d3 < 1024.0)) {
                    l2 <<= 10;
                    continue;
                }
                break;
            }
        } else {
            for (n2 = 0; n2 < stringArray.length - 1 && !stringArray[n2].equals(string); ++n2) {
                l2 <<= 10;
            }
            d = (double)l / (double)l2;
        }
        return new DataSize(d2 * d, n2);
    }

    public static String getHumanReadableDataSize(long l, int n, boolean bl, String[] stringArray, String string, boolean bl2, boolean bl3) {
        if (stringArray == null) {
            stringArray = Util.getDefaultUnits();
        }
        DataSize dataSize = Util.getDataSize(l, n, stringArray, string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl3 ? "#,##0" : "###0");
        char c = bl && dataSize.unitsIndex != 0 ? (char)'0' : '#';
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(c);
        }
        DecimalFormat decimalFormat = new DecimalFormat(stringBuffer.toString());
        String string2 = bl2 ? " " : "";
        return decimalFormat.format(dataSize.value) + string2 + stringArray[dataSize.unitsIndex];
    }

    public static long parseHumanReadableDataSize(String string, String[] stringArray, int n) {
        String[] stringArray2;
        if (stringArray == null) {
            stringArray = Util.getDefaultUnits();
        }
        if ((stringArray2 = Util.match(string, "^\\s*(\\d+(\\.\\d+)?)\\s*(\\S*)\\s*$")) == null) {
            throw new NumberFormatException(Util.getText("error.invalidsize", string));
        }
        double d = Double.parseDouble(stringArray2[1]);
        long l = 1L;
        if (stringArray2[3].length() == 0) {
            l <<= 10 * n;
        } else {
            String string2 = null;
            String string3 = stringArray2[3].toLowerCase();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].toLowerCase().startsWith(string3)) {
                    if (string2 != null) {
                        throw new NumberFormatException(Util.getText("error.ambiguousunits", string3, string2, stringArray[i]));
                    }
                    string2 = stringArray[i];
                }
                if (string2 != null) continue;
                l <<= 10;
            }
            if (string2 == null) {
                throw new NumberFormatException(Util.getText("error.invalidunits", string3));
            }
        }
        return (long)(d * (double)l);
    }

    public static String[] match(String string, String string2) throws PatternSyntaxException {
        Matcher matcher = Pattern.compile(string2).matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String[] stringArray = new String[matcher.groupCount() + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = matcher.group(i);
        }
        return stringArray;
    }

    public static String getGroup(String[] stringArray, int n, String string) {
        try {
            return stringArray[n];
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String join(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String join(String string, Collection collection) {
        return Util.join(string, collection.toArray());
    }

    public static <T> T[] subset(T[] TArray, int n, int n2) {
        Object[] objectArray;
        if (n < 0) {
            n += TArray.length;
        }
        if (n2 < 0) {
            n2 += TArray.length;
        }
        if (n >= 0 && n < TArray.length && n2 >= 0 && n2 < TArray.length && n2 >= n) {
            objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2 - n + 1);
            System.arraycopy(TArray, n, objectArray, 0, objectArray.length);
        } else {
            objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), 0);
        }
        return objectArray;
    }

    public static <T> T[] getUniqueElements(T[] TArray, T[] TArray2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        block0: for (T t : TArray) {
            for (T t2 : TArray2) {
                if (t.equals(t2)) continue block0;
            }
            arrayList.add(t);
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), arrayList.size());
        return arrayList.toArray(objectArray);
    }

    public static Object[] resizeArray(Object[] objectArray, int n) {
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), objectArray.length + n);
        int n2 = objectArray.length < objectArray2.length ? objectArray.length : objectArray2.length;
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    public static String toJavaScriptArray(Object ... objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            if (objectArray[i].getClass().isArray()) {
                stringBuffer.append(Util.toJavaScriptArray((Object[])objectArray[i]));
                continue;
            }
            stringBuffer.append("\"").append(objectArray[i] == null ? "null" : objectArray[i].toString()).append("\"");
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public static String normalizeFileName(String string) {
        String string2 = System.getProperty("file.separator");
        string = string.replaceAll(string2 + string2 + "+", string2);
        string = string.replaceFirst(string2 + "$", "");
        return string;
    }

    public static String[] grep(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (!string2.matches(string)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] grep(String string, Collection<String> collection) {
        return Util.grep(string, collection.toArray(new String[collection.size()]));
    }

    public static String getClassPackageName(String string) {
        return string.replaceFirst("\\.[^.]*$", "");
    }

    public static String getClassPackageName(Class clazz) {
        return Util.getClassPackageName(clazz.getName());
    }

    public static String getClassPackageName(Object object) {
        return Util.getClassPackageName(object.getClass());
    }

    public static String getClassBaseName(String string) {
        return string.replaceFirst(".*\\.", "");
    }

    public static String getClassBaseName(Class clazz) {
        return Util.getClassBaseName(clazz.getName());
    }

    public static String getClassBaseName(Object object) {
        return Util.getClassBaseName(object.getClass());
    }

    public static String getFileBaseName(String string) {
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        return string.substring(n + 1);
    }

    public static ObjectViewer getViewer(Class clazz) {
        String string = Util.getClassPackageName(Util.class) + ".";
        while (clazz != null) {
            try {
                String string2 = string + Util.getClassBaseName(clazz).replaceAll("\\$", "") + "Viewer";
                return (ObjectViewer)Class.forName(string2).newInstance();
            }
            catch (Throwable throwable) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static String getReadableValue(Object object) {
        return Util.getViewer(object.getClass()).getReadableValue(object);
    }

    public static String getReadableProperty(Property property, String string, String string2, String string3, String string4, String string5) {
        String string6 = Util.getReadableValue(property);
        switch (property.getLineage()) {
            case ZFS_PROP_LINEAGE_NOTINHERITABLE: {
                if (string == null) break;
                string6 = Util.getText(string, string6);
                break;
            }
            case ZFS_PROP_LINEAGE_DEFAULT: {
                if (string2 == null) break;
                string6 = Util.getText(string2, string6);
                break;
            }
            case ZFS_PROP_LINEAGE_LOCAL: {
                if (string3 == null) break;
                string6 = Util.getText(string3, string6);
                break;
            }
            case ZFS_PROP_LINEAGE_TEMPORARY: {
                if (string4 == null) break;
                string6 = Util.getText(string4, string6);
                break;
            }
            case ZFS_PROP_LINEAGE_INHERITED: {
                String string7;
                if (string5 == null || (string7 = property.getInheritedFrom()) == null) break;
                string6 = Util.getText(string5, string6, string7);
            }
        }
        return string6;
    }

    public static String getReadableProperty(Property property) {
        return Util.getReadableProperty(property, "field.property.notinheritable", "field.property.default", "field.property.setlocally", "field.property.temporary", "field.property.inherited");
    }

    public static <T> T[] toArray(T ... TArray) {
        return TArray;
    }

    public static <T> T[] toArray(Collection<T> collection, Class<? extends T> clazz) {
        return collection.toArray((Object[])Array.newInstance(clazz, collection.size()));
    }

    public static String[] getUserAndPassword(Subject subject) {
        String string = null;
        String string2 = null;
        try {
            UserRolePrincipal userRolePrincipal = subject.getPrincipals(UserRolePrincipal.class).iterator().next();
            UserRoleCredential userRoleCredential = subject.getPrivateCredentials(UserRoleCredential.class).iterator().next();
            string = userRolePrincipal.getUserName();
            string2 = userRoleCredential.getUserPassword();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return new String[]{string, string2};
    }

    public static String toCommandLine(String ... stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Util.toCommandLineArg(stringArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toCommandLine(Collection<String> collection) {
        return Util.toCommandLine(Util.toArray(collection, String.class));
    }

    public static boolean hasExistingUse(PendingStorageDevice ... pendingStorageDeviceArray) {
        for (PendingStorageDevice pendingStorageDevice : pendingStorageDeviceArray) {
            Object object;
            if (pendingStorageDevice instanceof DiskDevice) {
                object = ((DiskDevice)pendingStorageDevice).getAvailableSlices();
                if (object == null) continue;
                for (SliceDevice sliceDevice : object) {
                    SliceUsage sliceUsage = sliceDevice.getUsage();
                    if (sliceUsage == null) continue;
                    return true;
                }
                continue;
            }
            if (!(pendingStorageDevice instanceof SliceDevice ? (object = ((SliceDevice)pendingStorageDevice).getUsage()) != null : pendingStorageDevice instanceof PendingAggregateStorageDevice && Util.hasExistingUse(((PendingAggregateStorageDevice)pendingStorageDevice).getComponents()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidPoolName(String string) {
        boolean bl = string.matches("^[a-zA-Z][a-zA-Z_0-9._-]*$");
        if (bl) {
            for (String string2 : ZFSCLIConstants.INVALID_POOL_RE) {
                if (!string.matches(string2)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean isValidPoolId(String string) {
        return string.matches("^\\d+$");
    }

    public static boolean isValidDatasetName(String string) {
        return string.matches("^[a-zA-Z_0-9.:_-]*$");
    }

    public static long uint64StringToLong(String string) {
        return new BigInteger(string).longValue();
    }

    public static String longToUint64String(long l) {
        boolean bl;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l &= Long.MAX_VALUE;
        }
        BigInteger bigInteger = BigInteger.valueOf(l);
        if (bl) {
            bigInteger = bigInteger.setBit(63);
        }
        return bigInteger.toString();
    }

    public static boolean nullEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static String getFriendlyDeviceName(String string) {
        return string.replaceFirst("^\\s*/+dev/+r?dsk/+", "");
    }

    public static void docToXML(Document document, OutputStream outputStream) throws IOException, TransformerException {
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(dOMSource, streamResult);
    }

    public static String docToXML(Document document) throws IOException, TransformerException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Util.docToXML(document, byteArrayOutputStream);
        return ((Object)byteArrayOutputStream).toString();
    }

    public static StatusResource getStatusResource(DeviceStats deviceStats) {
        switch (deviceStats.getDeviceState()) {
            case VDEV_STATE_OFFLINE: {
                return StatusResource.down;
            }
            case VDEV_STATE_DEGRADED: {
                return StatusResource.minor;
            }
            case VDEV_STATE_HEALTHY: {
                if (deviceStats.getDeviceStatus() != DeviceStats.DeviceStatus.VDEV_AUX_NONE) break;
                return StatusResource.okay;
            }
        }
        return StatusResource.critical;
    }

    public static StatusResource getMostCritical(StatusResource statusResource, StatusResource statusResource2) {
        return statusResource.compareTo(statusResource2) > 0 ? statusResource : statusResource2;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray[0].equals(OPTION_GET_MESSAGES)) {
                String string = stringArray[1];
                String[] stringArray2 = new String[stringArray.length - 2];
                System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
                String string2 = Util.getText(string, false, stringArray2);
                if (string2 == null) {
                    System.err.println("Invalid resource: " + string);
                } else {
                    System.out.println(string2);
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("Usage: java " + Util.class.getName() + " " + OPTION_GET_MESSAGES + " <resource> [args...]");
        }
    }

    private static String toCommandLineArg(String string) {
        if (string.matches(SHELL_META_RE)) {
            string = string.replaceAll("\\\\", "\\\\\\\\");
            String string2 = "'";
            if (string.matches(".*'.*")) {
                if (string.matches(".*\".*")) {
                    string = string.replaceAll("'", "\\'");
                } else {
                    string2 = "\"";
                    string = string.replaceAll("\\$", "\\\\\\$");
                }
            }
            string = string2 + string + string2;
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusResource {
        okay,
        down,
        major,
        minor,
        critical;

    }

    public static class DataSize {
        public double value;
        public int unitsIndex;

        public DataSize(double d, int n) {
            this.value = d;
            this.unitsIndex = n;
        }
    }
}

