/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.misc.image;

import com.sun.zfs.web.admin.zfsmodule.misc.image.SingleColorImageKey;
import com.sun.zfs.web.admin.zfsmodule.util.ByteArrayCache;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleColorImageCache
extends ByteArrayCache<SingleColorImageKey> {
    public static final String FORMAT = "jpg";

    public SingleColorImageCache(int n) {
        super(n);
    }

    @Override
    public byte[] createObject(SingleColorImageKey singleColorImageKey) {
        RenderedImage renderedImage = SingleColorImageCache.createSingleColorImage(singleColorImageKey.getWidth(), singleColorImageKey.getHeight(), singleColorImageKey.getColor());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (!ImageIO.write(renderedImage, FORMAT, byteArrayOutputStream)) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected static RenderedImage createSingleColorImage(int n, int n2, Color color) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(color);
        graphics2D.clearRect(0, 0, n, n2);
        return bufferedImage;
    }
}

