/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.model;

import com.sun.zfs.common.model.DiskDevice;
import com.sun.zfs.common.model.PendingStorageDevice;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.SliceDevice;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.model.TableModel;
import java.util.Map;
import javax.servlet.ServletContext;

public class AvailableDevicesTableModel
extends TableModel {
    public static final String FIELD_VALUE = "Value";
    public static final String FIELD_NAME = "Name";
    public static final String FIELD_TYPE = "Type";
    public static final String FIELD_HIDABLE = "HidableRowIndicator";
    public static final String FIELD_USAGE = "Usage";
    public static final String VALUE_HIDABLE_TRUE = "1";
    public static final String VALUE_HIDABLE_FALSE = "0";
    private boolean firstRow = true;

    public AvailableDevicesTableModel(ServletContext servletContext, String string, long l, DiskDevice[] diskDeviceArray) {
        super(servletContext, string);
        DiskDevice[] diskDeviceArray2 = SimpleZDataModel.getDefaultModel().getAvailableDisks();
        if (diskDeviceArray != null) {
            diskDeviceArray2 = Util.getUniqueElements(diskDeviceArray2, diskDeviceArray);
        }
        for (DiskDevice diskDevice : diskDeviceArray2) {
            if (!diskDevice.getInUse() && diskDevice.getSize() >= l) {
                this.appendDisk(diskDevice);
            }
            for (SliceDevice sliceDevice : diskDevice.getAvailableSlices()) {
                if (sliceDevice.getSize() < l) continue;
                this.appendSlice(sliceDevice);
            }
        }
    }

    public AvailableDevicesTableModel(ServletContext servletContext, String string) {
        this(servletContext, string, 0L, null);
    }

    public AvailableDevicesTableModel(ServletContext servletContext, String string, long l) {
        this(servletContext, string, l, null);
    }

    public AvailableDevicesTableModel(ServletContext servletContext, String string, Map[] mapArray) {
        super(servletContext, string);
        this.setRowData(mapArray);
    }

    private void appendCommon(PendingStorageDevice pendingStorageDevice) {
        if (this.firstRow) {
            this.firstRow = false;
        } else {
            this.appendRow();
        }
        this.setValue(FIELD_VALUE, pendingStorageDevice);
        this.setValue("SizeField", pendingStorageDevice.getSize());
        this.setValue(FIELD_NAME, pendingStorageDevice.getFriendlyName());
    }

    private void appendDisk(DiskDevice diskDevice) {
        this.appendCommon(diskDevice);
        this.setValue(FIELD_TYPE, "table.availabledevices.header.type.disk");
        this.setValue(FIELD_HIDABLE, VALUE_HIDABLE_FALSE);
        this.setValue(FIELD_USAGE, diskDevice.getAvailableSlices());
    }

    private void appendSlice(SliceDevice sliceDevice) {
        this.appendCommon(sliceDevice);
        this.setValue(FIELD_TYPE, "table.availabledevices.header.type.slice");
        this.setValue(FIELD_HIDABLE, VALUE_HIDABLE_TRUE);
        this.setValue(FIELD_USAGE, new SliceDevice[]{sliceDevice});
    }
}

