/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.zfs.common.model.Dataset;
import com.sun.zfs.common.model.FileSystem;
import com.sun.zfs.common.model.MountPointProperty;
import com.sun.zfs.common.model.Pool;
import com.sun.zfs.common.model.PoolBean;
import com.sun.zfs.common.model.Property;
import com.sun.zfs.common.model.Snapshot;
import com.sun.zfs.common.model.Volume;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.tree.PoolTreeNode;
import com.sun.zfs.web.admin.zfsmodule.util.ModelConstants;
import java.util.Date;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetModelHelper<T extends Dataset>
implements ModelConstants {
    public void populateModel(DefaultModel defaultModel, T t) {
        String string;
        String string2;
        defaultModel.setValue("BaseNameField", (Object)t.getBaseName());
        defaultModel.setValue("FullNameField", (Object)t.getFullName());
        defaultModel.setValue("PoolField", (Object)t.getPoolName());
        String string3 = null;
        if (t instanceof FileSystem) {
            if (t instanceof Pool) {
                string2 = "Pool";
                string = "field.dataset.type.pool";
                string3 = PoolTreeNode.getImageResource((Pool)t);
            } else {
                string2 = "FileSystem";
                string = "field.dataset.type.filesystem";
                string3 = "tree.filesystem.image";
            }
            this.populateModelForFileSystem(defaultModel, (FileSystem)t);
        } else if (t instanceof Volume) {
            string2 = "Volume";
            string = "field.dataset.type.volume";
            string3 = "tree.volume.image";
        } else if (t instanceof Snapshot) {
            string2 = "Volume";
            string = "field.dataset.type.snapshot";
            string3 = "tree.snapshot.image";
        } else {
            string2 = "Unknown";
            string = "field.dataset.type.unknown";
        }
        defaultModel.setValue("DatasetTypeField", (Object)string2);
        defaultModel.setValue("TypeDescriptionField", (Object)string);
        defaultModel.setValue("IconField", (Object)string3);
        Date date = new Date(0L);
        String string4 = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n = 0;
        if (!(t instanceof Pool) || PoolBean.isActive((Pool)t)) {
            date = t.getDateCreated();
            string4 = t.getPrototype();
            l = t.getReservation();
            l2 = t.getQuota();
            l3 = t.getUsed();
            l4 = t.getAvailable();
            n = t.getPercentUsed();
        }
        defaultModel.setValue("DateCreatedField", (Object)date);
        defaultModel.setValue("FullCloneOfField", (Object)string4);
        defaultModel.setValue("ReservationField", l != 0L ? Long.valueOf(l) : "field.dataset.reservation.none");
        defaultModel.setValue("QuotaField", l2 != 0L ? Long.valueOf(l2) : "field.dataset.quota.none");
        defaultModel.setValue("UsedField", (Object)l3);
        defaultModel.setValue("AvailableField", (Object)l4);
        defaultModel.setValue("CapacityField", (Object)n);
        this.setProperty(defaultModel, (Dataset)t, "AclInheritField", "aclinherit");
        this.setProperty(defaultModel, (Dataset)t, "AclModeField", "aclmode");
        this.setProperty(defaultModel, (Dataset)t, "AtimeField", "atime");
        this.setProperty(defaultModel, (Dataset)t, "ChecksumField", "checksum");
        this.setProperty(defaultModel, (Dataset)t, "CompressionField", "compression");
        this.setProperty(defaultModel, (Dataset)t, "CompressRatioField", "compressratio");
        this.setProperty(defaultModel, (Dataset)t, "DevicesField", "devices");
        this.setProperty(defaultModel, (Dataset)t, "ExecField", "exec");
        this.setProperty(defaultModel, (Dataset)t, "ReadonlyField", "readonly");
        this.setProperty(defaultModel, (Dataset)t, "RecordSizeField", "recordsize");
        this.setProperty(defaultModel, (Dataset)t, "SetuidField", "setuid");
        this.setProperty(defaultModel, (Dataset)t, "ShareNFSField", "sharenfs");
        this.setProperty(defaultModel, (Dataset)t, "SnapDirField", "snapdir");
        this.setProperty(defaultModel, (Dataset)t, "VolBlockSizeField", "volblocksize");
        this.setProperty(defaultModel, (Dataset)t, "ZonedField", "zoned");
    }

    protected void setProperty(DefaultModel defaultModel, Dataset dataset, String string, String string2) {
        String string3 = null;
        try {
            Property property = dataset.getProperty(string2);
            string3 = Util.getReadableProperty(property);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        defaultModel.setValue(string, string3);
    }

    private void populateModelForFileSystem(DefaultModel defaultModel, FileSystem fileSystem) {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        if (!(fileSystem instanceof Pool) || PoolBean.isActive((Pool)fileSystem)) {
            Property property;
            try {
                property = fileSystem.getProperty("mountpoint");
            }
            catch (NoSuchElementException noSuchElementException) {
                property = new MountPointProperty("none", Property.Lineage.ZFS_PROP_LINEAGE_LOCAL);
            }
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            string = Util.getReadableProperty(property, string4, string5, string6, string7, string8);
            String string9 = (String)property.getValue();
            bl = fileSystem.getMounted();
            if (!"legacy".equals(string9)) {
                if (bl) {
                    string3 = "field.mountpoint.unmount";
                } else {
                    if (!"none".equals(string9)) {
                        string = Util.getText("field.mountpoint.notmounted", string);
                    }
                    string2 = "field.mountpoint.mount";
                }
            }
        }
        defaultModel.setValue("MountedField", (Object)bl);
        defaultModel.setValue("MountTextField", string2);
        defaultModel.setValue("UnmountTextField", string3);
        defaultModel.setValue("MountPointField", string);
        defaultModel.setValue("UseField", (Object)string);
    }
}

