/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.model;

import com.iplanet.jato.view.html.Option;
import com.sun.zfs.common.model.Dataset;
import com.sun.zfs.common.model.FileSystem;
import com.sun.zfs.common.model.Property;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.Volume;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.model.DatasetPropertyReviewTableModel;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.servlet.ServletContext;

public class DatasetPropertyTableModel
extends DatasetPropertyReviewTableModel {
    public static final String FIELD_PROPERTIES = "PropertiesField";
    public static final String FIELD_PROPERTY_INDEX = "PropertyIndex";
    public static final String FIELD_OPTIONS_LIST = "OptionsList";
    public static final String FIELD_VALUE = "Value";
    private String path;
    private String type;

    public DatasetPropertyTableModel(ServletContext servletContext, String string, String string2, String string3) {
        super(servletContext, string);
        this.path = string2;
        this.type = string3;
        this.setProperties(DatasetPropertyTableModel.getPropertiesFromDataset(string2, string3));
    }

    protected void addRow(Property property) {
        Property<E>[] propertyArray;
        if (property != null && !property.getReadOnly() && (propertyArray = property.getLegalInstances()) != null) {
            int n;
            Object object;
            boolean bl;
            super.addRow(property);
            ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
            Property[] propertyArray2 = new Property[propertyArray.length + 1];
            if (zDataModel.getPropertyDefault(this.path, property.getName()) != null) {
                propertyArray2[0] = zDataModel.getPropertyDefault(this.path, property.getName());
            }
            System.arraycopy(propertyArray, 0, propertyArray2, 1, propertyArray.length);
            int n2 = 0;
            Property.Lineage lineage = property.getLineage();
            boolean bl2 = bl = lineage == Property.Lineage.ZFS_PROP_LINEAGE_DEFAULT || lineage == Property.Lineage.ZFS_PROP_LINEAGE_INHERITED;
            if (!bl) {
                object = property.getValue();
                for (n = 1; n < propertyArray2.length; ++n) {
                    Object e = propertyArray[n - 1].getValue();
                    if (!object.equals(e)) continue;
                    n2 = n;
                }
            }
            this.setValue(FIELD_PROPERTIES, propertyArray2);
            this.setValue(FIELD_PROPERTY_INDEX, n2);
            this.setValue(FIELD_VALUE, n2);
            object = new Option[propertyArray2.length];
            for (n = 0; n < ((E)object).length; ++n) {
                if (propertyArray2[n] == null) continue;
                object[n] = new Option(Util.getReadableProperty(propertyArray2[n], "table.setproperties.property.notinheritable", "table.setproperties.property.default", "table.setproperties.property.setlocally", "table.setproperties.property.temporary", "table.setproperties.property.inherited"), Integer.toString(n));
            }
            this.setValue(FIELD_OPTIONS_LIST, object);
        }
    }

    private static Property[] getPropertiesFromDataset(String string, String string2) {
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        Dataset dataset = zDataModel.getDataset(string);
        if (dataset != null) {
            return dataset.getProperties();
        }
        Class clazz = null;
        if ("FileSystem".equals(string2) || "Pool".equals(string2)) {
            clazz = FileSystem.class;
        } else if ("Volume".equals(string2)) {
            clazz = Volume.class;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (clazz != null) {
            String[] stringArray;
            for (String string3 : stringArray = zDataModel.getValidPropertyNames(clazz)) {
                try {
                    Property property = zDataModel.getPropertyDefault(string, string3);
                    arrayList.add(property);
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        }
        return arrayList.toArray(new Property[arrayList.size()]);
    }
}

