/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.model;

import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTreeModel;
import com.sun.zfs.common.model.Dataset;
import com.sun.zfs.common.model.DatasetBean;
import com.sun.zfs.common.model.DiskVirtualDevice;
import com.sun.zfs.common.model.FileSystem;
import com.sun.zfs.common.model.FileVirtualDevice;
import com.sun.zfs.common.model.MirrorVirtualDevice;
import com.sun.zfs.common.model.Pool;
import com.sun.zfs.common.model.RAIDVirtualDevice;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.SliceVirtualDevice;
import com.sun.zfs.common.model.Snapshot;
import com.sun.zfs.common.model.VirtualDevice;
import com.sun.zfs.common.model.Volume;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.tree.DatasetTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.DeviceHierarchyTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.DiskVirtualDeviceTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.FileSystemSummaryTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.FileSystemTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.FileVirtualDeviceTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.MirrorVirtualDeviceTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.NoDevicesTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.PoolSummaryTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.PoolTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.RAIDVirtualDeviceTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.SliceVirtualDeviceTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.SnapshotSummaryTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.SnapshotTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.SummaryTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.VirtualDeviceGroupTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.VirtualDeviceTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.VolumeSummaryTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.VolumeTreeNode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class DeviceTreeModel
extends CCTreeModel {
    private static final NodeDescriptor[] DESCRIPTORS_SNAPSHOTS = new NodeDescriptor[]{new NodeDescriptor(0, Pool.class), new NodeDescriptor(-1, Snapshot.class), new NodeDescriptor(-2, FileSystem.class, Volume.class)};
    private static final NodeDescriptor[] DESCRIPTORS_FSORVOL = new NodeDescriptor[]{new NodeDescriptor(0, Pool.class), new NodeDescriptor(-1, FileSystem.class, Volume.class)};
    private Util.StatusResource mostCriticalPoolStatus = Util.StatusResource.okay;
    private int nPools = 0;
    private int nFileSystems = 0;
    private int nVolumes = 0;
    private int nSnapshots = 0;

    public void expandToNode(CCNavNodeInterface cCNavNodeInterface) {
        while (cCNavNodeInterface != null && !cCNavNodeInterface.isRoot()) {
            cCNavNodeInterface.setExpanded(true);
            cCNavNodeInterface = cCNavNodeInterface.getParent();
        }
    }

    public SummaryTreeNode getSummaryNode() {
        List list = this.getNodes();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                return (SummaryTreeNode)((Object)list.get(i));
            }
            catch (ClassCastException classCastException) {
                continue;
            }
        }
        return null;
    }

    public PoolSummaryTreeNode getPoolSummaryNode() {
        return (PoolSummaryTreeNode)this.getSummaryChildNode(PoolSummaryTreeNode.class);
    }

    public FileSystemSummaryTreeNode getFileSystemSummaryNode() {
        return (FileSystemSummaryTreeNode)this.getSummaryChildNode(FileSystemSummaryTreeNode.class);
    }

    public VolumeSummaryTreeNode getVolumeSummaryNode() {
        return (VolumeSummaryTreeNode)this.getSummaryChildNode(VolumeSummaryTreeNode.class);
    }

    public SnapshotSummaryTreeNode getSnapshotSummaryNode() {
        return (SnapshotSummaryTreeNode)this.getSummaryChildNode(SnapshotSummaryTreeNode.class);
    }

    public DeviceHierarchyTreeNode getDevicesNode() {
        List list = this.getNodes();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                return (DeviceHierarchyTreeNode)((Object)list.get(i));
            }
            catch (ClassCastException classCastException) {
                continue;
            }
        }
        return null;
    }

    public PoolTreeNode getPoolNode(String string) {
        List list = this.getDevicesNode().getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                PoolTreeNode poolTreeNode = (PoolTreeNode)((Object)list.get(i));
                if (string != null && !string.equals(poolTreeNode.getDataset().getPoolName())) continue;
                return poolTreeNode;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    public VirtualDeviceGroupTreeNode getVirtualDeviceGroupNode(String string) {
        if (string != null) {
            try {
                return (VirtualDeviceGroupTreeNode)this.getChildNode((CCNavNodeInterface)this.getPoolNode(string), VirtualDeviceGroupTreeNode.class);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public CCNavNodeInterface getVirtualDeviceNode(String string, String string2) {
        Long l = null;
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.getVirtualDeviceDescendentNode((CCNavNodeInterface)this.getVirtualDeviceGroupNode(string), l);
    }

    public CCNavNodeInterface getDatasetNode(String string) {
        if (DatasetBean.isPool(string)) {
            return this.getPoolNode(string);
        }
        String[] stringArray = DatasetBean.getDeviceNameComponents(string);
        if (DatasetBean.isSnapshot(string)) {
            return this.getSnapshotNode(stringArray);
        }
        return this.getFileSystemOrVolumeNode(stringArray);
    }

    public Util.StatusResource getMostCriticalPoolStatus() {
        return this.mostCriticalPoolStatus;
    }

    protected int getNPools() {
        return this.nPools;
    }

    protected int getNFileSystems() {
        return this.nFileSystems;
    }

    protected int getNVolumes() {
        return this.nVolumes;
    }

    protected int getNSnapshots() {
        return this.nSnapshots;
    }

    protected String getRootNodeName() {
        return null;
    }

    protected CCNavNodeInterface createDevicesNode(int n) {
        String string = this.getRootNodeName();
        DeviceHierarchyTreeNode deviceHierarchyTreeNode = string == null ? new DeviceHierarchyTreeNode(n) : new DeviceHierarchyTreeNode(n, string);
        deviceHierarchyTreeNode.setAcceptsChildren(true);
        deviceHierarchyTreeNode.setAsRoot();
        return deviceHierarchyTreeNode;
    }

    protected void init() {
        boolean bl;
        int n = 0;
        CCNavNodeInterface cCNavNodeInterface = this.createDevicesNode(n++);
        this.addNode(cCNavNodeInterface);
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        int n2 = n;
        n = this.appendPools(cCNavNodeInterface, zDataModel, n);
        boolean bl2 = bl = n != n2;
        if (!bl) {
            NoDevicesTreeNode noDevicesTreeNode = new NoDevicesTreeNode(n++, cCNavNodeInterface);
        }
    }

    protected boolean getTrimNoActionBranches() {
        return false;
    }

    protected String getPoolAction(Pool pool) {
        return null;
    }

    protected String getVdevsAction(String string) {
        return null;
    }

    protected String getVdevAction(VirtualDevice virtualDevice) {
        return null;
    }

    protected String getFileSystemAction(FileSystem fileSystem) {
        return null;
    }

    protected String getSnapshotAction(Snapshot snapshot) {
        return null;
    }

    protected String getVolumeAction(Volume volume) {
        return null;
    }

    protected CCNavNodeInterface getChildNode(CCNavNodeInterface cCNavNodeInterface, Class clazz) {
        List list = cCNavNodeInterface.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CCNavNodeInterface cCNavNodeInterface2 = (CCNavNodeInterface)list.get(i);
            if (!clazz.isInstance(cCNavNodeInterface2)) continue;
            return cCNavNodeInterface2;
        }
        return null;
    }

    private DatasetTreeNode getDatasetNode(CCNavNodeInterface cCNavNodeInterface, String[] stringArray, NodeDescriptor[] nodeDescriptorArray, int n) {
        int n2;
        Class[] classArray = null;
        for (int i = 0; i < nodeDescriptorArray.length; ++i) {
            n2 = nodeDescriptorArray[i].index;
            if (n2 < 0) {
                n2 += stringArray.length;
            }
            if (n2 != n) continue;
            classArray = nodeDescriptorArray[i].classes;
        }
        if (classArray == null) {
            classArray = new Class[]{FileSystem.class};
        }
        List list = cCNavNodeInterface.getChildren();
        int n3 = list.size();
        block3: for (n2 = 0; n2 < n3; ++n2) {
            try {
                DatasetTreeNode datasetTreeNode = (DatasetTreeNode)((Object)list.get(n2));
                Object t = datasetTreeNode.getDataset();
                for (int i = 0; i < classArray.length; ++i) {
                    if (!classArray[i].isInstance(t)) continue;
                    String string = t.getBaseName();
                    if (!stringArray[n].equals(string)) continue block3;
                    if (n == stringArray.length - 1) {
                        return datasetTreeNode;
                    }
                    if ((datasetTreeNode = this.getDatasetNode((CCNavNodeInterface)datasetTreeNode, stringArray, nodeDescriptorArray, n + 1)) == null) continue block3;
                    return datasetTreeNode;
                }
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    private CCNavNodeInterface getSnapshotNode(String[] stringArray) {
        return this.getDatasetNode((CCNavNodeInterface)this.getDevicesNode(), stringArray, DESCRIPTORS_SNAPSHOTS, 0);
    }

    private CCNavNodeInterface getFileSystemOrVolumeNode(String[] stringArray) {
        return this.getDatasetNode((CCNavNodeInterface)this.getDevicesNode(), stringArray, DESCRIPTORS_FSORVOL, 0);
    }

    protected CCNavNodeInterface getSummaryChildNode(Class clazz) {
        return this.getChildNode((CCNavNodeInterface)this.getSummaryNode(), clazz);
    }

    protected CCNavNodeInterface getVirtualDeviceDescendentNode(CCNavNodeInterface cCNavNodeInterface, Long l) {
        List list = cCNavNodeInterface.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            VirtualDeviceTreeNode virtualDeviceTreeNode;
            CCNavNodeInterface cCNavNodeInterface2 = (CCNavNodeInterface)list.get(i);
            try {
                virtualDeviceTreeNode = (VirtualDeviceTreeNode)cCNavNodeInterface2;
                if (l == null || l.longValue() == virtualDeviceTreeNode.getDevice().getIndex()) {
                    return cCNavNodeInterface2;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            virtualDeviceTreeNode = this.getVirtualDeviceDescendentNode(cCNavNodeInterface2, l);
            if (virtualDeviceTreeNode == null) continue;
            return virtualDeviceTreeNode;
        }
        return null;
    }

    protected int populateFileSystemNode(CCNavNodeInterface cCNavNodeInterface, ZDataModel zDataModel, FileSystem fileSystem, int n) {
        n = this.appendSnapshots(cCNavNodeInterface, zDataModel, fileSystem, n);
        n = this.appendFileSystems(cCNavNodeInterface, zDataModel, fileSystem, n);
        n = this.appendVolumes(cCNavNodeInterface, zDataModel, fileSystem, n);
        return n;
    }

    protected int appendPools(CCNavNodeInterface cCNavNodeInterface, ZDataModel zDataModel, int n) {
        Pool[] poolArray = zDataModel.getPools();
        Arrays.sort(poolArray, new Comparator<Pool>(){

            @Override
            public int compare(Pool pool, Pool pool2) {
                return pool.getPoolName().compareTo(pool2.getPoolName());
            }
        });
        for (Pool pool : poolArray) {
            this.mostCriticalPoolStatus = Util.getMostCritical(this.mostCriticalPoolStatus, Util.getStatusResource(pool));
            ++this.nPools;
            ++this.nFileSystems;
            PoolTreeNode<Pool> poolTreeNode = new PoolTreeNode<Pool>(n++, cCNavNodeInterface, pool);
            int n2 = n;
            String[] stringArray = this.getActions(this.getPoolAction(pool));
            poolTreeNode.setValue(stringArray[0]);
            poolTreeNode.setOnClick(stringArray[1]);
            n = this.appendVirtualDevices((CCNavNodeInterface)poolTreeNode, zDataModel, pool, n, true);
            n = this.populateFileSystemNode((CCNavNodeInterface)poolTreeNode, zDataModel, pool, n);
            poolTreeNode.setAcceptsChildren(n2 != n);
            if (stringArray[0] != null || n2 != n || !this.getTrimNoActionBranches()) continue;
            cCNavNodeInterface.removeChild(poolTreeNode);
            --n;
        }
        return n;
    }

    protected int appendVirtualDevices(CCNavNodeInterface object, ZDataModel zDataModel, VirtualDevice[] virtualDeviceArray, int n, boolean bl) {
        Object object2;
        if (virtualDeviceArray.length == 0) {
            return n;
        }
        Arrays.sort(virtualDeviceArray, new Comparator<VirtualDevice>(){

            @Override
            public int compare(VirtualDevice virtualDevice, VirtualDevice virtualDevice2) {
                long l = virtualDevice.getIndex() - virtualDevice2.getIndex();
                return l < 0L ? -1 : (l > 0L ? 1 : 0);
            }
        });
        String string = virtualDeviceArray[0].getPoolName();
        if (bl) {
            VirtualDeviceGroupTreeNode virtualDeviceGroupTreeNode = new VirtualDeviceGroupTreeNode(n++, (CCNavNodeInterface)object);
            object2 = this.getActions(this.getVdevsAction(string));
            virtualDeviceGroupTreeNode.setValue(object2[0]);
            virtualDeviceGroupTreeNode.setOnClick(object2[1]);
            if (virtualDeviceArray.length == 0) {
                virtualDeviceGroupTreeNode.setAcceptsChildren(false);
            }
            object = virtualDeviceGroupTreeNode;
        }
        for (int i = 0; i < virtualDeviceArray.length; ++i) {
            object2 = null;
            if (virtualDeviceArray[i] instanceof MirrorVirtualDevice) {
                object2 = new MirrorVirtualDeviceTreeNode(n++, (CCNavNodeInterface)object, (MirrorVirtualDevice)virtualDeviceArray[i]);
            } else if (virtualDeviceArray[i] instanceof RAIDVirtualDevice) {
                object2 = new RAIDVirtualDeviceTreeNode(n++, (CCNavNodeInterface)object, (RAIDVirtualDevice)virtualDeviceArray[i]);
            } else if (virtualDeviceArray[i] instanceof DiskVirtualDevice) {
                object2 = new DiskVirtualDeviceTreeNode(n++, (CCNavNodeInterface)object, (DiskVirtualDevice)virtualDeviceArray[i]);
            } else if (virtualDeviceArray[i] instanceof SliceVirtualDevice) {
                object2 = new SliceVirtualDeviceTreeNode(n++, (CCNavNodeInterface)object, (SliceVirtualDevice)virtualDeviceArray[i]);
            } else if (virtualDeviceArray[i] instanceof FileVirtualDevice) {
                object2 = new FileVirtualDeviceTreeNode(n++, (CCNavNodeInterface)object, (FileVirtualDevice)virtualDeviceArray[i]);
            }
            if (object2 == null) continue;
            String[] stringArray = this.getActions(this.getVdevAction(virtualDeviceArray[i]));
            object2.setValue(stringArray[0]);
            object2.setOnClick(stringArray[1]);
            VirtualDevice[] virtualDeviceArray2 = zDataModel.getVirtualDevices(string, virtualDeviceArray[i].getIndex());
            if (virtualDeviceArray2.length != 0) {
                n = this.appendVirtualDevices((CCNavNodeInterface)object2, zDataModel, virtualDeviceArray2, n, false);
                continue;
            }
            object2.setAcceptsChildren(false);
        }
        if (object instanceof VirtualDeviceGroupTreeNode) {
            ((VirtualDeviceGroupTreeNode)((Object)object)).setImageFromChildren();
        }
        return n;
    }

    protected int appendVirtualDevices(CCNavNodeInterface cCNavNodeInterface, ZDataModel zDataModel, Pool pool, int n, boolean bl) {
        VirtualDevice[] virtualDeviceArray = zDataModel.getVirtualDevices(pool.getPoolName());
        return this.appendVirtualDevices(cCNavNodeInterface, zDataModel, virtualDeviceArray, n, bl);
    }

    protected int appendFileSystems(CCNavNodeInterface cCNavNodeInterface, ZDataModel zDataModel, FileSystem fileSystem, int n) {
        FileSystem[] fileSystemArray = zDataModel.getFileSystems(fileSystem.getFullName());
        Arrays.sort(fileSystemArray, new Comparator<Dataset>(){

            @Override
            public int compare(Dataset dataset, Dataset dataset2) {
                return dataset.getFullName().compareTo(dataset2.getFullName());
            }
        });
        for (FileSystem fileSystem2 : fileSystemArray) {
            ++this.nFileSystems;
            FileSystemTreeNode<FileSystem> fileSystemTreeNode = new FileSystemTreeNode<FileSystem>(n++, cCNavNodeInterface, fileSystem2);
            String[] stringArray = this.getActions(this.getFileSystemAction(fileSystem2));
            fileSystemTreeNode.setValue(stringArray[0]);
            fileSystemTreeNode.setOnClick(stringArray[1]);
            int n2 = n;
            n = this.populateFileSystemNode((CCNavNodeInterface)fileSystemTreeNode, zDataModel, fileSystem2, n);
            fileSystemTreeNode.setAcceptsChildren(n2 != n);
            if (stringArray[0] != null || n2 != n || !this.getTrimNoActionBranches()) continue;
            cCNavNodeInterface.removeChild(fileSystemTreeNode);
            --n;
        }
        return n;
    }

    protected int appendSnapshots(CCNavNodeInterface cCNavNodeInterface, ZDataModel zDataModel, Dataset dataset, int n) {
        Snapshot[] snapshotArray = zDataModel.getSnapshots(dataset.getFullName());
        Arrays.sort(snapshotArray, new Comparator<Snapshot>(){

            @Override
            public int compare(Snapshot snapshot, Snapshot snapshot2) {
                return snapshot.getFullName().compareTo(snapshot2.getFullName());
            }
        });
        for (Snapshot snapshot : snapshotArray) {
            ++this.nSnapshots;
            SnapshotTreeNode snapshotTreeNode = new SnapshotTreeNode(n++, cCNavNodeInterface, snapshot);
            String[] stringArray = this.getActions(this.getSnapshotAction(snapshot));
            snapshotTreeNode.setValue(stringArray[0]);
            snapshotTreeNode.setOnClick(stringArray[1]);
            snapshotTreeNode.setAcceptsChildren(false);
            if (stringArray[0] != null || !this.getTrimNoActionBranches()) continue;
            cCNavNodeInterface.removeChild((CCNavNodeInterface)snapshotTreeNode);
            --n;
        }
        return n;
    }

    protected int appendVolumes(CCNavNodeInterface cCNavNodeInterface, ZDataModel zDataModel, FileSystem fileSystem, int n) {
        Volume[] volumeArray = zDataModel.getVolumes(fileSystem.getFullName());
        Arrays.sort(volumeArray, new Comparator<Dataset>(){

            @Override
            public int compare(Dataset dataset, Dataset dataset2) {
                return dataset.getFullName().compareTo(dataset2.getFullName());
            }
        });
        for (Volume volume : volumeArray) {
            ++this.nVolumes;
            VolumeTreeNode volumeTreeNode = new VolumeTreeNode(n++, cCNavNodeInterface, volume);
            String[] stringArray = this.getActions(this.getVolumeAction(volume));
            volumeTreeNode.setValue(stringArray[0]);
            volumeTreeNode.setOnClick(stringArray[1]);
            int n2 = n;
            n = this.appendSnapshots((CCNavNodeInterface)volumeTreeNode, zDataModel, volume, n);
            volumeTreeNode.setAcceptsChildren(n2 != n);
            if (stringArray[0] != null || n2 != n || !this.getTrimNoActionBranches()) continue;
            cCNavNodeInterface.removeChild((CCNavNodeInterface)volumeTreeNode);
            --n;
        }
        return n;
    }

    private String[] getActions(String string) {
        String[] stringArray = new String[2];
        String string2 = "javascript:";
        if (string != null) {
            if (string.startsWith(string2)) {
                stringArray[1] = string.replace(string2, "") + "; return false;";
                stringArray[0] = string2;
            } else {
                stringArray[0] = string;
            }
        }
        return stringArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeDescriptor {
        public int index;
        public Class<? extends Dataset>[] classes;

        public NodeDescriptor(int n, Class<? extends Dataset> ... classArray) {
            this.index = n;
            this.classes = classArray;
        }
    }
}

