/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.model;

import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.zfs.common.model.FileSystem;
import com.sun.zfs.common.model.Pool;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.Snapshot;
import com.sun.zfs.common.model.VirtualDevice;
import com.sun.zfs.common.model.Volume;
import com.sun.zfs.common.model.VolumeSnapshot;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.web.admin.zfsmodule.model.DeviceTreeModel;
import com.sun.zfs.web.admin.zfsmodule.tree.FileSystemSummaryTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.NoDevicesTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.PoolSummaryTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.SnapshotSummaryTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.SummaryTreeNode;
import com.sun.zfs.web.admin.zfsmodule.tree.VolumeSummaryTreeNode;

public class MainDeviceTreeModel
extends DeviceTreeModel {
    private static final String ACTION_BASE = "/zfs/zfsmodule/";
    private static final String ACTION_SYSTEM_SUMMARY = "/zfs/zfsmodule/Tasks.jsp";
    private static final String ACTION_POOL_SUMMARY = "/zfs/zfsmodule/PoolSummary.jsp";
    private static final String ACTION_FILESYSTEM_SUMMARY = "/zfs/zfsmodule/FileSystemSummary.jsp";
    private static final String ACTION_SNAPSHOT_SUMMARY = "/zfs/zfsmodule/SnapshotSummary.jsp";
    private static final String ACTION_VOLUME_SUMMARY = "/zfs/zfsmodule/VolumeSummary.jsp";
    private static final String ACTION_POOL_PROPS = "/zfs/zfsmodule/Pool.jsp";
    private static final String ACTION_POOL_VIRTUALDEVICES_PROPS = "/zfs/zfsmodule/PoolVirtualDevices.jsp";
    private static final String ACTION_FILESYSTEM_PROPS = "/zfs/zfsmodule/FileSystem.jsp";
    private static final String ACTION_FSSNAPSHOT_PROPS = "/zfs/zfsmodule/FileSystemSnapshot.jsp";
    private static final String ACTION_VOLUMESNAPSHOT_PROPS = "/zfs/zfsmodule/VolumeSnapshot.jsp";
    private static final String ACTION_VIRTUALDEVICE_PROPS = "/zfs/zfsmodule/VirtualDevice.jsp";
    private static final String ACTION_VOLUME_PROPS = "/zfs/zfsmodule/Volume.jsp";

    public MainDeviceTreeModel() {
        this.init();
    }

    protected void init() {
        int n = 0;
        SummaryTreeNode summaryTreeNode = new SummaryTreeNode(n++);
        summaryTreeNode.setAcceptsChildren(true);
        summaryTreeNode.setAsRoot();
        summaryTreeNode.setValue(ACTION_SYSTEM_SUMMARY);
        this.addNode((CCNavNodeInterface)summaryTreeNode);
        CCNavNodeInterface cCNavNodeInterface = this.createDevicesNode(n++);
        this.addNode(cCNavNodeInterface);
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        int n2 = n;
        n = this.appendPools(cCNavNodeInterface, zDataModel, n);
        boolean bl = n != n2;
        n = this.appendSummary(summaryTreeNode, n);
        if (!bl) {
            NoDevicesTreeNode noDevicesTreeNode = new NoDevicesTreeNode(n++, cCNavNodeInterface);
        }
    }

    protected String getPoolAction(Pool pool) {
        return "/zfs/zfsmodule/Pool.jsp?dataset=" + pool.getPoolName();
    }

    protected String getVdevsAction(String string) {
        return "/zfs/zfsmodule/PoolVirtualDevices.jsp?pool=" + string;
    }

    protected String getVdevAction(VirtualDevice virtualDevice) {
        return "/zfs/zfsmodule/VirtualDevice.jsp?pool=" + virtualDevice.getPoolName() + "&" + "vdev" + "=" + virtualDevice.getIndex();
    }

    protected String getFileSystemAction(FileSystem fileSystem) {
        return "/zfs/zfsmodule/FileSystem.jsp?dataset=" + fileSystem.getFullName();
    }

    protected String getSnapshotAction(Snapshot snapshot) {
        String string = snapshot instanceof VolumeSnapshot ? ACTION_VOLUMESNAPSHOT_PROPS : ACTION_FSSNAPSHOT_PROPS;
        return string + "?" + "dataset" + "=" + snapshot.getFullName();
    }

    protected String getVolumeAction(Volume volume) {
        return "/zfs/zfsmodule/Volume.jsp?dataset=" + volume.getFullName();
    }

    private int appendSummary(SummaryTreeNode summaryTreeNode, int n) {
        PoolSummaryTreeNode poolSummaryTreeNode = new PoolSummaryTreeNode(n++, (CCNavNodeInterface)summaryTreeNode, this.getNPools(), this.getMostCriticalPoolStatus());
        poolSummaryTreeNode.setAcceptsChildren(false);
        poolSummaryTreeNode.setValue(ACTION_POOL_SUMMARY);
        FileSystemSummaryTreeNode fileSystemSummaryTreeNode = new FileSystemSummaryTreeNode(n++, (CCNavNodeInterface)summaryTreeNode, this.getNFileSystems());
        fileSystemSummaryTreeNode.setAcceptsChildren(false);
        fileSystemSummaryTreeNode.setValue(ACTION_FILESYSTEM_SUMMARY);
        VolumeSummaryTreeNode volumeSummaryTreeNode = new VolumeSummaryTreeNode(n++, (CCNavNodeInterface)summaryTreeNode, this.getNVolumes());
        volumeSummaryTreeNode.setAcceptsChildren(false);
        volumeSummaryTreeNode.setValue(ACTION_VOLUME_SUMMARY);
        SnapshotSummaryTreeNode snapshotSummaryTreeNode = new SnapshotSummaryTreeNode(n++, (CCNavNodeInterface)summaryTreeNode, this.getNSnapshots());
        snapshotSummaryTreeNode.setAcceptsChildren(false);
        snapshotSummaryTreeNode.setValue(ACTION_SNAPSHOT_SUMMARY);
        return n;
    }
}

