/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.zfs.common.model.DeviceStats;
import com.sun.zfs.common.model.Pool;
import com.sun.zfs.common.model.PoolStats;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.model.DatasetModelHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolModelHelper
extends DatasetModelHelper<Pool> {
    @Override
    public void populateModel(DefaultModel defaultModel, Pool pool) {
        super.populateModel(defaultModel, pool);
        PoolModelHelper.populateModelForPoolStats(defaultModel, pool);
        defaultModel.setValue("TypeField", (Object)"table.virtualdevices.pool.type");
        defaultModel.setValue("DescriptionField", (Object)pool.getPoolName());
        defaultModel.setValue("IsAVirtualDeviceField", (Object)false);
        defaultModel.setValue("ReplacementSizeField", null);
    }

    public static void populateModelForDeviceStats(DefaultModel defaultModel, DeviceStats deviceStats) {
        String string = Util.getReadableValue((Object)deviceStats.getDeviceStatus());
        String string2 = Util.getReadableValue((Object)deviceStats.getDeviceState());
        String string3 = Util.getText("field.vdev.fullstatus", string2, string);
        defaultModel.setValue("DeviceStatusField", (Object)string);
        defaultModel.setValue("DeviceStateField", (Object)string2);
        defaultModel.setValue("FullDeviceStatusField", (Object)string3);
        defaultModel.setValue("SizeField", (Object)deviceStats.getSize());
        defaultModel.setValue("UsedField", (Object)deviceStats.getUsed());
        defaultModel.setValue("ReadBytesField", (Object)deviceStats.getReadBytes());
        defaultModel.setValue("WriteBytesField", (Object)deviceStats.getWriteBytes());
        defaultModel.setValue("ReadErrorsField", (Object)deviceStats.getReadErrors());
        defaultModel.setValue("WriteErrorsField", (Object)deviceStats.getWriteErrors());
        defaultModel.setValue("ChecksumErrorsField", (Object)deviceStats.getChecksumErrors());
        defaultModel.setValue("ReadOperationsField", (Object)deviceStats.getReadOperations());
        defaultModel.setValue("WriteOperationsField", (Object)deviceStats.getWriteOperations());
    }

    public static void populateModelForPoolStats(DefaultModel defaultModel, PoolStats poolStats) {
        PoolModelHelper.populateModelForDeviceStats(defaultModel, poolStats);
        defaultModel.setValue("PoolStatusField", (Object)Util.getReadableValue((Object)poolStats.getPoolStatus()));
        defaultModel.setValue("PoolStateField", (Object)Util.getReadableValue((Object)poolStats.getPoolState()));
    }
}

