/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.model;

import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.zfs.common.model.FileSystem;
import com.sun.zfs.common.model.FileSystemSnapshot;
import com.sun.zfs.common.model.Pool;
import com.sun.zfs.common.model.Snapshot;
import com.sun.zfs.common.model.VolumeSnapshot;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.web.admin.zfsmodule.model.DeviceTreeModel;

public class SnapshotTreeModel
extends DeviceTreeModel {
    private boolean showFileSystemSnapshots;
    private boolean showVolumeSnapshots;

    public SnapshotTreeModel(boolean bl, boolean bl2) {
        this.showFileSystemSnapshots = bl;
        this.showVolumeSnapshots = bl2;
        this.init();
    }

    protected String getRootNodeName() {
        return "tree.snapshots.root";
    }

    protected boolean getTrimNoActionBranches() {
        return true;
    }

    protected String getSnapshotAction(Snapshot snapshot) {
        if (this.showFileSystemSnapshots && snapshot instanceof FileSystemSnapshot || this.showVolumeSnapshots && snapshot instanceof VolumeSnapshot) {
            return String.format("javascript: window.opener.setSnapshot('%s'); window.close();", snapshot.getFullName());
        }
        return null;
    }

    protected int appendFileSystems(CCNavNodeInterface cCNavNodeInterface, ZDataModel zDataModel, FileSystem fileSystem, int n) {
        if (this.showFileSystemSnapshots) {
            return super.appendFileSystems(cCNavNodeInterface, zDataModel, fileSystem, n);
        }
        return n;
    }

    protected int appendVolumes(CCNavNodeInterface cCNavNodeInterface, ZDataModel zDataModel, FileSystem fileSystem, int n) {
        if (this.showVolumeSnapshots) {
            return super.appendVolumes(cCNavNodeInterface, zDataModel, fileSystem, n);
        }
        return n;
    }

    protected int appendVirtualDevices(CCNavNodeInterface cCNavNodeInterface, ZDataModel zDataModel, Pool pool, int n, boolean bl) {
        return n;
    }
}

