/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.zfs.common.model.DiskVirtualDevice;
import com.sun.zfs.common.model.FileVirtualDevice;
import com.sun.zfs.common.model.LeafVirtualDevice;
import com.sun.zfs.common.model.MirrorVirtualDevice;
import com.sun.zfs.common.model.RAIDVirtualDevice;
import com.sun.zfs.common.model.SliceVirtualDevice;
import com.sun.zfs.common.model.VirtualDevice;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.model.PoolModelHelper;
import com.sun.zfs.web.admin.zfsmodule.tree.VirtualDeviceTreeNode;
import com.sun.zfs.web.admin.zfsmodule.util.ModelConstants;
import com.sun.zfs.web.admin.zfsmodule.wizard.attachdevice.AttachDeviceWizard;
import com.sun.zfs.web.admin.zfsmodule.wizard.detachdevice.DetachDeviceWizard;
import com.sun.zfs.web.admin.zfsmodule.wizard.offlinedevice.OfflineDeviceWizard;
import com.sun.zfs.web.admin.zfsmodule.wizard.onlinedevice.OnlineDeviceWizard;
import com.sun.zfs.web.admin.zfsmodule.wizard.replacedevice.ReplaceDeviceIndexReqWizard;

public class VirtualDeviceModelHelper
implements ModelConstants {
    public void populateModel(DefaultModel defaultModel, final VirtualDevice virtualDevice, VirtualDevice[] virtualDeviceArray) {
        String string;
        String string2;
        if (virtualDevice instanceof RAIDVirtualDevice) {
            string2 = "table.virtualdevices.raid.type";
            string = this.getDescription(virtualDeviceArray, "table.virtualdevices.raid.description");
        } else if (virtualDevice instanceof MirrorVirtualDevice) {
            string2 = "table.virtualdevices.mirror.type";
            string = this.getDescription(virtualDeviceArray, "table.virtualdevices.mirror.description");
        } else if (virtualDevice instanceof DiskVirtualDevice) {
            string2 = "table.virtualdevices.disk.type";
            string = ((LeafVirtualDevice)virtualDevice).getCommandLineName();
        } else if (virtualDevice instanceof SliceVirtualDevice) {
            string2 = "table.virtualdevices.slice.type";
            string = ((LeafVirtualDevice)virtualDevice).getCommandLineName();
        } else if (virtualDevice instanceof FileVirtualDevice) {
            string2 = "table.virtualdevices.file.type";
            string = ((LeafVirtualDevice)virtualDevice).getName();
        } else {
            string2 = "table.virtualdevices.unknown.type";
            string = Util.getText("table.virtualdevices.unknown.description", new Object[0]);
        }
        defaultModel.setValue("IconField", (Object)VirtualDeviceTreeNode.getImageResource(virtualDevice));
        defaultModel.setValue("TypeField", (Object)string2);
        defaultModel.setValue("DescriptionField", (Object)string);
        defaultModel.setValue("IsAVirtualDeviceField", (Object)true);
        if (virtualDevice != null) {
            defaultModel.setValue("PoolField", (Object)virtualDevice.getPoolName());
            defaultModel.setValue("VirtualDeviceField", (Object)virtualDevice);
            defaultModel.setValue("VirtualDeviceIDField", (Object)virtualDevice.getIndex());
            PoolModelHelper.populateModelForDeviceStats(defaultModel, virtualDevice);
            Long l = virtualDevice.getSize();
            if (l == 0L) {
                l = null;
            }
            defaultModel.setValue("SizeField", (Object)l);
            Long l2 = virtualDevice.getUsed();
            if (l2 == 0L) {
                l2 = null;
            }
            defaultModel.setValue("UsedField", (Object)l2);
            defaultModel.setValue("ReplacementSizeField", virtualDevice instanceof LeafVirtualDevice ? Long.valueOf(((LeafVirtualDevice)virtualDevice).getReplacementSize()) : null);
            this.setEnableWizardField(defaultModel, "EnableReplaceDeviceWizard", new Runnable(){

                public void run() {
                    ReplaceDeviceIndexReqWizard.verifyCanBeReplaced(virtualDevice);
                }
            });
            this.setEnableWizardField(defaultModel, "EnableAttachDeviceWizard", new Runnable(){

                public void run() {
                    AttachDeviceWizard.verifyCanBeAttached(virtualDevice);
                }
            });
            this.setEnableWizardField(defaultModel, "EnableDetachDeviceWizard", new Runnable(){

                public void run() {
                    DetachDeviceWizard.verifyCanBeDetached(virtualDevice);
                }
            });
            this.setEnableWizardField(defaultModel, "EnableOnlineDeviceWizard", new Runnable(){

                public void run() {
                    OnlineDeviceWizard.verifyCanBeOnlined(virtualDevice);
                }
            });
            this.setEnableWizardField(defaultModel, "EnableOfflineDeviceWizard", new Runnable(){

                public void run() {
                    OfflineDeviceWizard.verifyCanBeOfflined(virtualDevice);
                }
            });
        }
    }

    private String getDescription(VirtualDevice[] virtualDeviceArray, String string) {
        return Util.getText(string, virtualDeviceArray.length);
    }

    private void setEnableWizardField(DefaultModel defaultModel, String string, Runnable runnable) {
        boolean bl = true;
        try {
            runnable.run();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        defaultModel.setValue(string, (Object)(bl ? "1" : ""));
    }
}

