/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.servlet.image;

import com.sun.zfs.web.admin.zfsmodule.misc.image.ColorPaletteManager;
import com.sun.zfs.web.admin.zfsmodule.misc.image.SingleColorImageCache;
import com.sun.zfs.web.admin.zfsmodule.misc.image.SingleColorImageKey;
import java.awt.Color;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SingleColorImageCreateServlet
extends HttpServlet {
    public static final String PARAM_WIDTH = "width";
    public static final String PARAM_HEIGHT = "height";
    public static final String PARAM_COLOR = "color";
    public static final int _WIDTH = 1;
    public static final int _HEIGHT = 1;
    public static final Color _COLOR = Color.white;
    public static final String CONTENT_TYPE = "image/jpeg";
    private static final int MAX_CACHE_SIZE = 250000;
    private static SingleColorImageCache cache = new SingleColorImageCache(250000);

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            Color color;
            int n;
            String string = httpServletRequest.getParameter(PARAM_WIDTH);
            int n2 = string == null ? 1 : Integer.parseInt(string);
            String string2 = httpServletRequest.getParameter(PARAM_HEIGHT);
            int n3 = n = string2 == null ? 1 : Integer.parseInt(string2);
            if (n2 < 0 || n < 0) {
                throw new IllegalArgumentException();
            }
            String string3 = httpServletRequest.getParameter(PARAM_COLOR);
            if (string3 == null) {
                color = _COLOR;
            } else {
                color = ColorPaletteManager.parseColor(string3);
                if (color == null) {
                    throw new IllegalArgumentException();
                }
            }
            byte[] byArray = (byte[])cache.get(new SingleColorImageKey(n2, n, color));
            if (byArray == null) {
                throw new IllegalArgumentException();
            }
            httpServletResponse.setContentType(CONTENT_TYPE);
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
        }
        catch (Exception exception) {
            httpServletResponse.sendError(400);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }
}

