/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.taglib;

import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.TypeConverter;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.taglib.ZDataSize;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class ZDataSizeTag
extends CCTagBase {
    public static final String UNITS_APPROPRIATE = "";
    public static final String UNITS_BYTES = "BYTES";
    public static final String UNITS_KB = "KB";
    public static final String UNITS_MB = "MB";
    public static final String UNITS_GB = "GB";
    public static final String UNITS_TB = "TB";
    public static final String UNITS_PB = "PB";
    public static final String UNITS_EB = "EB";
    public static final String ATTRIB_DEFAULT_VALUE = "defaultValue";
    public static final String ATTRIB_UNITS = "units";
    public static final String ATTRIB_PRECISION = "precision";
    public static final String ATTRIB_FORCE_PRECISION = "forcePrecision";
    public static final String ATTRIB_ABBREVIATE_UNITS = "abbreviateUnits";
    private static String _UNITS = "";
    private static int _PRECISION = 2;
    private static boolean _FORCE_PRECISION = false;
    private static boolean _ABBREVIATE_UNITS = true;

    protected String getHTMLStringInternal(Tag tag, PageContext pageContext, View view) throws JspException {
        String string;
        if (tag == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        this.checkChildType(view, ZDataSize.class);
        ZDataSize zDataSize = (ZDataSize)view;
        this.setParent(tag);
        this.setPageContext(pageContext);
        Object object = zDataSize.getValue();
        if (object == null) {
            object = this.getDefaultValue();
        }
        try {
            String string2;
            String[] stringArray;
            if (object == null) {
                throw new NumberFormatException();
            }
            long l = Long.parseLong(object.toString());
            String string3 = this.getUnits();
            int n = TypeConverter.asInt((Object)this.getPrecision());
            boolean bl = TypeConverter.asBoolean((Object)this.getForcePrecision());
            boolean bl2 = TypeConverter.asBoolean((Object)this.getAbbreviateUnits());
            if (bl2) {
                String[] stringArray2 = new String[7];
                stringArray2[0] = this.getMessage("constants.bytes.short");
                stringArray2[1] = this.getMessage("constants.kilobytes.short");
                stringArray2[2] = this.getMessage("constants.megabytes.short");
                stringArray2[3] = this.getMessage("constants.gigabytes.short");
                stringArray2[4] = this.getMessage("constants.terabytes.short");
                stringArray2[5] = this.getMessage("constants.petabytes.short");
                stringArray = stringArray2;
                stringArray2[6] = this.getMessage("constants.exabytes.short");
            } else {
                String[] stringArray3 = new String[7];
                stringArray3[0] = this.getMessage("constants.bytes.long");
                stringArray3[1] = this.getMessage("constants.kilobytes.long");
                stringArray3[2] = this.getMessage("constants.megabytes.long");
                stringArray3[3] = this.getMessage("constants.gigabytes.long");
                stringArray3[4] = this.getMessage("constants.terabytes.long");
                stringArray3[5] = this.getMessage("constants.petabytes.long");
                stringArray = stringArray3;
                stringArray3[6] = this.getMessage("constants.exabytes.long");
            }
            String[] stringArray4 = stringArray;
            try {
                int n2 = ZDataSizeTag.unitStringToIndex(string3);
                string2 = stringArray4[n2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = null;
            }
            string = Util.getHumanReadableDataSize(l, n, bl, stringArray4, string2, true, true);
        }
        catch (NumberFormatException numberFormatException) {
            string = object == null ? UNITS_APPROPRIATE : this.getMessage(object.toString());
        }
        string = HtmlUtil.escape((String)string);
        string = string.replace(" ", "&nbsp;");
        return string;
    }

    private static final int unitStringToIndex(String string) {
        String[] stringArray = new String[]{UNITS_BYTES, UNITS_KB, UNITS_MB, UNITS_GB, UNITS_TB, UNITS_PB, UNITS_EB};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public void setDefaultValue(String string) {
        this.setValue(ATTRIB_DEFAULT_VALUE, string);
    }

    public String getDefaultValue() {
        Object object = this.getValue(ATTRIB_DEFAULT_VALUE);
        return object == null ? null : object.toString();
    }

    public void setUnits(String string) {
        if (string != null && !UNITS_APPROPRIATE.equalsIgnoreCase(string) && ZDataSizeTag.unitStringToIndex(string) == -1) {
            CCDebug.trace1((String)("Invalid units specification: " + string));
        }
        this.setValue(ATTRIB_UNITS, string);
    }

    public String getUnits() {
        Object object = this.getValue(ATTRIB_UNITS);
        return object == null ? _UNITS : object.toString();
    }

    public void setPrecision(String string) {
        int n = _PRECISION;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
                if (n < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                CCDebug.trace1((String)("Invalid precision: " + string));
            }
        }
        this.setValue(ATTRIB_PRECISION, Integer.toString(n));
    }

    public String getPrecision() {
        Object object = this.getValue(ATTRIB_PRECISION);
        return object == null ? Integer.toString(_PRECISION) : object.toString();
    }

    public void setForcePrecision(String string) {
        boolean bl = _FORCE_PRECISION;
        if (string != null) {
            bl = Boolean.parseBoolean(string);
        }
        this.setValue(ATTRIB_FORCE_PRECISION, Boolean.toString(bl));
    }

    public String getForcePrecision() {
        Object object = this.getValue(ATTRIB_FORCE_PRECISION);
        return object == null ? Boolean.toString(_FORCE_PRECISION) : object.toString();
    }

    public void setAbbreviateUnits(String string) {
        boolean bl = _ABBREVIATE_UNITS;
        if (string != null) {
            bl = Boolean.parseBoolean(string);
        }
        this.setValue(ATTRIB_ABBREVIATE_UNITS, Boolean.toString(bl));
    }

    public String getAbbreviateUnits() {
        Object object = this.getValue(ATTRIB_ABBREVIATE_UNITS);
        return object == null ? Boolean.toString(_ABBREVIATE_UNITS) : object.toString();
    }
}

