/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.util;

import com.sun.zfs.web.admin.zfsmodule.util.CacheElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectCache<K, V> {
    private int maxTotalSize;
    private HashMap<K, CacheElement<K, V>> cache = new HashMap();
    private int size = 0;

    public ObjectCache(int n) {
        this.maxTotalSize = n;
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxTotalSize() {
        return this.maxTotalSize;
    }

    public synchronized V get(K k) {
        CacheElement<K, V> cacheElement = this.cache.get(k);
        if (cacheElement == null) {
            V v = this.createObject(k);
            if (v == null) {
                return null;
            }
            int n = this.getSize(v);
            cacheElement = new CacheElement<K, V>(k, v, n);
            if (n <= this.maxTotalSize) {
                if (this.size + n > this.maxTotalSize) {
                    TreeSet<CacheElement<K, V>> treeSet = new TreeSet<CacheElement<K, V>>(this.cache.values());
                    Iterator<CacheElement<K, V>> iterator = treeSet.iterator();
                    while (iterator.hasNext() && this.size + n > this.maxTotalSize) {
                        cacheElement = iterator.next();
                        this.cache.remove(cacheElement.getKey());
                        this.size -= cacheElement.getSize();
                    }
                }
                this.cache.put(k, cacheElement);
                this.size += n;
            }
        }
        cacheElement.updateAccessTime();
        return cacheElement.getValue();
    }

    public abstract V createObject(K var1);

    public abstract int getSize(V var1);
}

