/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.view;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.zfs.web.admin.zfsmodule.model.PoolTableModel;
import com.sun.zfs.web.admin.zfsmodule.view.AppViewBean;
import com.sun.zfs.web.admin.zfsmodule.view.PoolTableTiledView;
import com.sun.zfs.web.admin.zfsmodule.view.TableTiledView;
import com.sun.zfs.web.admin.zfsmodule.view.TableViewHelper;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardViewHelper;
import com.sun.zfs.web.admin.zfsmodule.wizard.createpool.CreatePoolWizardViewHelper;
import com.sun.zfs.web.admin.zfsmodule.wizard.destroydataset.DestroyDatasetWizardViewHelper;
import com.sun.zfs.web.admin.zfsmodule.wizard.exportpool.ExportPoolWizardViewHelper;
import com.sun.zfs.web.admin.zfsmodule.wizard.importpool.ImportPoolWizardViewHelper;
import java.util.ArrayList;

public class PoolTableViewHelper
extends TableViewHelper {
    public static final String CHILD_POOL_TABLE = "PoolTable";
    public static final String CHILD_POOL_TABLE_TILED_VIEW = "PoolTableTiledView";
    public static final String CHILD_DESCRIPTION = "PoolDescription";
    private static final String TABLE_MODEL_XML = "/jsp/zfsmodule/PoolTable.xml";
    public static final String CHILD_DESTROY_WIZARD = "DestroyPoolWizard";
    public static final String CHILD_DESTROY_HREF = "DestroyPoolHref";
    private ImportPoolWizardViewHelper importHelper;
    private CreatePoolWizardViewHelper createHelper;
    private DestroyDatasetWizardViewHelper destroyHelper;
    private ExportPoolWizardViewHelper exportHelper;
    private WizardViewHelper[] helpers;
    private String pool;
    private String path;

    public PoolTableViewHelper(ContainerViewBase containerViewBase) {
        super(containerViewBase);
        this.importHelper = new ImportPoolWizardViewHelper(containerViewBase);
        this.createHelper = new CreatePoolWizardViewHelper(containerViewBase);
        this.destroyHelper = new DestroyDatasetWizardViewHelper(containerViewBase, CHILD_DESTROY_WIZARD, CHILD_DESTROY_HREF);
        this.exportHelper = new ExportPoolWizardViewHelper(containerViewBase, true);
        this.helpers = new WizardViewHelper[]{this.importHelper, this.createHelper, this.destroyHelper, this.exportHelper};
    }

    public String getTableName() {
        return CHILD_POOL_TABLE;
    }

    public String getTableTiledViewName() {
        return CHILD_POOL_TABLE_TILED_VIEW;
    }

    public String getDescriptionName() {
        return CHILD_DESCRIPTION;
    }

    public String getDescriptionText() {
        return "view.pools.instructions";
    }

    protected WizardViewHelper[] getWizardViewHelpers() {
        return this.helpers;
    }

    public String[] getDynamicButtonNames() {
        return new String[]{this.destroyHelper.getWizardName(), this.exportHelper.getWizardName() + ":1:1"};
    }

    protected CCActionTableModel createTableModel() {
        PoolTableModel poolTableModel = new PoolTableModel(RequestManager.getRequestContext().getServletContext(), TABLE_MODEL_XML);
        poolTableModel.registerChildren(this.getView());
        return poolTableModel;
    }

    protected TableTiledView createTableTiledView(View view, CCActionTableModel cCActionTableModel, String string) {
        return new PoolTableTiledView(view, cCActionTableModel, string);
    }

    public void populateDestroyWizardPageModel() throws ModelControlException {
        String[] stringArray = this.getSelectedPools();
        if (stringArray.length > 0) {
            this.destroyHelper.populateWizardPageModel(stringArray);
        }
    }

    public void populateExportWizardPageModel() throws ModelControlException {
        String[] stringArray = this.getSelectedPools();
        if (stringArray.length > 0) {
            this.exportHelper.populateWizardPageModel(stringArray[0]);
        }
    }

    private String[] getSelectedPools() throws ModelControlException {
        AppViewBean appViewBean = this.getParentAppViewBean();
        RequestContext requestContext = appViewBean.getRequestContext();
        CCActionTableModelInterface cCActionTableModelInterface = this.getTableModel();
        Integer[] integerArray = cCActionTableModelInterface.getSelectedRows();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (integerArray != null) {
            Integer[] integerArray2 = integerArray;
            int n = integerArray2.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray2[i];
                cCActionTableModelInterface.setRowIndex(n2);
                String string = (String)cCActionTableModelInterface.getValue("FullNameField");
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

