/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.appendpool;

import com.iplanet.jato.model.ModelControlException;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.zfs.common.model.DiskDevice;
import com.sun.zfs.common.model.PendingStorageDevice;
import com.sun.zfs.common.model.SliceDevice;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.view.AvailableDevicesTableViewHelper;
import com.sun.zfs.web.admin.zfsmodule.wizard.appendpool.AppendPoolDevicesPageView;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageStatus;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageView;

public class AppendPoolDevicesPage
extends WizardPage {
    public Class getPageClass() {
        return AppendPoolDevicesPageView.class;
    }

    public String[] getStepHelp(WizardPageModel wizardPageModel) {
        return new String[]{"wizard.appendpooldevices.help"};
    }

    public String getStepInstruction(WizardPageModel wizardPageModel) {
        return "wizard.appendpooldevices.instructions";
    }

    public String getStepTitle(WizardPageModel wizardPageModel) {
        return "wizard.appendpooldevices.title";
    }

    public void reset(WizardPageModel wizardPageModel) {
        wizardPageModel.setValue("TableCache", null);
    }

    public void stepCompleted(WizardPageView wizardPageView, WizardPageModel wizardPageModel, WizardPageStatus wizardPageStatus) {
        AvailableDevicesTableViewHelper availableDevicesTableViewHelper = ((AppendPoolDevicesPageView)wizardPageView).getTableViewHelper();
        Integer[] integerArray = null;
        CCActionTableModelInterface cCActionTableModelInterface = null;
        try {
            cCActionTableModelInterface = availableDevicesTableViewHelper.getTableModel();
            integerArray = cCActionTableModelInterface.getSelectedRows();
        }
        catch (ModelControlException modelControlException) {
            // empty catch block
        }
        if (integerArray == null || integerArray.length == 0) {
            this.notifyEmptySelection(wizardPageView, wizardPageModel, wizardPageStatus);
            if (wizardPageStatus.isError()) {
                return;
            }
        }
        PendingStorageDevice[] pendingStorageDeviceArray = new PendingStorageDevice[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            cCActionTableModelInterface.setRowIndex(integerArray[i].intValue());
            pendingStorageDeviceArray[i] = (PendingStorageDevice)cCActionTableModelInterface.getValue("Value");
        }
        this.checkForOverlap(wizardPageView, wizardPageModel, wizardPageStatus, pendingStorageDeviceArray);
        if (wizardPageStatus.isError()) {
            return;
        }
        if (!wizardPageStatus.getPreviousMessageConfirmed() && Util.hasExistingUse(pendingStorageDeviceArray)) {
            wizardPageStatus.addConfirmMessage(Util.getText("wizard.appendpooldevices.error.disksinuse", new Object[0]));
        }
        this.setDevicesInModel(wizardPageView, wizardPageModel, wizardPageStatus, pendingStorageDeviceArray);
    }

    public void notifyEmptySelection(WizardPageView wizardPageView, WizardPageModel wizardPageModel, WizardPageStatus wizardPageStatus) {
        wizardPageStatus.setErrorMessage("wizard.appendpooldevices.error.nodevicesselected");
    }

    public void setDevicesInModel(WizardPageView wizardPageView, WizardPageModel wizardPageModel, WizardPageStatus wizardPageStatus, PendingStorageDevice[] pendingStorageDeviceArray) {
        if (wizardPageStatus.isPerfect()) {
            wizardPageModel.setValue("StorageDevices", pendingStorageDeviceArray);
        }
    }

    private void checkForOverlap(WizardPageView wizardPageView, WizardPageModel wizardPageModel, WizardPageStatus wizardPageStatus, PendingStorageDevice[] pendingStorageDeviceArray) {
        for (int i = 0; i < pendingStorageDeviceArray.length; ++i) {
            if (!(pendingStorageDeviceArray[i] instanceof SliceDevice)) continue;
            SliceDevice sliceDevice = (SliceDevice)pendingStorageDeviceArray[i];
            long l = sliceDevice.getStart();
            long l2 = l + sliceDevice.getStart() - 1L;
            String string = sliceDevice.getDisk().getName();
            for (int j = 0; j < pendingStorageDeviceArray.length; ++j) {
                String string2;
                PendingStorageDevice pendingStorageDevice;
                if (i == j) continue;
                if (pendingStorageDeviceArray[j] instanceof SliceDevice) {
                    boolean bl;
                    pendingStorageDevice = (SliceDevice)pendingStorageDeviceArray[j];
                    string2 = pendingStorageDevice.getDisk().getName();
                    if (!string.equals(string2)) continue;
                    long l3 = pendingStorageDevice.getStart();
                    long l4 = l3 + pendingStorageDevice.getStart() - 1L;
                    boolean bl2 = bl = l3 <= l2 && l <= l4;
                    if (!bl) continue;
                    wizardPageStatus.setErrorMessage(Util.getText("wizard.appendpooldevices.error.slicesoverlap", sliceDevice.getFriendlyName(), pendingStorageDevice.getFriendlyName()));
                    return;
                }
                if (!(pendingStorageDeviceArray[j] instanceof DiskDevice) || !string.equals(string2 = (pendingStorageDevice = (DiskDevice)pendingStorageDeviceArray[j]).getName())) continue;
                wizardPageStatus.setErrorMessage(Util.getText("wizard.appendpooldevices.error.diskandslice", sliceDevice.getFriendlyName(), pendingStorageDevice.getFriendlyName()));
                return;
            }
        }
    }
}

