/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.appendpool;

import com.sun.zfs.common.model.PendingAggregateStorageDeviceBean;
import com.sun.zfs.common.model.PendingMirrorBean;
import com.sun.zfs.common.model.PendingStorageDevice;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.wizard.appendpool.AppendPoolDevicesPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.appendpool.AppendPoolDevicesPageView;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageStatus;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageView;
import java.util.ArrayList;
import java.util.Collections;

public class AppendPoolMirrorDevicesPage
extends AppendPoolDevicesPage {
    private static final double SIZE_DISCREPANCY_THRESHOLD = 0.1;

    public Class getPageClass() {
        return AppendPoolDevicesPageView.class;
    }

    public String[] getStepHelp(WizardPageModel wizardPageModel) {
        return new String[]{"wizard.appendpoolmirrordevices.help"};
    }

    public String getStepInstruction(WizardPageModel wizardPageModel) {
        return "wizard.appendpoolmirrordevices.instructions";
    }

    public String getStepTitle(WizardPageModel wizardPageModel) {
        return "wizard.appendpoolmirrordevices.title";
    }

    public void notifyEmptySelection(WizardPageView wizardPageView, WizardPageModel wizardPageModel, WizardPageStatus wizardPageStatus) {
        wizardPageStatus.setErrorMessage("wizard.appendpoolmirrordevices.error.nodevicesselected");
    }

    public void setDevicesInModel(WizardPageView wizardPageView, WizardPageModel wizardPageModel, WizardPageStatus wizardPageStatus, PendingStorageDevice[] pendingStorageDeviceArray) {
        PendingAggregateStorageDeviceBean pendingAggregateStorageDeviceBean = this.createAggregateStorageDevice();
        if (pendingStorageDeviceArray.length < 2) {
            this.notifyOnlyOneDeviceInMirror(wizardPageView, wizardPageModel, wizardPageStatus);
        } else {
            this.checkForWastedSpace(wizardPageView, wizardPageModel, wizardPageStatus, pendingStorageDeviceArray, null);
        }
        if (wizardPageStatus.isPerfect()) {
            for (PendingStorageDevice pendingStorageDevice : pendingStorageDeviceArray) {
                pendingAggregateStorageDeviceBean.addComponent(pendingStorageDevice);
            }
        }
        super.setDevicesInModel(wizardPageView, wizardPageModel, wizardPageStatus, new PendingStorageDevice[]{pendingAggregateStorageDeviceBean});
    }

    public PendingAggregateStorageDeviceBean createAggregateStorageDevice() {
        return new PendingMirrorBean();
    }

    public void notifyOnlyOneDeviceInMirror(WizardPageView wizardPageView, WizardPageModel wizardPageModel, WizardPageStatus wizardPageStatus) {
        wizardPageStatus.setErrorMessage("wizard.appendpoolmirrordevices.error.onlyonedevice");
    }

    public void notifyWastedSpace(WizardPageView wizardPageView, WizardPageModel wizardPageModel, WizardPageStatus wizardPageStatus, String string, long l) {
        wizardPageStatus.addConfirmMessage(Util.getText("wizard.appendpoolmirrordevices.error.sizediscrepancy", string, l));
    }

    public void checkForWastedSpace(WizardPageView wizardPageView, WizardPageModel wizardPageModel, WizardPageStatus wizardPageStatus, PendingStorageDevice[] pendingStorageDeviceArray, PendingStorageDevice pendingStorageDevice) {
        if (!wizardPageStatus.getPreviousMessageConfirmed()) {
            long l;
            double d;
            PendingStorageDevice pendingStorageDevice2 = null;
            PendingStorageDevice pendingStorageDevice3 = null;
            long l2 = -1L;
            long l3 = -1L;
            ArrayList<PendingStorageDevice> arrayList = new ArrayList<PendingStorageDevice>();
            Collections.addAll(arrayList, pendingStorageDeviceArray);
            if (pendingStorageDevice != null) {
                arrayList.add(pendingStorageDevice);
            }
            for (PendingStorageDevice pendingStorageDevice4 : arrayList) {
                long l4 = pendingStorageDevice4.getSize();
                if (l2 == -1L || l4 < l2) {
                    pendingStorageDevice2 = pendingStorageDevice4;
                    l2 = l4;
                }
                if (l3 != -1L && l4 <= l3) continue;
                pendingStorageDevice3 = pendingStorageDevice4;
                l3 = l4;
            }
            if ((pendingStorageDevice == null || pendingStorageDevice == pendingStorageDevice2 || pendingStorageDevice == pendingStorageDevice3) && (d = (double)(l = l3 - l2) / (double)l3) >= 0.1) {
                String string = Util.getHumanReadableDataSize(l, 2, false, null, null, true, true);
                long l5 = Math.round(d * 100.0);
                this.notifyWastedSpace(wizardPageView, wizardPageModel, wizardPageStatus, string, l5);
            }
        }
    }
}

