/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.appendpool;

import com.sun.zfs.common.model.PendingAggregateStorageDevice;
import com.sun.zfs.common.model.PendingAggregateStorageDeviceBean;
import com.sun.zfs.common.model.PendingMirror;
import com.sun.zfs.common.model.PendingRAID;
import com.sun.zfs.common.model.PendingStorageDevice;
import com.sun.zfs.common.util.CommandComment;
import com.sun.zfs.common.util.PrivilegedCommand;
import com.sun.zfs.common.util.ScriptElement;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendPoolWizardPageModel
extends WizardPageModel {
    public AppendPoolWizardPageModel() {
        this(null);
    }

    public AppendPoolWizardPageModel(String string) {
        super(string);
    }

    @Override
    public ScriptElement[] getScript() {
        String string = (String)this.getValue("PoolField");
        PendingStorageDevice[] pendingStorageDeviceArray = (PendingStorageDevice[])this.getValue("StorageDevices");
        if (string == null || pendingStorageDeviceArray == null || pendingStorageDeviceArray.length == 0) {
            return super.getIncompleteDataScript();
        }
        return AppendPoolWizardPageModel.getAddDeviceCommands(this.getUser(), this.getPassword(), string, pendingStorageDeviceArray);
    }

    @Override
    public String[][] getRefreshParams() {
        String string = (String)this.getValue("PoolField");
        if (string != null) {
            return new String[][]{{"view", "vdevgroup"}, {"pool", string}};
        }
        return super.getRefreshParams();
    }

    public void setAddDevicesStage(int n) {
        PendingAggregateStorageDeviceBean pendingAggregateStorageDeviceBean;
        PendingStorageDevice[] pendingStorageDeviceArray;
        PendingStorageDevice[] pendingStorageDeviceArray2 = (PendingStorageDevice[])this.getValue("StorageDevices");
        if (n == 0) {
            pendingStorageDeviceArray2 = new PendingStorageDevice[]{};
        } else if (pendingStorageDeviceArray2 != null && n < (pendingStorageDeviceArray = (pendingAggregateStorageDeviceBean = (PendingAggregateStorageDeviceBean)pendingStorageDeviceArray2[0]).getComponents()).length) {
            PendingStorageDevice[] pendingStorageDeviceArray3 = new PendingStorageDevice[n];
            System.arraycopy(pendingStorageDeviceArray, 0, pendingStorageDeviceArray3, 0, n);
            pendingAggregateStorageDeviceBean.setComponents(pendingStorageDeviceArray3);
        }
        this.setValue("StorageDevices", pendingStorageDeviceArray2);
    }

    protected static ScriptElement[] getAddDeviceCommands(String string, String string2, String string3, PendingStorageDevice[] pendingStorageDeviceArray) {
        ArrayList<ScriptElement> arrayList = new ArrayList<ScriptElement>();
        arrayList.add(new CommandComment("wizard.appendpoolcommandpreview.comment.adddevice", new Object[0]));
        PrivilegedCommand privilegedCommand = new PrivilegedCommand(string, string2, new String[]{"/usr/sbin/zpool", "add"});
        privilegedCommand.appendArgs("-f");
        privilegedCommand.appendArgs(string3);
        privilegedCommand.appendArgs(AppendPoolWizardPageModel.getVDevSpec(pendingStorageDeviceArray));
        arrayList.add(privilegedCommand);
        return arrayList.toArray(new ScriptElement[arrayList.size()]);
    }

    protected static String[] getVDevSpec(PendingStorageDevice ... pendingStorageDeviceArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        AppendPoolWizardPageModel.getVDevSpec(arrayList, pendingStorageDeviceArray);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void getVDevSpec(List<String> list, PendingStorageDevice ... pendingStorageDeviceArray) {
        for (PendingStorageDevice pendingStorageDevice : pendingStorageDeviceArray) {
            if (pendingStorageDevice instanceof PendingAggregateStorageDevice) {
                if (pendingStorageDevice instanceof PendingMirror) {
                    list.add("mirror");
                } else if (pendingStorageDevice instanceof PendingRAID) {
                    list.add("raidz");
                }
                PendingStorageDevice[] pendingStorageDeviceArray2 = ((PendingAggregateStorageDevice)pendingStorageDevice).getComponents();
                AppendPoolWizardPageModel.getVDevSpec(list, pendingStorageDeviceArray2);
                continue;
            }
            list.add(pendingStorageDevice.getFriendlyName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VDEV_LAYOUTS {
        NORMAL,
        MIRROR,
        RAID;

    }
}

