/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.attachdevice;

import com.iplanet.jato.RequestContext;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.zfs.common.model.LeafVirtualDevice;
import com.sun.zfs.common.model.RAIDVirtualDevice;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.VirtualDevice;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.wizard.attachdevice.AttachDeviceAvailablePage;
import com.sun.zfs.web.admin.zfsmodule.wizard.attachdevice.AttachDeviceCommandPreviewPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.attachdevice.AttachDeviceReviewPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.attachdevice.AttachDeviceWizardPageModel;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.GenericWizard;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.ResultsPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;

public class AttachDeviceWizard
extends GenericWizard {
    private static final String TITLE = "wizard.attachdevice.title";
    private static final Class PAGE_MODEL_CLASS = AttachDeviceWizardPageModel.class;

    public AttachDeviceWizard(RequestContext requestContext) {
        super(requestContext, TITLE, AttachDeviceWizard.createPages(), PAGE_MODEL_CLASS);
    }

    public String[] getRequiredProfiles(WizardPageModel wizardPageModel) {
        return new String[]{"ZFS Storage Management", "ZFS Storage Management"};
    }

    public String[] getRequiredFields() {
        return new String[]{"PoolField", "VirtualDeviceIDField"};
    }

    public void init(WizardPageModel wizardPageModel) {
        long l;
        String string;
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        VirtualDevice virtualDevice = zDataModel.getVirtualDevice(string = (String)wizardPageModel.getValue("PoolField"), l = ((Long)wizardPageModel.getValue("VirtualDeviceIDField")).longValue());
        if (virtualDevice == null) {
            throw new IllegalArgumentException(Util.getText("wizard.attachdevice.error.nosuchdevice", new Object[0]));
        }
        AttachDeviceWizard.verifyCanBeAttached(virtualDevice);
        wizardPageModel.setValue("VirtualDeviceIndexField", virtualDevice.getIndex());
        wizardPageModel.setValue("VirtualDeviceField", ((LeafVirtualDevice)virtualDevice).getCommandLineName());
        wizardPageModel.setValue("ReplacementSizeField", virtualDevice.getReplacementSize());
    }

    public static void verifyCanBeAttached(VirtualDevice virtualDevice) {
        VirtualDevice virtualDevice2;
        Long l;
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        String string = virtualDevice.getPoolName();
        boolean bl = virtualDevice instanceof LeafVirtualDevice;
        if (bl && (l = virtualDevice.getParentIndex()) != null && (virtualDevice2 = zDataModel.getVirtualDevice(string, l)) != null && virtualDevice2 instanceof RAIDVirtualDevice) {
            bl = false;
        }
        if (!bl) {
            throw new IllegalArgumentException(Util.getText("wizard.attachdevice.error.partofraidz", new Object[0]));
        }
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new AttachDeviceWizard(requestContext);
    }

    private static WizardPage[] createPages() {
        return new WizardPage[]{new AttachDeviceAvailablePage(), new AttachDeviceReviewPage(), new AttachDeviceCommandPreviewPage(), new ResultsPage()};
    }
}

