/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.common;

import com.iplanet.jato.ModelManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.util.HtmlUtil;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.model.wizard.WizardInterfaceExt;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.IncompleteDataPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.InvalidDataPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.UserNoPrivilegesPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageStatus;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericWizard
implements WizardInterface,
WizardInterfaceExt {
    public static final String MODEL_CLEARED = "MODEL_CLEARED";
    private static final int PAGE_MODEL_VALIDATION_WAIT = 1000;
    private static final int PAGE_MODEL_VALIDATION_ATTEMPTS = 20;
    private static final String ATTR_PREFIX_PAGE_MODEL_NAME = "PAGE_MODEL_NAME_";
    private String title;
    private ArrayList<WizardPage> pages;
    private WizardPageModel pageModel;
    private Class pageModelClass;
    private Stack<WizardPage> pageStack = new Stack();
    private boolean showPreviousPages = true;

    public GenericWizard(RequestContext requestContext, String string, WizardPage[] wizardPageArray, Class clazz) {
        String[] stringArray;
        this.title = string;
        this.pageModelClass = clazz;
        this.pageModel = this.retrieveWizardPageModel(requestContext);
        boolean bl = false;
        if (!this.verifyRequiredFields(this.pageModel)) {
            wizardPageArray = new WizardPage[]{new IncompleteDataPage()};
        } else {
            try {
                this.init(this.pageModel);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                wizardPageArray = new WizardPage[]{new InvalidDataPage(illegalArgumentException.getMessage())};
            }
        }
        if (bl && !this.pageModel.verifyAuthorizedUser(stringArray = this.getRequiredProfiles(this.pageModel))) {
            wizardPageArray = new WizardPage[]{new UserNoPrivilegesPage()};
        }
        this.pages = new ArrayList();
        Collections.addAll(this.pages, wizardPageArray);
    }

    public boolean cancelStep(WizardEvent wizardEvent) {
        this.pageModel.clear();
        return true;
    }

    public boolean done(String string) {
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        return this.nextStep(wizardEvent);
    }

    public String getCancelPrompt(String string) {
        return this.getPage(string).getCancelPrompt();
    }

    public String getFirstPageId() {
        return this.pages.get(0).getPageID();
    }

    public String[] getFuturePages(String string) {
        WizardPage[] wizardPageArray = this.getFutureWizardPages(string);
        String[] stringArray = new String[wizardPageArray.length];
        for (int i = 0; i < wizardPageArray.length; ++i) {
            stringArray[i] = wizardPageArray[i].getPageID();
        }
        return stringArray;
    }

    public String[] getFutureSteps(String string) {
        WizardPage[] wizardPageArray = this.getFutureWizardPages(string);
        String[] stringArray = new String[wizardPageArray.length];
        for (int i = 0; i < wizardPageArray.length; ++i) {
            stringArray[i] = wizardPageArray[i].getStepText(this.pageModel);
        }
        return stringArray;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public String getNextPageId(String string) {
        int n = this.getPageIndex(string);
        try {
            WizardPage wizardPage;
            while (!(wizardPage = this.pages.get(++n)).getEnabled(this.pageModel)) {
            }
            return wizardPage.getPageID();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public Class getPageClass(String string) {
        return this.getPage(string).getPageClass();
    }

    public Model getPageModel(String string) {
        return this.pageModel;
    }

    public String getPageName(String string) {
        return this.getPage(string).getName();
    }

    public String getResourceBundle() {
        return "com.sun.zfs.web.admin.zfsmodule.resources.Resources";
    }

    public String[] getStepHelp(String string) {
        return this.getPage(string).getStepHelp(this.pageModel);
    }

    public String getStepInstruction(String string) {
        return this.getPage(string).getStepInstruction(this.pageModel);
    }

    public String getStepText(String string) {
        return this.getPage(string).getStepText(this.pageModel);
    }

    public String getStepTitle(String string) {
        return this.getPage(string).getStepTitle(this.pageModel);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean gotoStep(WizardEvent wizardEvent) {
        String string = wizardEvent.getGotoPageId();
        while (this.pageStack.size() > 0) {
            WizardPage wizardPage = this.pageStack.pop();
            wizardPage.reset(this.pageModel);
            if (!wizardPage.getPageID().equals(string)) continue;
            break;
        }
        return true;
    }

    public boolean hasPreviousPageId(String string) {
        if (this.pages.get(0).getPageID().equals(string)) {
            return false;
        }
        if (this.showPreviousPages) {
            this.showPreviousPages = !this.getPage(string).getIsResultsPage();
        }
        return this.showPreviousPages;
    }

    public boolean isFinishPageId(String string) {
        for (int i = this.pages.size() - 1; i >= 0; --i) {
            WizardPage wizardPage = this.pages.get(i);
            if (wizardPage.getIsResultsPage() || !wizardPage.getEnabled(this.pageModel)) continue;
            return wizardPage.getPageID().equals(string);
        }
        return false;
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        boolean bl = false;
        bl = Boolean.parseBoolean((String)this.pageModel.getValue("ConfirmReplyField"));
        WizardPageView wizardPageView = (WizardPageView)wizardEvent.getView();
        WizardPageModel wizardPageModel = (WizardPageModel)wizardPageView.getDefaultModel();
        WizardPageStatus wizardPageStatus = new WizardPageStatus(bl);
        WizardPage wizardPage = this.getPage(wizardEvent.getPageId());
        wizardPage.stepCompleted(wizardPageView, wizardPageModel, wizardPageStatus);
        boolean bl2 = true;
        String string = null;
        String string2 = wizardPageStatus.getErrorMessage();
        if (string2 != null) {
            wizardEvent.setSeverity(0);
            wizardEvent.setErrorMessage(string2);
            bl2 = false;
        } else {
            Object[] objectArray = wizardPageStatus.getConfirmMessages();
            if (objectArray.length != 0) {
                string = Util.join("\n", objectArray);
                wizardEvent.setSeverity(-1);
                bl2 = false;
            }
        }
        wizardPageModel.setValue("ConfirmMessageField", string);
        wizardPageModel.setValue("ConfirmReplyField", null);
        if (bl2) {
            this.pageStack.push(wizardPage);
        }
        return bl2;
    }

    public boolean previousStep(WizardEvent wizardEvent) {
        this.pageStack.pop().reset(this.pageModel);
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public boolean warnOnRevisitStep() {
        return false;
    }

    public boolean canBeStepLink(String string) {
        return this.showPreviousPages;
    }

    public void closeStep(WizardEvent wizardEvent) {
    }

    public String getPlaceholderText(String string) {
        return this.getPage(string).getPlaceholderText();
    }

    public String getResultsPageId(String string) {
        WizardPage wizardPage = this.pages.get(this.pages.size() - 1);
        if (wizardPage.getIsResultsPage()) {
            return wizardPage.getPageID();
        }
        return null;
    }

    public boolean helpTab(WizardEvent wizardEvent) {
        return true;
    }

    public boolean isSubstep(String string) {
        return this.getPage(string).isSubstep();
    }

    public boolean stepTab(WizardEvent wizardEvent) {
        return true;
    }

    protected String getNextPageIdOfClass(String string, Class clazz) {
        for (int i = this.getPageIndex(string) + 1; i < this.pages.size(); ++i) {
            WizardPage wizardPage = this.pages.get(i);
            if (!clazz.isInstance(wizardPage)) continue;
            return wizardPage.getPageID();
        }
        return null;
    }

    public abstract String[] getRequiredProfiles(WizardPageModel var1);

    public String[] getRequiredFields() {
        return new String[0];
    }

    public long getWaitBetweenPageModelValidationAttempts() {
        return 1000L;
    }

    public int getMaxPageModelValidationAttempts() {
        return 20;
    }

    public void init(WizardPageModel wizardPageModel) {
    }

    protected boolean verifyRequiredFields(WizardPageModel wizardPageModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, this.getRequiredFields());
        if (arrayList.size() == 0) {
            wizardPageModel.clearCompletely();
        } else {
            arrayList.add(0, MODEL_CLEARED);
            long l = this.getWaitBetweenPageModelValidationAttempts();
            int n = this.getMaxPageModelValidationAttempts();
            try {
                for (int i = 0; i < n; ++i) {
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        if (this.pageModel.getValue(string) == null) continue;
                        iterator.remove();
                    }
                    if (arrayList.size() != 0) {
                        Thread.sleep(l);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.pageModel.setValue(MODEL_CLEARED, null);
        return arrayList.size() == 0;
    }

    protected int getPageIndex(String string) {
        for (int i = 0; i < this.pages.size(); ++i) {
            if (!this.pages.get(i).getPageID().equals(string)) continue;
            return i;
        }
        return -1;
    }

    protected WizardPage getPage(String string) {
        try {
            return this.pages.get(this.getPageIndex(string));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    protected String getPageModelInstanceName() {
        return this.getClass().getName() + "_" + this.hashCode();
    }

    protected ArrayList<WizardPage> getPages() {
        return this.pages;
    }

    protected Stack<WizardPage> getPageStack() {
        return this.pageStack;
    }

    protected WizardPage[] getFutureWizardPages(String string) {
        int n = this.getPageIndex(string);
        if (n < 0) {
            return new WizardPage[0];
        }
        ArrayList<WizardPage> arrayList = new ArrayList<WizardPage>();
        for (int i = n + 1; i < this.pages.size() && this.pages.get(i - 1).getPlaceholderText() == null; ++i) {
            WizardPage wizardPage = this.pages.get(i);
            if (!wizardPage.getEnabled(this.pageModel) || wizardPage.isSubstep()) continue;
            arrayList.add(wizardPage);
        }
        return arrayList.toArray(new WizardPage[arrayList.size()]);
    }

    private WizardPageModel retrieveWizardPageModel(RequestContext requestContext) {
        String string = requestContext.getRequest().getParameter(GenericWizard.getPageModelNameAttribute(this.getClass()));
        if (string == null) {
            string = Integer.toString(HtmlUtil.getUniqueValue());
        }
        ModelManager modelManager = requestContext.getModelManager();
        WizardPageModel wizardPageModel = (WizardPageModel)modelManager.getModel(this.pageModelClass, string, true, false);
        wizardPageModel.clearDefaults();
        return wizardPageModel;
    }

    public static String getPageModelNameAttribute(Class clazz) {
        return ATTR_PREFIX_PAGE_MODEL_NAME + clazz.getName();
    }

    private static String getParameter(String string, RequestContext requestContext) {
        Map map = requestContext.getRequest().getParameterMap();
        String[] stringArray = (String[])map.get(string);
        return stringArray == null ? null : stringArray[0];
    }
}

