/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.destroydataset;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.Model;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.zfs.common.model.Dataset;
import com.sun.zfs.common.model.DatasetBean;
import com.sun.zfs.common.model.FileSystem;
import com.sun.zfs.common.model.Pool;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.Snapshot;
import com.sun.zfs.common.model.Volume;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.util.ModelUtil;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.GenericWizard;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.ResultsPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;
import com.sun.zfs.web.admin.zfsmodule.wizard.destroydataset.DestroyDatasetCommandPreviewPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.destroydataset.DestroyDatasetReviewPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.destroydataset.DestroyDatasetWizardPageModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public class DestroyDatasetWizard
extends GenericWizard {
    private static final String TITLE = "wizard.destroydataset.title";
    private static final Class PAGE_MODEL_CLASS = DestroyDatasetWizardPageModel.class;
    private String[] profiles;

    public DestroyDatasetWizard(RequestContext requestContext) {
        super(requestContext, TITLE, DestroyDatasetWizard.createPages(), PAGE_MODEL_CLASS);
    }

    public String getTitle() {
        Model model = this.getPageModel(this.getFirstPageId());
        return ModelUtil.getTypeSpecificText(model, TITLE, new Object[0]);
    }

    public String[] getRequiredProfiles(WizardPageModel wizardPageModel) {
        return this.profiles;
    }

    public String[] getRequiredFields() {
        return new String[]{"FullListField"};
    }

    public void init(WizardPageModel wizardPageModel) {
        String[] stringArray;
        Class[] classArray;
        Object object;
        String[] stringArray2 = (String[])wizardPageModel.getValue("FullListField");
        if (stringArray2.length > 1) {
            object = new ArrayList<String>(Arrays.asList(stringArray2));
            Collections.sort(object);
            classArray = null;
            stringArray = object.iterator();
            while (stringArray.hasNext()) {
                Class[] classArray2 = (Class[])stringArray.next();
                if (classArray != null && DatasetBean.isAncestor((String)classArray, (String)classArray2)) {
                    stringArray.remove();
                    continue;
                }
                classArray = classArray2;
            }
            stringArray2 = Util.toArray(object, String.class);
            wizardPageModel.setValue("FullListField", stringArray2);
        }
        object = DestroyDatasetWizard.getDatasets(stringArray2);
        this.profiles = DestroyDatasetWizard.getRequiredProfilesToDestroy((Dataset[])object);
        classArray = new Class[]{Snapshot.class, Pool.class, FileSystem.class, Volume.class};
        stringArray = new String[]{"Snapshot", "Pool", "FileSystem", "Volume"};
        block1: for (int i = 0; i < classArray.length; ++i) {
            for (Object object2 : object) {
                if (!classArray[i].isInstance(object2)) continue block1;
            }
            wizardPageModel.setValue("DatasetTypeField", stringArray[i]);
            break;
        }
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new DestroyDatasetWizard(requestContext);
    }

    private static WizardPage[] createPages() {
        return new WizardPage[]{new DestroyDatasetReviewPage(), new DestroyDatasetCommandPreviewPage(), new ResultsPage()};
    }

    public static String[] getRequiredProfilesToDestroy(Dataset ... datasetArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < datasetArray.length; ++i) {
            hashSet.add(datasetArray[i] instanceof Pool ? "ZFS Storage Management" : "ZFS File System Management");
        }
        return Util.toArray(hashSet, String.class);
    }

    private static Dataset[] getDatasets(String ... stringArray) {
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
        for (int i = 0; i < stringArray.length; ++i) {
            Dataset dataset = zDataModel.getDataset(stringArray[i]);
            if (dataset == null) continue;
            arrayList.add(dataset);
        }
        return Util.toArray(arrayList, Dataset.class);
    }

    public static String[] getRequiredProfilesToDestroy(String ... stringArray) {
        return DestroyDatasetWizard.getRequiredProfilesToDestroy(DestroyDatasetWizard.getDatasets(stringArray));
    }
}

