/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.detachdevice;

import com.iplanet.jato.RequestContext;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.zfs.common.model.DeviceStats;
import com.sun.zfs.common.model.LeafVirtualDevice;
import com.sun.zfs.common.model.MirrorVirtualDevice;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.VirtualDevice;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.GenericWizard;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.ResultsPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;
import com.sun.zfs.web.admin.zfsmodule.wizard.detachdevice.DetachDeviceCommandPreviewPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.detachdevice.DetachDeviceReviewPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.detachdevice.DetachDeviceWizardPageModel;

public class DetachDeviceWizard
extends GenericWizard {
    private static final String TITLE = "wizard.detachdevice.title";
    private static final Class PAGE_MODEL_CLASS = DetachDeviceWizardPageModel.class;

    public DetachDeviceWizard(RequestContext requestContext) {
        super(requestContext, TITLE, DetachDeviceWizard.createPages(), PAGE_MODEL_CLASS);
    }

    public String[] getRequiredProfiles(WizardPageModel wizardPageModel) {
        return new String[]{"ZFS Storage Management"};
    }

    public String[] getRequiredFields() {
        return new String[]{"PoolField", "VirtualDeviceIDField"};
    }

    public void init(WizardPageModel wizardPageModel) {
        long l;
        String string;
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        VirtualDevice virtualDevice = zDataModel.getVirtualDevice(string = (String)wizardPageModel.getValue("PoolField"), l = ((Long)wizardPageModel.getValue("VirtualDeviceIDField")).longValue());
        if (virtualDevice == null) {
            throw new IllegalArgumentException(Util.getText("wizard.detachdevice.error.nosuchdevice", new Object[0]));
        }
        DetachDeviceWizard.verifyCanBeDetached(virtualDevice);
        wizardPageModel.setValue("VirtualDeviceField", ((LeafVirtualDevice)virtualDevice).getCommandLineName());
    }

    public static void verifyCanBeDetached(VirtualDevice virtualDevice) {
        if (!(virtualDevice instanceof LeafVirtualDevice)) {
            throw new IllegalArgumentException(Util.getText("wizard.detachdevice.error.cantbedetached", new Object[0]));
        }
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        String string = virtualDevice.getPoolName();
        Long l = virtualDevice.getParentIndex();
        VirtualDevice virtualDevice2 = null;
        if (l != null) {
            virtualDevice2 = zDataModel.getVirtualDevice(string, l);
        }
        if (virtualDevice2 == null || !(virtualDevice2 instanceof MirrorVirtualDevice)) {
            throw new IllegalArgumentException(Util.getText("wizard.detachdevice.error.notpartofmirror", new Object[0]));
        }
        int n = 0;
        long l2 = virtualDevice.getIndex();
        VirtualDevice[] virtualDeviceArray = zDataModel.getVirtualDevices(string, l);
        for (int i = 0; i < virtualDeviceArray.length; ++i) {
            if (virtualDeviceArray[i].getIndex() == l2 || virtualDeviceArray[i].getDeviceState() != DeviceStats.DeviceState.VDEV_STATE_HEALTHY) continue;
            ++n;
        }
        if (n < 1) {
            throw new IllegalArgumentException(Util.getText("wizard.detachdevice.error.notenoughreplicas", new Object[0]));
        }
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new DetachDeviceWizard(requestContext);
    }

    private static WizardPage[] createPages() {
        return new WizardPage[]{new DetachDeviceReviewPage(), new DetachDeviceCommandPreviewPage(), new ResultsPage()};
    }
}

