/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.importpool;

import com.iplanet.jato.model.ModelControlException;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.zfs.common.model.ImportablePool;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.view.ImportPoolTableViewHelper;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageStatus;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageView;
import com.sun.zfs.web.admin.zfsmodule.wizard.importpool.ImportPoolSelectionPageView;

public class ImportPoolSelectionPage
extends WizardPage {
    public Class getPageClass() {
        return ImportPoolSelectionPageView.class;
    }

    public boolean isSubstep() {
        return true;
    }

    public String[] getStepHelp(WizardPageModel wizardPageModel) {
        return new String[]{"wizard.importpool.select.help"};
    }

    public String getStepInstruction(WizardPageModel wizardPageModel) {
        return "wizard.importpool.select.instructions";
    }

    public String getStepTitle(WizardPageModel wizardPageModel) {
        return "wizard.importpool.select.title";
    }

    public boolean getEnabled(WizardPageModel wizardPageModel) {
        String string = (String)wizardPageModel.getValue("ActionField");
        return string != null && string.equals("ActionSearch");
    }

    public void reset(WizardPageModel wizardPageModel) {
        wizardPageModel.setValue("TableCache", null);
        wizardPageModel.setValue("SelectedNamesField", null);
        wizardPageModel.setValue("SelectedPoolsField", null);
    }

    public void stepCompleted(WizardPageView wizardPageView, WizardPageModel wizardPageModel, WizardPageStatus wizardPageStatus) {
        int n;
        ImportPoolTableViewHelper importPoolTableViewHelper = ((ImportPoolSelectionPageView)wizardPageView).getTableViewHelper();
        Integer[] integerArray = null;
        CCActionTableModelInterface cCActionTableModelInterface = null;
        try {
            cCActionTableModelInterface = importPoolTableViewHelper.getTableModel();
            integerArray = cCActionTableModelInterface.getSelectedRows();
        }
        catch (ModelControlException modelControlException) {
            // empty catch block
        }
        if (integerArray == null || integerArray.length == 0) {
            wizardPageStatus.setErrorMessage("wizard.importpool.select.error.noselect");
            return;
        }
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        ImportablePool[] importablePoolArray = new ImportablePool[integerArray.length];
        String[] stringArray = new String[integerArray.length];
        for (n = 0; n < integerArray.length; ++n) {
            cCActionTableModelInterface.setRowIndex(integerArray[n].intValue());
            stringArray[n] = (String)cCActionTableModelInterface.getValue("NewName");
            if (stringArray[n].length() > 256) {
                wizardPageStatus.setErrorMessage(Util.getText("wizard.importpool.select.error.toolong", 256));
                return;
            }
            if (!Util.isValidPoolName(stringArray[n])) {
                wizardPageStatus.setErrorMessage(Util.getText("wizard.importpool.select.error.invalidname", stringArray[n]));
                return;
            }
            if (zDataModel.getPool(stringArray[n]) != null) {
                wizardPageStatus.setErrorMessage(Util.getText("wizard.importpool.select.error.poolexists", stringArray[n]));
                return;
            }
            importablePoolArray[n] = (ImportablePool)cCActionTableModelInterface.getValue("Value");
        }
        for (n = 0; n < stringArray.length - 1; ++n) {
            for (int i = n + 1; i < stringArray.length; ++i) {
                if (!stringArray[n].equals(stringArray[i])) continue;
                wizardPageStatus.setErrorMessage(Util.getText("wizard.importpool.select.error.dupnames", stringArray[n]));
                return;
            }
        }
        wizardPageModel.setValue("SelectedNamesField", stringArray);
        wizardPageModel.setValue("SelectedPoolsField", importablePoolArray);
    }
}

