/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.importpool;

import com.sun.zfs.common.model.ImportablePool;
import com.sun.zfs.common.util.Command;
import com.sun.zfs.common.util.CommandComment;
import com.sun.zfs.common.util.CommandSeparator;
import com.sun.zfs.common.util.PrivilegedCommand;
import com.sun.zfs.common.util.ScriptElement;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;
import java.util.ArrayList;

public class ImportPoolWizardPageModel
extends WizardPageModel {
    public static final String DEFAULT_IMPORT_DIR = "/dev/dsk";
    public static final String FIELD_SEARCHDIRS_VALUES = "SearchDirsValues";
    public static final String FIELD_SELECTED_NAMES = "SelectedNamesField";
    public static final String FIELD_SELECTED_POOLS = "SelectedPoolsField";

    public ImportPoolWizardPageModel() {
        this(null);
    }

    public ImportPoolWizardPageModel(String string) {
        super(string);
    }

    public ScriptElement[] getScript() {
        boolean bl = true;
        String string = (String)this.getValue("ActionField");
        boolean bl2 = false;
        String[] stringArray = null;
        ImportablePool[] importablePoolArray = null;
        if (string != null) {
            if (string.equals("ActionImportAll")) {
                bl2 = true;
                bl = false;
            } else {
                stringArray = (String[])this.getValue(FIELD_SELECTED_NAMES);
                importablePoolArray = (ImportablePool[])this.getValue(FIELD_SELECTED_POOLS);
                if (stringArray != null && importablePoolArray != null) {
                    bl = false;
                }
            }
        }
        if (bl) {
            return super.getIncompleteDataScript();
        }
        ArrayList<ScriptElement> arrayList = new ArrayList<ScriptElement>();
        String[] stringArray2 = (String[])this.getValue(FIELD_SEARCHDIRS_VALUES);
        if (stringArray2 != null) {
            switch (stringArray2.length) {
                case 0: {
                    stringArray2 = null;
                    break;
                }
                case 1: {
                    if (!stringArray2[0].equals(DEFAULT_IMPORT_DIR)) break;
                    stringArray2 = null;
                }
            }
        }
        if (bl2) {
            arrayList.add(new CommandComment("wizard.importpool.commandpreview.importall.comment", new Object[0]));
            Command command = this.getCommonCommand(stringArray2);
            command.appendArgs("-a");
            arrayList.add(command);
        } else {
            for (int i = 0; i < importablePoolArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = importablePoolArray[i].getName();
                arrayList.add(new CommandComment(Util.getText("wizard.importpool.commandpreview.importpool.comment", string3), new Object[0]));
                Command command = this.getCommonCommand(stringArray2);
                command.appendArgs(Util.longToUint64String(importablePoolArray[i].getId()));
                if (!string2.equals(string3)) {
                    command.appendArgs(string2);
                }
                arrayList.add(command);
                if (i == importablePoolArray.length - 1) continue;
                arrayList.add(new CommandSeparator());
            }
        }
        return arrayList.toArray(new ScriptElement[arrayList.size()]);
    }

    public String[][] getRefreshParams() {
        String[] stringArray;
        String string = (String)this.getValue("ActionField");
        if (string != null && string.equals("ActionSearch") && (stringArray = (String[])this.getValue(FIELD_SELECTED_NAMES)) != null && stringArray.length == 1) {
            return new String[][]{{"view", "dataset"}, {"dataset", stringArray[0]}};
        }
        return new String[][]{{"view", "pools"}};
    }

    private Command getCommonCommand(String[] stringArray) {
        PrivilegedCommand privilegedCommand = new PrivilegedCommand(this.getUser(), this.getPassword(), new String[]{"/usr/sbin/zpool", "import"});
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                privilegedCommand.appendArgs("-d", stringArray[i]);
            }
        }
        privilegedCommand.appendArgs("-f");
        return privilegedCommand;
    }
}

