/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.offlinedevice;

import com.iplanet.jato.RequestContext;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.zfs.common.model.DeviceStats;
import com.sun.zfs.common.model.LeafVirtualDevice;
import com.sun.zfs.common.model.MirrorVirtualDevice;
import com.sun.zfs.common.model.RAIDVirtualDevice;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.VirtualDevice;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.GenericWizard;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.ResultsPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;
import com.sun.zfs.web.admin.zfsmodule.wizard.offlinedevice.OfflineDeviceCommandPreviewPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.offlinedevice.OfflineDeviceReviewPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.offlinedevice.OfflineDeviceWizardPageModel;

public class OfflineDeviceWizard
extends GenericWizard {
    private static final String TITLE = "wizard.offlinedevice.title";
    private static final Class PAGE_MODEL_CLASS = OfflineDeviceWizardPageModel.class;

    public OfflineDeviceWizard(RequestContext requestContext) {
        super(requestContext, TITLE, OfflineDeviceWizard.createPages(), PAGE_MODEL_CLASS);
    }

    public String[] getRequiredProfiles(WizardPageModel wizardPageModel) {
        return new String[]{"ZFS Storage Management"};
    }

    public String[] getRequiredFields() {
        return new String[]{"PoolField", "VirtualDeviceIDField"};
    }

    public void init(WizardPageModel wizardPageModel) {
        long l;
        String string;
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        VirtualDevice virtualDevice = zDataModel.getVirtualDevice(string = (String)wizardPageModel.getValue("PoolField"), l = ((Long)wizardPageModel.getValue("VirtualDeviceIDField")).longValue());
        if (virtualDevice == null) {
            throw new IllegalArgumentException(Util.getText("wizard.offlinedevice.error.nosuchdevice", new Object[0]));
        }
        OfflineDeviceWizard.verifyCanBeOfflined(virtualDevice);
        wizardPageModel.setValue("VirtualDeviceField", ((LeafVirtualDevice)virtualDevice).getCommandLineName());
    }

    public static void verifyCanBeOfflined(VirtualDevice virtualDevice) {
        String string;
        ZDataModel zDataModel;
        if (!(virtualDevice instanceof LeafVirtualDevice)) {
            throw new IllegalArgumentException(Util.getText("wizard.offlinedevice.error.cantbeoffline", new Object[0]));
        }
        if (virtualDevice.getDeviceState() == DeviceStats.DeviceState.VDEV_STATE_OFFLINE) {
            throw new IllegalArgumentException(Util.getText("wizard.offlinedevice.error.alreadyoffline", new Object[0]));
        }
        int n = 0;
        VirtualDevice virtualDevice2 = null;
        VirtualDevice[] virtualDeviceArray = null;
        Long l = virtualDevice.getParentIndex();
        if (l != null && (virtualDevice2 = (zDataModel = SimpleZDataModel.getDefaultModel()).getVirtualDevice(string = virtualDevice.getPoolName(), l)) != null) {
            long l2 = virtualDevice.getIndex();
            virtualDeviceArray = zDataModel.getVirtualDevices(string, l);
            for (int i = 0; i < virtualDeviceArray.length; ++i) {
                if (virtualDeviceArray[i].getIndex() == l2 || virtualDeviceArray[i].getDeviceState() != DeviceStats.DeviceState.VDEV_STATE_HEALTHY) continue;
                ++n;
            }
        }
        if (virtualDevice2 == null || virtualDevice2 instanceof MirrorVirtualDevice && n == 0 || virtualDevice2 instanceof RAIDVirtualDevice && n < virtualDeviceArray.length - 1) {
            throw new IllegalArgumentException(Util.getText("wizard.offlinedevice.error.notenoughreplicas", new Object[0]));
        }
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new OfflineDeviceWizard(requestContext);
    }

    private static WizardPage[] createPages() {
        return new WizardPage[]{new OfflineDeviceReviewPage(), new OfflineDeviceCommandPreviewPage(), new ResultsPage()};
    }
}

