/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.onlinedevice;

import com.iplanet.jato.RequestContext;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.zfs.common.model.LeafVirtualDevice;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.VirtualDevice;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.GenericWizard;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.ResultsPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;
import com.sun.zfs.web.admin.zfsmodule.wizard.onlinedevice.OnlineDeviceCommandPreviewPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.onlinedevice.OnlineDeviceReviewPage;
import com.sun.zfs.web.admin.zfsmodule.wizard.onlinedevice.OnlineDeviceWizardPageModel;

public class OnlineDeviceWizard
extends GenericWizard {
    private static final String TITLE = "wizard.onlinedevice.title";
    private static final Class PAGE_MODEL_CLASS = OnlineDeviceWizardPageModel.class;

    public OnlineDeviceWizard(RequestContext requestContext) {
        super(requestContext, TITLE, OnlineDeviceWizard.createPages(), PAGE_MODEL_CLASS);
    }

    public String[] getRequiredProfiles(WizardPageModel wizardPageModel) {
        return new String[]{"ZFS Storage Management"};
    }

    public String[] getRequiredFields() {
        return new String[]{"PoolField", "VirtualDeviceIDField"};
    }

    public void init(WizardPageModel wizardPageModel) {
        long l;
        String string;
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        VirtualDevice virtualDevice = zDataModel.getVirtualDevice(string = (String)wizardPageModel.getValue("PoolField"), l = ((Long)wizardPageModel.getValue("VirtualDeviceIDField")).longValue());
        if (virtualDevice == null) {
            throw new IllegalArgumentException(Util.getText("wizard.onlinedevice.error.nosuchdevice", new Object[0]));
        }
        OnlineDeviceWizard.verifyCanBeOnlined(virtualDevice);
        wizardPageModel.setValue("VirtualDeviceField", ((LeafVirtualDevice)virtualDevice).getCommandLineName());
    }

    public static void verifyCanBeOnlined(VirtualDevice virtualDevice) {
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        String string = virtualDevice.getPoolName();
        boolean bl = true;
        if (!(virtualDevice instanceof LeafVirtualDevice)) {
            bl = false;
        } else {
            switch (virtualDevice.getDeviceState()) {
                case VDEV_STATE_OFFLINE: 
                case VDEV_STATE_CANT_OPEN: {
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (!bl) {
            throw new IllegalArgumentException(Util.getText("wizard.onlinedevice.error.notoffline", new Object[0]));
        }
    }

    public static WizardInterface create(RequestContext requestContext) {
        return new OnlineDeviceWizard(requestContext);
    }

    private static WizardPage[] createPages() {
        return new WizardPage[]{new OnlineDeviceReviewPage(), new OnlineDeviceCommandPreviewPage(), new ResultsPage()};
    }
}

