/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zfs.web.admin.zfsmodule.wizard.setvolumesize;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.zfs.common.model.SimpleZDataModel;
import com.sun.zfs.common.model.Volume;
import com.sun.zfs.common.model.ZDataModel;
import com.sun.zfs.common.util.Util;
import com.sun.zfs.web.admin.zfsmodule.taglib.ZDataSize;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageModel;
import com.sun.zfs.web.admin.zfsmodule.wizard.common.WizardPageView;
import java.text.DecimalFormat;

public class SetVolumeSizePageView
extends WizardPageView {
    private static final String PAGE_NAME = "SetVolumeSizePageView";
    private static final String PAGELET_URL = "/jsp/zfsmodule/SetVolumeSizePageView.jsp";
    public static final String CHILD_SIZE_VALUE_FIELD = "SizeValueField";
    public static final String CHILD_SIZE_UNITS_FIELD = "SizeUnitsField";
    public static final Option[] UNITS_OPTIONS = new Option[]{new Option("constants.bytes.short", "0"), new Option("constants.kilobytes.short", "1"), new Option("constants.megabytes.short", "2"), new Option("constants.gigabytes.short", "3"), new Option("constants.terabytes.short", "4"), new Option("constants.petabytes.short", "5"), new Option("constants.exabytes.short", "6")};

    public SetVolumeSizePageView(View view, Model model, String string, String string2) {
        super(view, model, string, string2);
        this.registerChildren();
    }

    public SetVolumeSizePageView(View view, Model model) {
        this(view, model, PAGE_NAME, PAGELET_URL);
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        WizardPageModel wizardPageModel = (WizardPageModel)this.getDefaultModel();
        String string = (String)wizardPageModel.getValue("FullNameField");
        this.populateSizeFields(wizardPageModel, string);
        super.beginDisplay(displayEvent);
    }

    protected View createChild(String string) {
        if (string.equals("MaximumSizeField") || string.equals("VolBlockSizeField")) {
            return new ZDataSize((ContainerView)this, string, null);
        }
        if (string.equals("FullNameField")) {
            return new CCStaticTextField((ContainerView)this, string, null);
        }
        if (string.equals(CHILD_SIZE_VALUE_FIELD)) {
            return new CCTextField((ContainerView)this, string, null);
        }
        if (string.equals(CHILD_SIZE_UNITS_FIELD)) {
            CCDropDownMenu cCDropDownMenu = new CCDropDownMenu((ContainerView)this, string, null);
            cCDropDownMenu.setTitle("labels.size");
            cCDropDownMenu.setOptions(new OptionList(UNITS_OPTIONS));
            return cCDropDownMenu;
        }
        return super.createChild(string);
    }

    protected void registerChildren() {
        this.registerChild("DatasetLabel", CCLabel.class);
        this.registerChild("FullNameField", CCStaticTextField.class);
        this.registerChild("SizeLabel", CCLabel.class);
        this.registerChild("MaximumSizeField", ZDataSize.class);
        this.registerChild("VolBlockSizeField", ZDataSize.class);
        this.registerChild(CHILD_SIZE_VALUE_FIELD, CCTextField.class);
        this.registerChild(CHILD_SIZE_UNITS_FIELD, CCDropDownMenu.class);
        super.registerChildren();
    }

    protected void populateSizeFields(WizardPageModel wizardPageModel, String string) {
        ZDataModel zDataModel = SimpleZDataModel.getDefaultModel();
        String string2 = "0";
        int n = 0;
        long l = 0L;
        Volume volume = zDataModel.getVolume(string);
        if (volume != null) {
            wizardPageModel.setValue("MaximumSizeField", volume.getAvailable() + volume.getUsed());
            wizardPageModel.setValue("VolBlockSizeField", volume.getBlockSize());
            DecimalFormat decimalFormat = new DecimalFormat("0.##");
            long l2 = volume == null ? 0L : volume.getSize();
            Util.DataSize dataSize = Util.getDataSize(l2, 2, null, null);
            string2 = decimalFormat.format(dataSize.value);
            n = dataSize.unitsIndex;
            l = (long)(dataSize.value * (double)(1 << 10 * dataSize.unitsIndex));
        }
        wizardPageModel.setDefaultValue(CHILD_SIZE_VALUE_FIELD, string2);
        wizardPageModel.setDefaultValue(CHILD_SIZE_UNITS_FIELD, UNITS_OPTIONS[n].getValue());
        wizardPageModel.setValue("OldSizeField", l);
    }
}

